/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.Bytes;

public class Append
extends Mutation {
    private static final String RETURN_RESULTS = "_rr_";
    private static final byte APPEND_VERSION = 1;

    public void setReturnResults(boolean returnResults) {
        this.setAttribute(RETURN_RESULTS, Bytes.toBytes(returnResults));
    }

    public boolean isReturnResults() {
        byte[] v = this.getAttribute(RETURN_RESULTS);
        return v == null ? true : Bytes.toBoolean(v);
    }

    public Append() {
    }

    public Append(byte[] row) {
        this.row = Arrays.copyOf(row, row.length);
    }

    public Append add(byte[] family, byte[] qualifier, byte[] value) {
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
        }
        list.add(new KeyValue(this.row, family, qualifier, this.ts, KeyValue.Type.Put, value));
        this.familyMap.put(family, list);
        return this;
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version > 1) {
            throw new IOException("version not supported: " + version);
        }
        this.row = Bytes.readByteArray(in);
        this.ts = in.readLong();
        this.lockId = in.readLong();
        this.writeToWAL = in.readBoolean();
        int numFamilies = in.readInt();
        if (!this.familyMap.isEmpty()) {
            this.familyMap.clear();
        }
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numKeys = in.readInt();
            ArrayList<KeyValue> keys = new ArrayList<KeyValue>(numKeys);
            int totalLen = in.readInt();
            byte[] buf = new byte[totalLen];
            int offset = 0;
            for (int j = 0; j < numKeys; ++j) {
                int keyLength = in.readInt();
                in.readFully(buf, offset, keyLength);
                keys.add(new KeyValue(buf, offset, keyLength));
                offset += keyLength;
            }
            this.familyMap.put(family, keys);
        }
        this.readAttributes(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        Bytes.writeByteArray(out, this.row);
        out.writeLong(this.ts);
        out.writeLong(this.lockId);
        out.writeBoolean(this.writeToWAL);
        out.writeInt(this.familyMap.size());
        for (Map.Entry entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, (byte[])entry.getKey());
            List keys = (List)entry.getValue();
            out.writeInt(keys.size());
            int totalLen = 0;
            for (KeyValue kv : keys) {
                totalLen += kv.getLength();
            }
            out.writeInt(totalLen);
            for (KeyValue kv : keys) {
                kv.write(out);
            }
        }
        this.writeAttributes(out);
    }

    public Append add(KeyValue kv) {
        if (kv.getType() != KeyValue.Type.Put.getCode()) {
            throw new IllegalArgumentException("Added type " + (Object)((Object)KeyValue.Type.codeToType(kv.getType())) + ", but appends can only be of type " + (Object)((Object)KeyValue.Type.Put) + ". Rowkey:" + Bytes.toStringBinary(kv.getRow()));
        }
        if (!kv.matchingRow(this.row)) {
            throw new IllegalArgumentException("The row in the recently added KeyValue " + Bytes.toStringBinary(kv.getRow()) + " doesn't match the original one " + Bytes.toStringBinary(this.row));
        }
        byte[] family = kv.getFamily();
        ArrayList<KeyValue> list = (ArrayList<KeyValue>)this.familyMap.get(family);
        if (list == null) {
            list = new ArrayList<KeyValue>();
            this.familyMap.put(family, list);
        }
        list.add(kv);
        return this;
    }
}

