/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;

public class SecureBulkLoadClient {
    private static Class protocolClazz;
    private static Class endpointClazz;
    private Object proxy;
    private HTable table;

    public SecureBulkLoadClient(HTable table) throws IOException {
        this(table, HConstants.EMPTY_START_ROW);
    }

    public SecureBulkLoadClient(HTable table, byte[] startRow) throws IOException {
        try {
            protocolClazz = protocolClazz != null ? protocolClazz : Class.forName("org.apache.hadoop.hbase.security.access.SecureBulkLoadProtocol");
            endpointClazz = endpointClazz != null ? endpointClazz : Class.forName("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
            this.proxy = table.coprocessorProxy(protocolClazz, startRow);
            this.table = table;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Failed to initialize SecureBulkLoad", e);
        }
    }

    public String prepareBulkLoad(byte[] tableName) throws IOException {
        try {
            String bulkToken = (String)Methods.call(protocolClazz, this.proxy, "prepareBulkLoad", new Class[]{byte[].class}, new Object[]{tableName});
            return bulkToken;
        }
        catch (Exception e) {
            throw new IOException("Failed to prepareBulkLoad", e);
        }
    }

    public void cleanupBulkLoad(String bulkToken) throws IOException {
        try {
            Methods.call(protocolClazz, this.proxy, "cleanupBulkLoad", new Class[]{String.class}, new Object[]{bulkToken});
        }
        catch (Exception e) {
            throw new IOException("Failed to prepareBulkLoad", e);
        }
    }

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, Token<?> userToken, String bulkToken) throws IOException {
        return this.bulkLoadHFiles(familyPaths, userToken, bulkToken, false);
    }

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, Token<?> userToken, String bulkToken, boolean assignSeqNum) throws IOException {
        try {
            return (Boolean)Methods.call(protocolClazz, this.proxy, "bulkLoadHFiles", new Class[]{List.class, Token.class, String.class, Boolean.TYPE}, new Object[]{familyPaths, userToken, bulkToken, assignSeqNum});
        }
        catch (Exception e) {
            throw new IOException("Failed to bulkLoadHFiles", e);
        }
    }

    public Path getStagingPath(String bulkToken, byte[] family) throws IOException {
        try {
            return (Path)Methods.call(endpointClazz, null, "getStagingPath", new Class[]{Configuration.class, String.class, byte[].class}, new Object[]{this.table.getConfiguration(), bulkToken, family});
        }
        catch (Exception e) {
            throw new IOException("Failed to getStagingPath", e);
        }
    }
}

