/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class HFileDataBlockEncoderImpl
implements HFileDataBlockEncoder {
    private final DataBlockEncoding onDisk;
    private final DataBlockEncoding inCache;

    public HFileDataBlockEncoderImpl(DataBlockEncoding encoding) {
        this(encoding, encoding);
    }

    public HFileDataBlockEncoderImpl(DataBlockEncoding onDisk, DataBlockEncoding inCache) {
        this.onDisk = onDisk != null ? onDisk : DataBlockEncoding.NONE;
        this.inCache = inCache != null ? inCache : DataBlockEncoding.NONE;
        Preconditions.checkArgument((onDisk == DataBlockEncoding.NONE || onDisk == inCache ? 1 : 0) != 0, (Object)("on-disk encoding (" + (Object)((Object)onDisk) + ") must be " + "either the same as in-cache encoding (" + (Object)((Object)inCache) + ") or " + (Object)((Object)DataBlockEncoding.NONE)));
    }

    public static HFileDataBlockEncoder createFromFileInfo(HFile.FileInfo fileInfo, DataBlockEncoding preferredEncodingInCache) throws IOException {
        DataBlockEncoding onDisk;
        boolean hasPreferredCacheEncoding = preferredEncodingInCache != null && preferredEncodingInCache != DataBlockEncoding.NONE;
        byte[] dataBlockEncodingType = (byte[])fileInfo.get(DATA_BLOCK_ENCODING);
        if (dataBlockEncodingType == null && !hasPreferredCacheEncoding) {
            return NoOpDataBlockEncoder.INSTANCE;
        }
        if (dataBlockEncodingType == null) {
            onDisk = DataBlockEncoding.NONE;
        } else {
            String dataBlockEncodingStr = Bytes.toString(dataBlockEncodingType);
            try {
                onDisk = DataBlockEncoding.valueOf(dataBlockEncodingStr);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid data block encoding type in file info: " + dataBlockEncodingStr, ex);
            }
        }
        DataBlockEncoding inCache = onDisk == DataBlockEncoding.NONE ? preferredEncodingInCache : onDisk;
        return new HFileDataBlockEncoderImpl(onDisk, inCache);
    }

    @Override
    public void saveMetadata(HFile.Writer writer) throws IOException {
        writer.appendFileInfo(DATA_BLOCK_ENCODING, this.onDisk.getNameInBytes());
    }

    @Override
    public DataBlockEncoding getEncodingOnDisk() {
        return this.onDisk;
    }

    @Override
    public DataBlockEncoding getEncodingInCache() {
        return this.inCache;
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        if (!this.useEncodedScanner(isCompaction)) {
            return DataBlockEncoding.NONE;
        }
        return this.inCache;
    }

    @Override
    public HFileBlock diskToCacheFormat(HFileBlock block, boolean isCompaction) {
        if (block.getBlockType() == BlockType.DATA) {
            if (!this.useEncodedScanner(isCompaction)) {
                return block;
            }
            return this.encodeDataBlock(block, this.inCache, block.doesIncludeMemstoreTS());
        }
        if (block.getBlockType() == BlockType.ENCODED_DATA) {
            if (block.getDataBlockEncodingId() == this.onDisk.getId()) {
                return block;
            }
            throw new AssertionError((Object)("Expected on-disk data block encoding " + (Object)((Object)this.onDisk) + ", got " + (Object)((Object)block.getDataBlockEncoding())));
        }
        return block;
    }

    @Override
    public Pair<ByteBuffer, BlockType> beforeWriteToDisk(ByteBuffer in, boolean includesMemstoreTS, byte[] dummyHeader) {
        if (this.onDisk == DataBlockEncoding.NONE) {
            return new Pair<ByteBuffer, BlockType>(in, BlockType.DATA);
        }
        ByteBuffer encodedBuffer = this.encodeBufferToHFileBlockBuffer(in, this.onDisk, includesMemstoreTS, dummyHeader);
        return new Pair<ByteBuffer, BlockType>(encodedBuffer, BlockType.ENCODED_DATA);
    }

    @Override
    public boolean useEncodedScanner(boolean isCompaction) {
        if (isCompaction && this.onDisk == DataBlockEncoding.NONE) {
            return false;
        }
        return this.inCache != DataBlockEncoding.NONE;
    }

    private ByteBuffer encodeBufferToHFileBlockBuffer(ByteBuffer in, DataBlockEncoding algo, boolean includesMemstoreTS, byte[] dummyHeader) {
        ByteArrayOutputStream encodedStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(encodedStream);
        DataBlockEncoder encoder = algo.getEncoder();
        try {
            encodedStream.write(dummyHeader);
            algo.writeIdInBytes(dataOut);
            encoder.compressKeyValues(dataOut, in, includesMemstoreTS);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Bug in data block encoder '%s', it probably requested too much data", algo.toString()), e);
        }
        return ByteBuffer.wrap(encodedStream.toByteArray());
    }

    private HFileBlock encodeDataBlock(HFileBlock block, DataBlockEncoding algo, boolean includesMemstoreTS) {
        ByteBuffer compressedBuffer = this.encodeBufferToHFileBlockBuffer(block.getBufferWithoutHeader(), algo, includesMemstoreTS, block.getDummyHeaderForVersion());
        int sizeWithoutHeader = compressedBuffer.limit() - block.headerSize();
        HFileBlock encodedBlock = new HFileBlock(BlockType.ENCODED_DATA, block.getOnDiskSizeWithoutHeader(), sizeWithoutHeader, block.getPrevBlockOffset(), compressedBuffer, true, block.getOffset(), includesMemstoreTS, block.getMinorVersion(), block.getBytesPerChecksum(), block.getChecksumType(), block.getOnDiskDataSizeWithHeader());
        block.passSchemaMetricsTo(encodedBlock);
        return encodedBlock;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(onDisk=" + (Object)((Object)this.onDisk) + ", inCache=" + (Object)((Object)this.inCache) + ")";
    }
}

