/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.Compressor;

public class HFileWriterV1
extends AbstractHFileWriter {
    static final String BLOOM_FILTER_META_KEY = "BLOOM_FILTER_META";
    public static final String BLOOM_FILTER_DATA_KEY = "BLOOM_FILTER_DATA";
    private static final Log LOG = LogFactory.getLog(HFileWriterV1.class);
    private DataOutputStream out;
    private long blockBegin;
    private ArrayList<byte[]> blockKeys = new ArrayList();
    private ArrayList<Long> blockOffsets = new ArrayList();
    private ArrayList<Integer> blockDataSizes = new ArrayList();
    private Compressor compressor;
    private ByteArrayOutputStream baos;
    private DataOutputStream baosDos;
    private int blockNumber = 0;

    public HFileWriterV1(Configuration conf, CacheConfig cacheConf, FileSystem fs, Path path, FSDataOutputStream ostream, int blockSize, Compression.Algorithm compress, HFileDataBlockEncoder blockEncoder, KeyValue.KeyComparator comparator) throws IOException {
        super(cacheConf, ostream == null ? HFileWriterV1.createOutputStream(conf, fs, path) : ostream, path, blockSize, compress, blockEncoder, comparator);
        SchemaMetrics.configureGlobally(conf);
    }

    private void checkBlockBoundary() throws IOException {
        if (this.out != null && this.out.size() < this.blockSize) {
            return;
        }
        this.finishBlock();
        this.newBlock();
    }

    private void finishBlock() throws IOException {
        if (this.out == null) {
            return;
        }
        long startTimeNs = System.nanoTime();
        int size = this.releaseCompressingStream(this.out);
        this.out = null;
        this.blockKeys.add(this.firstKeyInBlock);
        this.blockOffsets.add(this.blockBegin);
        this.blockDataSizes.add(size);
        this.totalUncompressedBytes += (long)size;
        HFile.offerWriteLatency(System.nanoTime() - startTimeNs);
        if (this.cacheConf.shouldCacheDataOnWrite()) {
            this.baosDos.flush();
            byte[] bytes = this.baos.toByteArray();
            HFileBlock block = new HFileBlock(BlockType.DATA, (int)(this.outputStream.getPos() - this.blockBegin), bytes.length, -1L, ByteBuffer.wrap(bytes, 0, bytes.length), true, this.blockBegin, false, 0, 0, ChecksumType.NULL.getCode(), (int)(this.outputStream.getPos() - this.blockBegin) + 24);
            block = this.blockEncoder.diskToCacheFormat(block, false);
            this.passSchemaMetricsTo(block);
            this.cacheConf.getBlockCache().cacheBlock(new BlockCacheKey(this.name, this.blockBegin, DataBlockEncoding.NONE, block.getBlockType()), block);
            this.baosDos.close();
        }
        ++this.blockNumber;
    }

    private void newBlock() throws IOException {
        this.blockBegin = this.outputStream.getPos();
        this.out = this.getCompressingStream();
        BlockType.DATA.write(this.out);
        this.firstKeyInBlock = null;
        if (this.cacheConf.shouldCacheDataOnWrite()) {
            this.baos = new ByteArrayOutputStream();
            this.baosDos = new DataOutputStream(this.baos);
            this.baosDos.write(HFileBlock.DUMMY_HEADER_NO_CHECKSUM);
        }
    }

    private DataOutputStream getCompressingStream() throws IOException {
        this.compressor = this.compressAlgo.getCompressor();
        OutputStream os = this.compressAlgo.createCompressionStream((OutputStream)this.outputStream, this.compressor, 0);
        return new DataOutputStream(os);
    }

    private int releaseCompressingStream(DataOutputStream dos) throws IOException {
        dos.flush();
        this.compressAlgo.returnCompressor(this.compressor);
        this.compressor = null;
        return dos.size();
    }

    @Override
    public void appendMetaBlock(String metaBlockName, Writable content) {
        byte[] cur;
        int i;
        byte[] key = Bytes.toBytes(metaBlockName);
        for (i = 0; i < this.metaNames.size() && Bytes.BYTES_RAWCOMPARATOR.compare(cur = (byte[])this.metaNames.get(i), 0, cur.length, key, 0, key.length) <= 0; ++i) {
        }
        this.metaNames.add(i, key);
        this.metaData.add(i, content);
    }

    @Override
    public void append(KeyValue kv) throws IOException {
        this.append(kv.getBuffer(), kv.getKeyOffset(), kv.getKeyLength(), kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
    }

    @Override
    public void append(byte[] key, byte[] value) throws IOException {
        this.append(key, 0, key.length, value, 0, value.length);
    }

    private void append(byte[] key, int koffset, int klength, byte[] value, int voffset, int vlength) throws IOException {
        boolean dupKey = this.checkKey(key, koffset, klength);
        this.checkValue(value, voffset, vlength);
        if (!dupKey) {
            this.checkBlockBoundary();
        }
        this.out.writeInt(klength);
        this.totalKeyLength += (long)klength;
        this.out.writeInt(vlength);
        this.totalValueLength += (long)vlength;
        this.out.write(key, koffset, klength);
        this.out.write(value, voffset, vlength);
        if (this.firstKeyInBlock == null) {
            this.firstKeyInBlock = new byte[klength];
            System.arraycopy(key, koffset, this.firstKeyInBlock, 0, klength);
        }
        this.lastKeyBuffer = key;
        this.lastKeyOffset = koffset;
        this.lastKeyLength = klength;
        ++this.entryCount;
        if (this.cacheConf.shouldCacheDataOnWrite()) {
            this.baosDos.writeInt(klength);
            this.baosDos.writeInt(vlength);
            this.baosDos.write(key, koffset, klength);
            this.baosDos.write(value, voffset, vlength);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.outputStream == null) {
            return;
        }
        this.blockEncoder.saveMetadata(this);
        this.finishBlock();
        FixedFileTrailer trailer = new FixedFileTrailer(1, 0);
        ArrayList<Long> metaOffsets = null;
        ArrayList<Integer> metaDataSizes = null;
        if (this.metaNames.size() > 0) {
            metaOffsets = new ArrayList<Long>(this.metaNames.size());
            metaDataSizes = new ArrayList<Integer>(this.metaNames.size());
            for (int i = 0; i < this.metaNames.size(); ++i) {
                long curPos = this.outputStream.getPos();
                metaOffsets.add(curPos);
                DataOutputStream dos = this.getCompressingStream();
                BlockType.META.write(dos);
                ((Writable)this.metaData.get(i)).write((DataOutput)dos);
                int size = this.releaseCompressingStream(dos);
                metaDataSizes.add(size);
            }
        }
        this.writeFileInfo(trailer, (DataOutput)this.outputStream);
        trailer.setLoadOnOpenOffset(HFileWriterV1.writeBlockIndex(this.outputStream, this.blockKeys, this.blockOffsets, this.blockDataSizes));
        LOG.info((Object)("Wrote a version 1 block index with " + this.blockKeys.size() + " keys"));
        if (this.metaNames.size() > 0) {
            HFileWriterV1.writeBlockIndex(this.outputStream, this.metaNames, metaOffsets, metaDataSizes);
        }
        trailer.setDataIndexCount(this.blockKeys.size());
        this.finishClose(trailer);
    }

    @Override
    protected void finishFileInfo() throws IOException {
        super.finishFileInfo();
        this.fileInfo.append(HFile.FileInfo.COMPARATOR, Bytes.toBytes(this.comparator.getClass().getName()), false);
    }

    @Override
    public void addInlineBlockWriter(InlineBlockWriter bloomWriter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addGeneralBloomFilter(BloomFilterWriter bfw) {
        this.appendMetaBlock(BLOOM_FILTER_META_KEY, bfw.getMetaWriter());
        Writable dataWriter = bfw.getDataWriter();
        if (dataWriter != null) {
            this.appendMetaBlock(BLOOM_FILTER_DATA_KEY, dataWriter);
        }
    }

    @Override
    public void addDeleteFamilyBloomFilter(BloomFilterWriter bfw) throws IOException {
        throw new IOException("Delete Bloom filter is not supported in HFile V1");
    }

    private static long writeBlockIndex(FSDataOutputStream out, List<byte[]> keys, List<Long> offsets, List<Integer> uncompressedSizes) throws IOException {
        long pos = out.getPos();
        if (keys.size() > 0) {
            BlockType.INDEX_V1.write((DataOutput)out);
            for (int i = 0; i < keys.size(); ++i) {
                out.writeLong(offsets.get(i).longValue());
                out.writeInt(uncompressedSizes.get(i).intValue());
                byte[] key = keys.get(i);
                Bytes.writeByteArray((DataOutput)out, key);
            }
        }
        return pos;
    }

    static class WriterFactoryV1
    extends HFile.WriterFactory {
        WriterFactoryV1(Configuration conf, CacheConfig cacheConf) {
            super(conf, cacheConf);
        }

        @Override
        public HFile.Writer createWriter(FileSystem fs, Path path, FSDataOutputStream ostream, int blockSize, Compression.Algorithm compressAlgo, HFileDataBlockEncoder dataBlockEncoder, KeyValue.KeyComparator comparator, ChecksumType checksumType, int bytesPerChecksum, boolean includeMVCCReadpoint) throws IOException {
            return new HFileWriterV1(this.conf, this.cacheConf, fs, path, ostream, blockSize, compressAlgo, dataBlockEncoder, comparator);
        }
    }
}

