/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.UserProvider;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.HRegionPartitioner;
import org.apache.hadoop.hbase.mapred.TableInputFormat;
import org.apache.hadoop.hbase.mapred.TableMap;
import org.apache.hadoop.hbase.mapred.TableOutputFormat;
import org.apache.hadoop.hbase.mapred.TableReduce;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.zookeeper.ClusterId;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.security.token.Token;
import org.apache.zookeeper.KeeperException;

@Deprecated
public class TableMapReduceUtil {
    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, JobConf job) {
        TableMapReduceUtil.initTableMapJob(table, columns, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapJob(String table, String columns, Class<? extends TableMap> mapper, Class<? extends WritableComparable> outputKeyClass, Class<? extends Writable> outputValueClass, JobConf job, boolean addDependencyJars) {
        job.setInputFormat(TableInputFormat.class);
        job.setMapOutputValueClass(outputValueClass);
        job.setMapOutputKeyClass(outputKeyClass);
        job.setMapperClass(mapper);
        FileInputFormat.addInputPaths((JobConf)job, (String)table);
        job.set("hbase.mapred.tablecolumns", columns);
        if (addDependencyJars) {
            try {
                TableMapReduceUtil.addDependencyJars(job);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            TableMapReduceUtil.initCredentials(job);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job) throws IOException {
        TableMapReduceUtil.initTableReduceJob(table, reducer, job, null);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job, Class partitioner) throws IOException {
        TableMapReduceUtil.initTableReduceJob(table, reducer, job, partitioner, true);
    }

    public static void initTableReduceJob(String table, Class<? extends TableReduce> reducer, JobConf job, Class partitioner, boolean addDependencyJars) throws IOException {
        job.setOutputFormat(TableOutputFormat.class);
        job.setReducerClass(reducer);
        job.set("hbase.mapred.outputtable", table);
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Put.class);
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            HTable outputTable = new HTable(HBaseConfiguration.create((Configuration)job), table);
            int regions = outputTable.getRegionsInfo().size();
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(outputTable.getRegionsInfo().size());
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void initCredentials(JobConf job) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)job);
        if (provider.isHadoopSecurityEnabled() && System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            job.set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        if (provider.isHBaseSecurityEnabled()) {
            try {
                User user = provider.getCurrent();
                Token<?> authToken = TableMapReduceUtil.getAuthToken((Configuration)job, user);
                if (authToken == null) {
                    user.obtainAuthTokenForJob(job);
                } else {
                    job.getCredentials().addToken(authToken.getService(), authToken);
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                Thread.interrupted();
            }
        }
    }

    private static Token<?> getAuthToken(Configuration conf, User user) throws IOException, InterruptedException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "mr-init-credentials", null);
        try {
            String clusterId = ClusterId.readClusterIdZNode(zkw);
            Token<?> token = user.getToken("HBASE_AUTH_TOKEN", clusterId);
            return token;
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        finally {
            zkw.close();
        }
    }

    public static void limitNumReduceTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(HBaseConfiguration.create((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void limitNumMapTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(HBaseConfiguration.create((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        if (job.getNumMapTasks() > regions) {
            job.setNumMapTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(HBaseConfiguration.create((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        job.setNumReduceTasks(regions);
    }

    public static void setNumMapTasks(String table, JobConf job) throws IOException {
        HTable outputTable = new HTable(HBaseConfiguration.create((Configuration)job), table);
        int regions = outputTable.getRegionsInfo().size();
        job.setNumMapTasks(regions);
    }

    public static void setScannerCaching(JobConf job, int batchSize) {
        job.setInt("hbase.client.scanner.caching", batchSize);
    }

    public static void addDependencyJars(JobConf job) throws IOException {
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.addHBaseDependencyJars((Configuration)job);
        org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil.addDependencyJars((Configuration)job, job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getPartitionerClass(), job.getClass("mapred.input.format.class", TextInputFormat.class, InputFormat.class), job.getClass("mapred.output.format.class", TextOutputFormat.class, OutputFormat.class), job.getCombinerClass());
    }
}

