/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.iterators.UnmodifiableIterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class CompoundConfiguration
extends Configuration {
    private Configuration mutableConf = null;
    protected List<ImmutableConfigMap> configs = new ArrayList<ImmutableConfigMap>();

    void freezeMutableConf() {
        if (this.mutableConf == null) {
            return;
        }
        this.configs.add(0, new ImmutableConfWrapper(this.mutableConf));
        this.mutableConf = null;
    }

    public CompoundConfiguration add(Configuration conf) {
        this.freezeMutableConf();
        if (conf instanceof CompoundConfiguration) {
            this.configs.addAll(0, ((CompoundConfiguration)conf).configs);
            return this;
        }
        this.configs.add(0, new ImmutableConfWrapper(conf));
        return this;
    }

    public CompoundConfiguration add(final Map<ImmutableBytesWritable, ImmutableBytesWritable> map) {
        this.freezeMutableConf();
        this.configs.add(0, new ImmutableConfigMap(){
            Map<ImmutableBytesWritable, ImmutableBytesWritable> m;
            {
                this.m = map;
            }

            @Override
            public String get(String key) {
                ImmutableBytesWritable ibw = new ImmutableBytesWritable(Bytes.toBytes(key));
                if (!this.m.containsKey(ibw)) {
                    return null;
                }
                ImmutableBytesWritable value = this.m.get(ibw);
                if (value == null || value.get() == null) {
                    return null;
                }
                return Bytes.toString(value.get());
            }

            @Override
            public String getRaw(String key) {
                return this.get(key);
            }

            @Override
            public Class<?> getClassByName(String name) throws ClassNotFoundException {
                return null;
            }

            @Override
            public int size() {
                return this.m.size();
            }

            public String toString() {
                return this.m.toString();
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                final Iterator<Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable>> entries = this.m.entrySet().iterator();
                return new Iterator<Map.Entry<String, String>>(){

                    @Override
                    public boolean hasNext() {
                        return entries.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        final Map.Entry e = (Map.Entry)entries.next();
                        return new Map.Entry<String, String>(){

                            @Override
                            public String setValue(String value) {
                                throw new UnsupportedOperationException("Cannot set value on entry from a CompoundConfiguration!");
                            }

                            @Override
                            public String getValue() {
                                ImmutableBytesWritable bytes = (ImmutableBytesWritable)e.getValue();
                                if (bytes != null) {
                                    return Bytes.toString(bytes.get(), bytes.getOffset(), bytes.getLength());
                                }
                                return null;
                            }

                            @Override
                            public String getKey() {
                                ImmutableBytesWritable bytes = (ImmutableBytesWritable)e.getKey();
                                return Bytes.toString(bytes.get(), bytes.getOffset(), bytes.getLength());
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove an entry from a CompoundConfiguration iterator");
                    }
                };
            }
        });
        return this;
    }

    public CompoundConfiguration addStringMap(final Map<String, String> map) {
        this.freezeMutableConf();
        this.configs.add(0, new ImmutableConfigMap(){
            Map<String, String> m;
            {
                this.m = map;
            }

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return map.entrySet().iterator();
            }

            @Override
            public String get(String key) {
                return this.m.get(key);
            }

            @Override
            public String getRaw(String key) {
                return this.get(key);
            }

            @Override
            public Class<?> getClassByName(String name) throws ClassNotFoundException {
                return null;
            }

            @Override
            public int size() {
                return this.m.size();
            }

            public String toString() {
                return this.m.toString();
            }
        });
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("CompoundConfiguration: " + this.configs.size() + " configs");
        for (ImmutableConfigMap m : this.configs) {
            sb.append(this.configs);
        }
        return sb.toString();
    }

    public String get(String key) {
        String value;
        if (this.mutableConf != null && (value = this.mutableConf.get(key)) != null) {
            return value;
        }
        for (ImmutableConfigMap m : this.configs) {
            String value2 = m.get(key);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public String getRaw(String key) {
        String value;
        if (this.mutableConf != null && (value = this.mutableConf.getRaw(key)) != null) {
            return value;
        }
        for (ImmutableConfigMap m : this.configs) {
            String value2 = m.getRaw(key);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        Class value;
        if (this.mutableConf != null && (value = this.mutableConf.getClassByName(name)) != null) {
            return value;
        }
        for (ImmutableConfigMap m : this.configs) {
            try {
                Class<?> value2 = m.getClassByName(name);
                if (value2 == null) continue;
                return value2;
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException();
    }

    public int size() {
        int ret = 0;
        if (this.mutableConf != null) {
            ret += this.mutableConf.size();
        }
        for (ImmutableConfigMap m : this.configs) {
            ret += m.size();
        }
        return ret;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        HashMap ret = new HashMap();
        if (!this.configs.isEmpty()) {
            for (int i = this.configs.size() - 1; i >= 0; --i) {
                ImmutableConfigMap map = this.configs.get(i);
                for (Map.Entry entry : map) {
                    ret.put(entry.getKey(), entry.getValue());
                }
            }
        }
        if (this.mutableConf != null) {
            for (Map.Entry entry : this.mutableConf) {
                ret.put(entry.getKey(), entry.getValue());
            }
        }
        return UnmodifiableIterator.decorate(ret.entrySet().iterator());
    }

    public String get(String name, String defaultValue) {
        String ret = this.get(name);
        return ret == null ? defaultValue : ret;
    }

    public void set(String name, String value) {
        if (this.mutableConf == null) {
            this.mutableConf = new Configuration(false);
        }
        this.mutableConf.set(name, value);
    }

    public void clear() {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    public void writeXml(OutputStream out) throws IOException {
        throw new UnsupportedOperationException("Immutable Configuration");
    }

    static class ImmutableConfWrapper
    implements ImmutableConfigMap {
        Configuration c;

        ImmutableConfWrapper(Configuration conf) {
            this.c = conf;
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return this.c.iterator();
        }

        @Override
        public String get(String key) {
            return this.c.get(key);
        }

        @Override
        public String getRaw(String key) {
            return this.c.getRaw(key);
        }

        @Override
        public Class<?> getClassByName(String name) throws ClassNotFoundException {
            return this.c.getClassByName(name);
        }

        @Override
        public int size() {
            return this.c.size();
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private static interface ImmutableConfigMap
    extends Iterable<Map.Entry<String, String>> {
        public String get(String var1);

        public String getRaw(String var1);

        public Class<?> getClassByName(String var1) throws ClassNotFoundException;

        public int size();
    }
}

