/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

class SplitRequest
implements Runnable {
    static final Log LOG = LogFactory.getLog(SplitRequest.class);
    private final HRegion parent;
    private final byte[] midKey;
    private final HRegionServer server;

    SplitRequest(HRegion region, byte[] midKey, HRegionServer hrs) {
        Preconditions.checkNotNull((Object)hrs);
        this.parent = region;
        this.midKey = midKey;
        this.server = hrs;
    }

    public String toString() {
        return "regionName=" + this.parent + ", midKey=" + Bytes.toStringBinary(this.midKey);
    }

    @Override
    public void run() {
        if (this.server.isStopping() || this.server.isStopped()) {
            LOG.debug((Object)("Skipping split because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped()));
            return;
        }
        try {
            long startTime = System.currentTimeMillis();
            SplitTransaction st = new SplitTransaction(this.parent, this.midKey);
            if (!st.prepare()) {
                return;
            }
            try {
                st.execute(this.server, this.server);
                this.server.getMetrics().incrementSplitSuccessCount();
            }
            catch (Exception e) {
                if (this.server.isStopping() || this.server.isStopped()) {
                    LOG.info((Object)("Skip rollback/cleanup of failed split of " + this.parent.getRegionNameAsString() + " because server is" + (this.server.isStopping() ? " stopping" : " stopped")), (Throwable)e);
                    return;
                }
                try {
                    LOG.info((Object)("Running rollback/cleanup of failed split of " + this.parent.getRegionNameAsString() + "; " + e.getMessage()), (Throwable)e);
                    if (st.rollback(this.server, this.server)) {
                        LOG.info((Object)("Successful rollback of failed split of " + this.parent.getRegionNameAsString()));
                        this.server.getMetrics().incrementSplitFailureCount();
                    } else {
                        this.server.abort("Abort; we got an error after point-of-no-return");
                    }
                }
                catch (RuntimeException ee) {
                    String msg = "Failed rollback of failed split of " + this.parent.getRegionNameAsString() + " -- aborting server";
                    LOG.info((Object)msg, (Throwable)ee);
                    this.server.abort(msg + " -- Cause: " + ee.getMessage());
                }
                return;
            }
            LOG.info((Object)("Region split, META updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)System.currentTimeMillis(), (long)startTime)));
        }
        catch (IOException ex) {
            LOG.error((Object)("Split failed " + this), (Throwable)RemoteExceptionHandler.checkIOException(ex));
            this.server.getMetrics().incrementSplitFailureCount();
            this.server.checkFileSystem();
        }
    }
}

