/*
 * Decompiled with CFR 0.152.
 */
package pdi.jobentry.dummy;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.logging.LogChannel;

public class DummyJob {
    private String _wildcard;
    private String _targetDir;
    private String _sourceDir;

    public DummyJob(String source, String target, String wildcard) {
        this._sourceDir = source;
        this._targetDir = target;
        this._wildcard = wildcard;
    }

    public long process() throws KettleJobException, FileNotFoundException {
        LogChannel log = new LogChannel((Object)this);
        File srcDir = this.getDir(this._sourceDir);
        Pattern pattern = null;
        if (!Const.isEmpty((String)this._wildcard)) {
            pattern = Pattern.compile(this._wildcard);
        }
        final Pattern fpat = pattern;
        FileFilter regexFiler = new FileFilter(){

            public boolean accept(File pathname) {
                if (fpat == null) {
                    return true;
                }
                return fpat.matcher(pathname.getName()).matches();
            }
        };
        long files = 0L;
        File[] allFiles = srcDir.listFiles(regexFiler);
        File outDir = new File(this._targetDir);
        outDir.mkdirs();
        int i = 0;
        while (i < allFiles.length) {
            File cFile = allFiles[i];
            log.logDetailed(this.toString(), new Object[]{"processing file '" + cFile + "'"});
            this.processFile(cFile, outDir);
            ++i;
        }
        return files;
    }

    public File getDir(String dirname) throws KettleJobException {
        File fl = new File(dirname);
        if (!fl.isDirectory()) {
            throw new KettleJobException("'" + dirname + "' is not a directory");
        }
        return fl;
    }

    public void processFile(File fl, File outDir) throws FileNotFoundException {
    }
}

