/*
 * Decompiled with CFR 0.152.
 */
package pdi.jobentry.dummy;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;
import pdi.jobentry.dummy.DummyJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDummy
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static final String WILDCARD = "wildcard";
    private static final String TARGETDIRECTORY = "targetdirectory";
    private static final String SOURCEDIRECTORY = "sourcedirectory";
    private String sourceDirectory;
    private String targetDirectory;
    private String wildcard;

    public final String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public final void setSourceDirectory(String sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public final String getWildcard() {
        return this.wildcard;
    }

    public final void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public JobEntryDummy(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryDummy() {
        this("");
    }

    public Object clone() {
        JobEntryDummy je = (JobEntryDummy)super.clone();
        return je;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      " + XMLHandler.addTagValue((String)SOURCEDIRECTORY, (String)this.sourceDirectory));
        retval.append("      " + XMLHandler.addTagValue((String)TARGETDIRECTORY, (String)this.targetDirectory));
        retval.append("      " + XMLHandler.addTagValue((String)WILDCARD, (String)this.wildcard));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.sourceDirectory = XMLHandler.getTagValue((Node)entrynode, (String)SOURCEDIRECTORY);
            this.targetDirectory = XMLHandler.getTagValue((Node)entrynode, (String)TARGETDIRECTORY);
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)WILDCARD);
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load file exists job entry from XML node", (Throwable)xe);
        }
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.sourceDirectory = rep.getJobEntryAttributeString(id_jobentry, SOURCEDIRECTORY);
            this.targetDirectory = rep.getJobEntryAttributeString(id_jobentry, TARGETDIRECTORY);
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, WILDCARD);
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry for type file exists from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), SOURCEDIRECTORY, this.sourceDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), TARGETDIRECTORY, this.targetDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), WILDCARD, this.wildcard);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("unable to save jobentry of type 'file exists' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public Result execute(Result prev_result, int nr) {
        Result result = new Result(nr);
        result.setResult(false);
        long filesRetrieved = 0L;
        this.logDetailed(this.toString(), new Object[]{"Start of processing"});
        String realWildcard = this.environmentSubstitute(this.wildcard);
        String realTargetDirectory = this.environmentSubstitute(this.targetDirectory);
        String realSourceDirectory = this.environmentSubstitute(this.sourceDirectory);
        DummyJob proc = new DummyJob(realSourceDirectory, realTargetDirectory, realWildcard);
        try {
            filesRetrieved = proc.process();
            result.setResult(true);
            result.setNrFilesRetrieved(filesRetrieved);
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            e.printStackTrace();
            this.logError(this.toString(), new Object[]{"Error processing DummyJob : " + e.getMessage()});
        }
        return result;
    }

    public boolean evaluates() {
        return true;
    }
}

