/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown.devtools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.pentaho.reporting.engine.classic.core.metadata.MaturityLevel;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public abstract class AbstractDrillDownEditor
extends CommonDialog {
    private JTextField nameTextField;
    private JTextField bundleTextField;
    private JCheckBox expertBox;
    private JCheckBox hiddenBox;
    private JCheckBox deprecatedBox;
    private JCheckBox preferredBox;

    public AbstractDrillDownEditor() {
        this.init();
    }

    public AbstractDrillDownEditor(Dialog parent) {
        super(parent);
        this.init();
    }

    public AbstractDrillDownEditor(Frame parent) {
        super(parent);
        this.init();
    }

    protected void init() {
        this.nameTextField = new JTextField();
        this.bundleTextField = new JTextField();
        this.expertBox = new JCheckBox("Expert");
        this.hiddenBox = new JCheckBox("Hidden");
        this.deprecatedBox = new JCheckBox("Deprecated");
        this.preferredBox = new JCheckBox("Preferred");
        super.init();
    }

    protected Component createContentPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)new JLabel("Name"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.nameTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)new JLabel("Bundle"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.bundleTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        panel.add((Component)this.expertBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        panel.add((Component)this.hiddenBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        panel.add((Component)this.deprecatedBox, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        panel.add((Component)this.preferredBox, gbc);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)panel, "North");
        contentPane.add(this.createDetailPane());
        return contentPane;
    }

    protected abstract Component createDetailPane();

    public boolean isExpert() {
        return this.expertBox.isSelected();
    }

    public void setExpert(boolean b) {
        this.expertBox.setSelected(b);
    }

    public boolean isHidden() {
        return this.hiddenBox.isSelected();
    }

    public void setHidden(boolean b) {
        this.hiddenBox.setSelected(b);
    }

    public boolean isDeprecated() {
        return this.deprecatedBox.isSelected();
    }

    public void setDeprecated(boolean b) {
        this.deprecatedBox.setSelected(b);
    }

    public boolean isPreferred() {
        return this.preferredBox.isSelected();
    }

    public void setPreferred(boolean b) {
        this.preferredBox.setSelected(b);
    }

    public String getProfileName() {
        return this.nameTextField.getText();
    }

    public void setProfileName(String name) {
        this.nameTextField.setText(name);
    }

    public String getBundleName() {
        return this.bundleTextField.getText();
    }

    public void setBundleName(String name) {
        this.bundleTextField.setText(name);
    }

    public void updateUi(DrillDownProfile profile) {
        if (profile == null) {
            this.setBundleName(null);
            this.setProfileName(null);
            this.setDeprecated(false);
            this.setHidden(false);
            this.setPreferred(false);
            this.setExpert(false);
            return;
        }
        this.setBundleName(profile.getBundleLocation());
        this.setProfileName(profile.getName());
        this.setDeprecated(profile.isDeprecated());
        this.setHidden(profile.isHidden());
        this.setPreferred(profile.isPreferred());
        this.setExpert(profile.isExpert());
    }

    protected abstract Class getCustomizerType();

    public DrillDownProfile createFromUI() {
        return new DrillDownProfile(this.getProfileName(), this.getBundleName(), this.getProfileName() + ".", this.isExpert(), this.isPreferred(), this.isHidden(), this.isDeprecated(), this.getCustomizerType(), this.getAttributes(), MaturityLevel.Production, -1);
    }

    protected abstract Map<String, String> getAttributes();

    public DrillDownProfile performEdit(DrillDownProfile profile) {
        this.updateUi(profile);
        if (super.performEdit()) {
            return this.createFromUI();
        }
        return null;
    }
}

