/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.store.AbstractCodeStore;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;

public class ProfileCodeStore
extends AbstractCodeStore {
    private Document tableDoc;

    public ProfileCodeStore(String uri) throws ProfileException, IOException {
        try {
            if (uri == null) {
                throw new ProfileException("The input url parameter cannot be null");
            }
            this.tableDoc = new SAXBuilder().build(uri);
        }
        catch (ProfileException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProfileException(e.toString(), e);
        }
    }

    public ProfileCodeStore(URL url) throws ProfileException, IOException {
        if (url == null) {
            throw new ProfileException("The input url parameter cannot be null");
        }
        try {
            this.tableDoc = new SAXBuilder().build(url);
        }
        catch (JDOMException e) {
            throw new ProfileException(e.toString(), e);
        }
    }

    public String[] getValidCodes(String codeSystem) throws ProfileException {
        String[] codeValues = null;
        try {
            Element table = this.getCodeTable(codeSystem);
            List tableElementList = table.getChildren("tableElement");
            Iterator itr = tableElementList.iterator();
            codeValues = new String[tableElementList.size()];
            int i = 0;
            while (itr.hasNext()) {
                Element tableElement = (Element)itr.next();
                codeValues[i] = tableElement.getAttributeValue("code");
                ++i;
            }
        }
        catch (NullPointerException e) {
            throw new ProfileException("The spec xml table doc is missing one or more of the following: tableElement element, code attribute", e);
        }
        return codeValues;
    }

    public boolean knowsCodes(String codeSystem) {
        try {
            Element table = this.getCodeTable(codeSystem);
            return table != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Element getCodeTable(String codeSystem) throws ProfileException {
        Element table = null;
        if (codeSystem == null) {
            throw new ProfileException("The input codeSystem parameter cannot be null");
        }
        if (codeSystem.length() < 4) {
            throw new ProfileException("The input codeSystem parameter cannot be less than 4 characters long");
        }
        try {
            String tableId = codeSystem.substring(codeSystem.length() - 4);
            XPath path = XPath.newInstance((String)("/Specification/hl7tables/hl7table[@id='" + tableId + "']"));
            table = (Element)path.selectSingleNode((Object)this.tableDoc);
        }
        catch (Exception e) {
            throw new ProfileException(e.toString(), e);
        }
        return table;
    }
}

