/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.mondrian;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import mondrian.mdx.MemberExpr;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.server.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.PropertyLookupParser;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MondrianConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MondrianUtil;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formatting.FastMessageFormat;

public abstract class AbstractMDXDataFactory
extends AbstractDataFactory {
    private static final String ACCEPT_ROLES_CONFIG_KEY = "org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.role-filter.static.accept";
    private static final String ACCEPT_REGEXP_CONFIG_KEY = "org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.role-filter.reg-exp.accept";
    private static final String DENY_ROLE_CONFIG_KEY = "org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.role-filter.static.deny";
    private static final String DENY_REGEXP_CONFIG_KEY = "org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.role-filter.reg-exp.deny";
    private static final String ROLE_FILTER_ENABLE_CONFIG_KEY = "org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.role-filter.enable";
    private String jdbcUser;
    private String jdbcUserField;
    private String jdbcPassword;
    private String jdbcPasswordField;
    private String dynamicSchemaProcessor;
    private Boolean useSchemaPool;
    private Boolean useContentChecksum;
    private Properties baseConnectionProperties;
    private String role;
    private String roleField;
    private CubeFileProvider cubeFileProvider;
    private DataSourceProvider dataSourceProvider;
    private MondrianConnectionProvider mondrianConnectionProvider = (MondrianConnectionProvider)ClassicEngineBoot.getInstance().getObjectFactory().get(MondrianConnectionProvider.class);
    private String designTimeName;
    private transient Connection connection;
    private static final String[] EMPTY_QUERYNAMES = new String[0];
    private static final Log logger = LogFactory.getLog(AbstractMDXDataFactory.class);
    private boolean membersOnAxisSorted;

    public AbstractMDXDataFactory() {
        this.baseConnectionProperties = new Properties();
    }

    public MondrianConnectionProvider getMondrianConnectionProvider() {
        return this.mondrianConnectionProvider;
    }

    public void setMondrianConnectionProvider(MondrianConnectionProvider mondrianConnectionProvider) {
        if (mondrianConnectionProvider == null) {
            throw new NullPointerException();
        }
        this.mondrianConnectionProvider = mondrianConnectionProvider;
    }

    public String getDynamicSchemaProcessor() {
        return this.dynamicSchemaProcessor;
    }

    public void setDynamicSchemaProcessor(String dynamicSchemaProcessor) {
        this.dynamicSchemaProcessor = dynamicSchemaProcessor;
    }

    public boolean isMembersOnAxisSorted() {
        return this.membersOnAxisSorted;
    }

    public void setMembersOnAxisSorted(boolean membersOnAxisSorted) {
        this.membersOnAxisSorted = membersOnAxisSorted;
    }

    public Boolean isUseSchemaPool() {
        return this.useSchemaPool;
    }

    public void setUseSchemaPool(Boolean useSchemaPool) {
        this.useSchemaPool = useSchemaPool;
    }

    public Boolean isUseContentChecksum() {
        return this.useContentChecksum;
    }

    public void setUseContentChecksum(Boolean useContentChecksum) {
        this.useContentChecksum = useContentChecksum;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRoleField() {
        return this.roleField;
    }

    public void setRoleField(String roleField) {
        this.roleField = roleField;
    }

    public CubeFileProvider getCubeFileProvider() {
        return this.cubeFileProvider;
    }

    public void setCubeFileProvider(CubeFileProvider cubeFileProvider) {
        this.cubeFileProvider = cubeFileProvider;
    }

    public DataSourceProvider getDataSourceProvider() {
        return this.dataSourceProvider;
    }

    public void setDataSourceProvider(DataSourceProvider dataSourceProvider) {
        this.dataSourceProvider = dataSourceProvider;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcUserField() {
        return this.jdbcUserField;
    }

    public void setJdbcUserField(String jdbcUserField) {
        this.jdbcUserField = jdbcUserField;
    }

    public String getJdbcPasswordField() {
        return this.jdbcPasswordField;
    }

    public void setJdbcPasswordField(String jdbcPasswordField) {
        this.jdbcPasswordField = jdbcPasswordField;
    }

    public Properties getBaseConnectionProperties() {
        return (Properties)this.baseConnectionProperties.clone();
    }

    public void setBaseConnectionProperties(Properties connectionProperties) {
        if (connectionProperties != null) {
            this.baseConnectionProperties.clear();
            this.baseConnectionProperties.putAll((Map<?, ?>)connectionProperties);
        }
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return true;
    }

    public void close() {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache(DataRow parameters, boolean onlyCurrentSchema) throws ReportDataFactoryException {
        try {
            Connection connection = this.mondrianConnectionProvider.createConnection(this.computeProperties(parameters), this.dataSourceProvider.getDataSource());
            try {
                CacheControl cacheControl = connection.getCacheControl(null);
                if (onlyCurrentSchema) {
                    cacheControl.flushSchema(connection.getSchema());
                } else {
                    cacheControl.flushSchemaCache();
                }
            }
            finally {
                connection.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ReportDataFactoryException("Failed to create DataSource (SQL Exception - error code: " + e.getErrorCode() + "):" + e.toString(), (Throwable)e);
        }
        catch (MondrianException e) {
            logger.error((Object)e);
            throw new ReportDataFactoryException("Failed to create DataSource (Mondrian Exception):" + e.toString(), (Throwable)e);
        }
    }

    public Result performQuery(String rawMdxQuery, DataRow parameters) throws ReportDataFactoryException {
        try {
            if (this.connection == null) {
                this.connection = this.mondrianConnectionProvider.createConnection(this.computeProperties(parameters), this.dataSourceProvider.getDataSource());
            }
        }
        catch (SQLException e) {
            throw new ReportDataFactoryException("Failed to create datasource:" + e.getLocalizedMessage(), (Throwable)e);
        }
        catch (MondrianException e) {
            throw new ReportDataFactoryException("Failed to create datasource:" + e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            if (this.connection == null) {
                throw new ReportDataFactoryException("Factory is closed.");
            }
            MDXCompiler compiler = new MDXCompiler(parameters, this.getLocale());
            String mdxQuery = compiler.translateAndLookup(rawMdxQuery, parameters);
            Query query = this.connection.parseQuery(mdxQuery);
            Statement statement = query.getStatement();
            int queryTimeoutValue = this.calculateQueryTimeOut(parameters);
            if (queryTimeoutValue > 0) {
                statement.setQueryTimeoutMillis((long)(queryTimeoutValue * 1000));
            }
            this.parametrizeQuery(parameters, query);
            Result resultSet = this.connection.execute(query);
            if (resultSet == null) {
                throw new ReportDataFactoryException("query returned no resultset");
            }
            return resultSet;
        }
        catch (MondrianException e) {
            throw new ReportDataFactoryException("Failed to create datasource:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void parametrizeQuery(DataRow parameters, Query query) throws ReportDataFactoryException {
        Parameter[] parameterDefs = query.getParameters();
        for (int i = 0; i < parameterDefs.length; ++i) {
            Parameter def = parameterDefs[i];
            Type parameterType = def.getType();
            Object parameterValue = this.preprocessMemberParameter(def, parameters, parameterType);
            Object processedParamValue = this.computeParameterValue(query, parameterValue, parameterType);
            Exp exp = def.getDefaultExp();
            if (processedParamValue == null && exp != null && exp instanceof Literal) {
                Literal exp1 = (Literal)exp;
                def.setValue(exp1.getValue());
                continue;
            }
            def.setValue(processedParamValue);
        }
    }

    private Object preprocessMemberParameter(Parameter def, DataRow parameters, Type parameterType) {
        Object parameterValue = parameters.get(def.getName());
        if (parameterValue != null) {
            return parameterValue;
        }
        try {
            if (parameterType instanceof MemberType || parameterType instanceof SetType) {
                return def.getDefaultExp().toString();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private Object computeParameterValue(Query query, Object parameterValue, Type parameterType) throws ReportDataFactoryException {
        ArrayList<Object> processedParamValue;
        if (parameterValue != null) {
            if (parameterType instanceof StringType) {
                if (!(parameterValue instanceof String)) {
                    throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
                }
                processedParamValue = parameterValue;
            } else if (parameterType instanceof NumericType) {
                if (!(parameterValue instanceof Number)) {
                    throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
                }
                processedParamValue = parameterValue;
            } else if (parameterType instanceof MemberType) {
                MemberType memberType = (MemberType)parameterType;
                Hierarchy hierarchy = memberType.getHierarchy();
                if (parameterValue instanceof String) {
                    Member member = this.findMember(query, hierarchy, query.getCube(), String.valueOf(parameterValue));
                    processedParamValue = member != null ? new MemberExpr(member) : null;
                } else {
                    if (!(parameterValue instanceof OlapElement)) {
                        throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
                    }
                    processedParamValue = parameterValue;
                }
            } else if (parameterType instanceof SetType) {
                SetType setType = (SetType)parameterType;
                Hierarchy hierarchy = setType.getHierarchy();
                if (parameterValue instanceof String) {
                    String rawString = (String)((Object)parameterValue);
                    String[] memberStr = rawString.replaceFirst("^ *\\{", "").replaceFirst("} *$", "").split(",");
                    ArrayList<Member> list = new ArrayList<Member>(memberStr.length);
                    for (int j = 0; j < memberStr.length; ++j) {
                        String str = memberStr[j];
                        Member member = this.findMember(query, hierarchy, query.getCube(), String.valueOf(str));
                        if (member == null) continue;
                        list.add(member);
                    }
                    processedParamValue = list;
                } else {
                    if (!(parameterValue instanceof OlapElement)) {
                        throw new ReportDataFactoryException(parameterValue + " is incorrect for type " + parameterType);
                    }
                    processedParamValue = parameterValue;
                }
            } else {
                processedParamValue = parameterValue;
            }
        } else {
            processedParamValue = null;
        }
        return processedParamValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Member findMember(Query query, Hierarchy hierarchy, Cube cube, String parameter) throws ReportDataFactoryException {
        try {
            Member directValue = this.yuckyInternalMondrianLookup(query, hierarchy, parameter);
            if (directValue != null) {
                return directValue;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Member memberById = null;
        Member memberByUniqueId = null;
        boolean searchForNames = !MondrianProperties.instance().NeedDimensionPrefix.get();
        boolean missingMembersIsFatal = MondrianProperties.instance().IgnoreInvalidMembersDuringQuery.get();
        try {
            Member directValue = this.lookupDirectly(hierarchy, cube, parameter, searchForNames);
            if (directValue != null) {
                return directValue;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Query memberQuery = this.connection.parseQuery("SELECT " + hierarchy.getQualifiedName() + ".AllMembers ON 0, {} ON 1 FROM " + cube.getQualifiedName());
        Result result = this.connection.execute(memberQuery);
        try {
            List positionList = result.getAxes()[0].getPositions();
            for (int i = 0; i < positionList.size(); ++i) {
                Position position = (Position)positionList.get(i);
                for (int j = 0; j < position.size(); ++j) {
                    Member member = (Member)position.get(j);
                    if (parameter.equals(MondrianUtil.getUniqueMemberName(member))) {
                        if (memberByUniqueId == null) {
                            memberByUniqueId = member;
                        } else {
                            logger.warn((Object)("Encountered a member with a duplicate unique key: " + member.getQualifiedName()));
                        }
                    }
                    if (!searchForNames || !parameter.equals(member.getName())) continue;
                    if (memberById == null) {
                        memberById = member;
                        continue;
                    }
                    logger.warn((Object)("Encountered a member with a duplicate name: " + member.getQualifiedName()));
                }
            }
        }
        finally {
            result.close();
        }
        if (memberByUniqueId != null) {
            return memberByUniqueId;
        }
        if (memberById != null) {
            return memberById;
        }
        if (missingMembersIsFatal) {
            throw new ReportDataFactoryException("No member matches parameter value '" + parameter + "'.");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Member lookupDirectly(Hierarchy hierarchy, Cube cube, String parameter, boolean searchForNames) {
        Hierarchy memberHierarchy;
        Member memberById = null;
        Member memberByUniqueId = null;
        Query queryDirect = this.connection.parseQuery("SELECT STRTOMEMBER(" + AbstractMDXDataFactory.quote(parameter) + ") ON 0, {} ON 1 FROM " + cube.getQualifiedName());
        Result resultDirect = this.connection.execute(queryDirect);
        try {
            List positionList = resultDirect.getAxes()[0].getPositions();
            for (int i = 0; i < positionList.size(); ++i) {
                Position position = (Position)positionList.get(i);
                for (int j = 0; j < position.size(); ++j) {
                    Member member = (Member)position.get(j);
                    if (parameter.startsWith("[")) {
                        if (memberByUniqueId == null) {
                            memberByUniqueId = member;
                        } else {
                            logger.warn((Object)("Encountered a member with a duplicate key: " + member.getQualifiedName()));
                        }
                    }
                    if (!searchForNames || !parameter.equals(member.getName())) continue;
                    if (memberById == null) {
                        memberById = member;
                        continue;
                    }
                    logger.warn((Object)("Encountered a member with a duplicate name: " + member.getQualifiedName()));
                }
            }
        }
        finally {
            resultDirect.close();
        }
        if (memberByUniqueId != null) {
            memberHierarchy = memberByUniqueId.getHierarchy();
            if (hierarchy != memberHierarchy && !ObjectUtilities.equal((Object)hierarchy, (Object)memberHierarchy)) {
                logger.warn((Object)"Cannot match hierarchy of member found with the hierarchy specfied in the parameter: Unabe to guarantee that the correct member has been queried, returning null.");
                return null;
            }
            return memberByUniqueId;
        }
        if (memberById != null) {
            memberHierarchy = memberById.getHierarchy();
            if (hierarchy != memberHierarchy && !ObjectUtilities.equal((Object)hierarchy, (Object)memberHierarchy)) {
                logger.warn((Object)"Cannot match hierarchy of member found with the hierarchy specfied in the parameter: Unabe to guarantee that the correct member has been queried, returning null");
                return null;
            }
            return memberById;
        }
        return null;
    }

    protected Member yuckyInternalMondrianLookup(Query query, Hierarchy hierarchy, String parameter) {
        Member memberById = (Member)Util.lookup((Query)query, (List)Util.parseIdentifier((String)parameter));
        if (memberById != null) {
            Hierarchy memberHierarchy = memberById.getHierarchy();
            if (hierarchy != memberHierarchy && !ObjectUtilities.equal((Object)hierarchy, (Object)memberHierarchy)) {
                logger.warn((Object)"Cannot match hierarchy of member found with the hierarchy specfied in the parameter: Unabe to guarantee that the correct member has been queried, returning null");
                return null;
            }
            return memberById;
        }
        return null;
    }

    protected int extractQueryLimit(DataRow parameters) {
        int queryLimitValue;
        Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
        if (queryLimit instanceof Number) {
            Number i = (Number)queryLimit;
            queryLimitValue = Math.max(0, i.intValue());
        } else {
            queryLimitValue = 0;
        }
        return queryLimitValue;
    }

    private String computeRole(DataRow parameters) throws ReportDataFactoryException {
        Object field;
        if (this.roleField != null && (field = parameters.get(this.roleField)) != null) {
            if (field instanceof Object[]) {
                Object[] roleArray = (Object[])field;
                StringBuffer buffer = new StringBuffer();
                for (Object o : roleArray) {
                    String role;
                    if (o == null || (role = this.filter(String.valueOf(o))) == null) continue;
                    buffer.append(this.quoteRole(role));
                }
                return buffer.toString();
            }
            if (field.getClass().isArray()) {
                StringBuffer buffer = new StringBuffer();
                int length = Array.getLength(field);
                for (int i = 0; i < length; ++i) {
                    String role;
                    Object o = Array.get(field, i);
                    if (o == null || (role = this.filter(String.valueOf(o))) == null) continue;
                    buffer.append(this.quoteRole(role));
                }
                return buffer.toString();
            }
            String role = this.filter(String.valueOf(field));
            if (role != null) {
                return role;
            }
        }
        return this.filter(this.role);
    }

    private String quoteRole(String role) {
        if (role.indexOf(44) == -1) {
            return role;
        }
        StringBuffer b = new StringBuffer(role.length() + 5);
        char[] chars = role.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == ',') {
                b.append(c);
            }
            b.append(c);
        }
        return b.toString();
    }

    private String computeJdbcUser(DataRow parameters) {
        Object field;
        if (this.jdbcUserField != null && (field = parameters.get(this.jdbcUserField)) != null) {
            return String.valueOf(field);
        }
        return this.jdbcUser;
    }

    private String computeJdbcPassword(DataRow parameters) {
        Object field;
        if (this.jdbcPasswordField != null && (field = parameters.get(this.jdbcPasswordField)) != null) {
            return String.valueOf(field);
        }
        return this.jdbcPassword;
    }

    private Properties computeProperties(DataRow parameters) throws ReportDataFactoryException {
        Locale locale;
        String jdbcPassword;
        String jdbcUser;
        if (this.cubeFileProvider == null) {
            throw new ReportDataFactoryException("No CubeFileProvider");
        }
        Properties properties = this.getBaseConnectionProperties();
        String catalog = this.cubeFileProvider.getCubeFile(this.getResourceManager(), this.getContextKey());
        if (catalog == null) {
            throw new ReportDataFactoryException("No valid catalog given.");
        }
        properties.setProperty("Catalog", catalog);
        String role = this.computeRole(parameters);
        if (role != null) {
            properties.setProperty("Role", role);
        }
        if (!StringUtils.isEmpty((String)(jdbcUser = this.computeJdbcUser(parameters)))) {
            properties.setProperty("JdbcUser", jdbcUser);
        }
        if (!StringUtils.isEmpty((String)(jdbcPassword = this.computeJdbcPassword(parameters)))) {
            properties.setProperty("JdbcPassword", jdbcPassword);
        }
        if ((locale = this.getLocale()) != null) {
            properties.setProperty("Locale", locale.toString());
        }
        if (this.isUseContentChecksum() != null) {
            properties.setProperty("UseContentChecksum", String.valueOf(this.isUseContentChecksum()));
        }
        if (this.isUseSchemaPool() != null) {
            properties.setProperty("UseSchemaPool", String.valueOf(this.isUseSchemaPool()));
        }
        if (this.getDynamicSchemaProcessor() != null) {
            properties.setProperty("DynamicSchemaProcessor", this.getDynamicSchemaProcessor());
        }
        return properties;
    }

    public AbstractMDXDataFactory clone() {
        AbstractMDXDataFactory dataFactory = (AbstractMDXDataFactory)super.clone();
        dataFactory.connection = null;
        if (this.baseConnectionProperties != null) {
            dataFactory.baseConnectionProperties = (Properties)this.baseConnectionProperties.clone();
        }
        return dataFactory;
    }

    public String getDesignTimeName() {
        return this.designTimeName;
    }

    public void setDesignTimeName(String designTimeName) {
        this.designTimeName = designTimeName;
    }

    public String[] getQueryNames() {
        return EMPTY_QUERYNAMES;
    }

    public void cancelRunningQuery() {
    }

    protected static String quote(String original) {
        int length = original.length();
        StringBuffer b = new StringBuffer(length * 12 / 10);
        b.append('\"');
        for (int i = 0; i < length; ++i) {
            char c = original.charAt(i);
            if (c == '\"') {
                b.append('\"');
                b.append('\"');
                continue;
            }
            b.append(c);
        }
        b.append('\"');
        return b.toString();
    }

    private String filter(String role) throws ReportDataFactoryException {
        Configuration configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        if (!"true".equals(configuration.getConfigProperty(ROLE_FILTER_ENABLE_CONFIG_KEY))) {
            return role;
        }
        Iterator staticDenyKeys = configuration.findPropertyKeys(DENY_ROLE_CONFIG_KEY);
        while (staticDenyKeys.hasNext()) {
            String key = (String)staticDenyKeys.next();
            String value = configuration.getConfigProperty(key);
            if (!ObjectUtilities.equal((Object)value, (Object)role)) continue;
            return null;
        }
        Iterator regExpDenyKeys = configuration.findPropertyKeys(DENY_REGEXP_CONFIG_KEY);
        while (regExpDenyKeys.hasNext()) {
            String key = (String)regExpDenyKeys.next();
            String value = configuration.getConfigProperty(key);
            try {
                if (!role.matches(value)) continue;
                return null;
            }
            catch (PatternSyntaxException pe) {
                throw new ReportDataFactoryException("Unable to match reg-exp role filter:", (Throwable)pe);
            }
        }
        boolean hasAccept = false;
        Iterator staticAcceptKeys = configuration.findPropertyKeys(ACCEPT_ROLES_CONFIG_KEY);
        while (staticAcceptKeys.hasNext()) {
            hasAccept = true;
            String key = (String)staticAcceptKeys.next();
            String value = configuration.getConfigProperty(key);
            if (!ObjectUtilities.equal((Object)value, (Object)role)) continue;
            return role;
        }
        Iterator regExpAcceptKeys = configuration.findPropertyKeys(ACCEPT_REGEXP_CONFIG_KEY);
        while (regExpAcceptKeys.hasNext()) {
            hasAccept = true;
            String key = (String)regExpAcceptKeys.next();
            String value = configuration.getConfigProperty(key);
            try {
                if (!role.matches(value)) continue;
                return role;
            }
            catch (PatternSyntaxException pe) {
                throw new ReportDataFactoryException("Unable to match reg-exp role filter:", (Throwable)pe);
            }
        }
        if (!hasAccept) {
            return role;
        }
        return null;
    }

    protected String translateQuery(String query) {
        return query;
    }

    protected String computedQuery(String queryName, DataRow parameters) throws ReportDataFactoryException {
        return queryName;
    }

    public ArrayList<Object> getQueryHash(String queryRaw, DataRow parameter) throws ReportDataFactoryException {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(((Object)((Object)this)).getClass().getName());
        list.add(this.translateQuery(queryRaw));
        if (this.getCubeFileProvider() != null) {
            list.add(this.getCubeFileProvider().getConnectionHash());
        }
        if (this.getDataSourceProvider() != null) {
            list.add(this.getDataSourceProvider().getConnectionHash());
        }
        list.add(this.getMondrianConnectionProvider().getConnectionHash(this.computeProperties(parameter)));
        list.add(this.computeProperties(parameter));
        return list;
    }

    public String[] getReferencedFields(String queryName, DataRow parameters) throws ReportDataFactoryException {
        try {
            if (this.connection == null) {
                this.connection = this.mondrianConnectionProvider.createConnection(this.computeProperties(parameters), this.dataSourceProvider.getDataSource());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new ReportDataFactoryException("Failed to create DataSource (SQL Exception - error code: " + e.getErrorCode() + "):" + e.toString(), (Throwable)e);
        }
        catch (MondrianException e) {
            logger.error((Object)e);
            throw new ReportDataFactoryException("Failed to create DataSource (Mondrian Exception):" + e.toString(), (Throwable)e);
        }
        try {
            if (this.connection == null) {
                throw new ReportDataFactoryException("Factory is closed.");
            }
            LinkedHashSet<String> parameter = new LinkedHashSet<String>();
            MDXCompiler compiler = new MDXCompiler(parameters, this.getLocale());
            String computedQuery = this.computedQuery(queryName, parameters);
            String mdxQuery = compiler.translateAndLookup(computedQuery, parameters);
            parameter.addAll(compiler.getCollectedParameter());
            Query query = this.connection.parseQuery(mdxQuery);
            Parameter[] queryParameters = query.getParameters();
            for (int i = 0; i < queryParameters.length; ++i) {
                Parameter queryParameter = queryParameters[i];
                parameter.add(queryParameter.getName());
            }
            if (this.jdbcUserField != null) {
                parameter.add(this.jdbcUserField);
            }
            if (this.roleField != null) {
                parameter.add(this.roleField);
            }
            parameter.add("::org.pentaho.reporting::query-limit");
            return parameter.toArray(new String[parameter.size()]);
        }
        catch (MondrianException e) {
            throw new ReportDataFactoryException("Failed to create datasource:" + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void initialize(DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        super.initialize(dataFactoryContext);
        this.membersOnAxisSorted = "true".equals(dataFactoryContext.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MembersOnAxisSorted"));
    }

    protected static class MDXCompiler
    extends PropertyLookupParser {
        private HashSet<String> collectedParameter;
        private DataRow parameters;
        private Locale locale;

        protected MDXCompiler(DataRow parameters, Locale locale) {
            if (locale == null) {
                throw new NullPointerException("Locale must not be null");
            }
            if (parameters == null) {
                throw new NullPointerException("Parameter datarow must not be null");
            }
            this.collectedParameter = new HashSet();
            this.parameters = parameters;
            this.locale = locale;
            this.setMarkerChar('$');
            this.setOpeningBraceChar('{');
            this.setClosingBraceChar('}');
        }

        protected String lookupVariable(String name) {
            CSVTokenizer tokenizer = new CSVTokenizer(name, false);
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            String parameterName = tokenizer.nextToken();
            this.collectedParameter.add(parameterName);
            Object o = this.parameters.get(parameterName);
            String subType = null;
            StringBuilder b = new StringBuilder(name.length() + 4);
            b.append('{');
            b.append("0");
            while (tokenizer.hasMoreTokens()) {
                b.append(',');
                String token = tokenizer.nextToken();
                b.append(token);
                if (subType != null) continue;
                subType = token;
            }
            b.append('}');
            String formatString = b.toString();
            if ("string".equals(subType)) {
                if (o == null) {
                    return "null";
                }
                return AbstractMDXDataFactory.quote(String.valueOf(o));
            }
            FastMessageFormat messageFormat = new FastMessageFormat(formatString, this.locale);
            return messageFormat.format((Object)new Object[]{o});
        }

        public Set<String> getCollectedParameter() {
            return Collections.unmodifiableSet((Set)this.collectedParameter.clone());
        }
    }
}

