/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.teradatabulkloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoader;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoaderMeta;
import org.pentaho.di.trans.steps.teradatabulkloader.TeraDataBulkLoaderRoutines;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.CompositeMenuItem;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.DialogPopulator;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.DirectoryTextVarMenuItem;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.FileTextVarMenuItem;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.GeneralTabWidgets;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.InputFields;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.NoButtonTextVarMenuItem;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.RadioComposite;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.RequiredFieldsError;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TableSelectionButtonListener;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TableTextVarMenuItem;
import org.pentaho.di.ui.trans.steps.teradatabulkloader.TextVarMenuItem;

public class TeraDataBulkLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    static Class<?> PKG = TeraDataBulkLoaderMeta.class;
    static final int NO_BUTTON = 0;
    static final int FILE_BUTTON = 1;
    static final int DIR_BUTTON = 2;
    static final int TABLE_BUTTON = 4;
    static final int LABEL_ONLY = 8;
    static final int NO_VAR = 16;
    private Integer lastTypeSelection = -1;
    private final List<DialogPopulator> dialogPopulators = new ArrayList<DialogPopulator>();
    CCombo wConnection;
    CTabFolder fItemSet = null;
    private RadioComposite cScriptOption;
    private Button wPreviewScript;
    CompositeMenuItem wbControlFile;
    TeraDataBulkLoaderMeta input;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private CompositeMenuItem wScriptOption;
    int margin = 4;
    ModifyListener lsMod = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            TeraDataBulkLoaderDialog.this.input.setChanged();
        }
    };
    Listener lsModSelect = new Listener(){

        public void handleEvent(Event e) {
            TeraDataBulkLoaderDialog.this.input.setChanged();
        }
    };

    public TeraDataBulkLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (TeraDataBulkLoaderMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label wlConnection = new Label((Composite)this.shell, 131072);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin, wlConnection, new Button((Composite)this.shell, 8), new Button((Composite)this.shell, 8), new Button((Composite)this.shell, 8), null);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(this.lsMod);
        wlConnection.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Connection.Label", (String[])new String[0]));
        this.wScriptOption = new CompositeMenuItem(this.props, this.lsMod, this.lsModSelect, (BaseStepMeta)this.input, (Composite)this.shell, (Control)this.wConnection, "TeraDataBulkLoaderDialog.ScriptOption.Label", 0);
        this.cScriptOption = this.wScriptOption.addRadioComposite(TeraDataBulkLoader.ScriptTypes, 0x400000, (Object)this, new Runnable(){

            @Override
            public void run() {
                TeraDataBulkLoaderDialog.this.createDynamicTabs();
            }
        });
        this.fItemSet = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.fItemSet, 5);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wPreviewScript = new Button((Composite)this.shell, 8);
        this.wPreviewScript.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Preview.Button", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreviewScript, this.wCancel}, margin, null);
        FormData fdItemSet = new FormData();
        fdItemSet.left = new FormAttachment(0, 0);
        fdItemSet.top = new FormAttachment((Control)this.wScriptOption.getComposite(), margin);
        fdItemSet.right = new FormAttachment(100, 0);
        fdItemSet.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.fItemSet.setLayoutData((Object)fdItemSet);
        this.props.setLook((Control)this.fItemSet);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                TeraDataBulkLoaderDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                TeraDataBulkLoaderDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                TeraDataBulkLoaderDialog.this.previewScript();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreviewScript.addListener(13, this.lsPreview);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TeraDataBulkLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TeraDataBulkLoaderDialog.this.cancel();
            }
        });
        this.getData();
        this.fItemSet.pack();
        this.setSize();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private InputFields getInputFields() {
        HashMap<String, Integer> inputFieldLength = new HashMap<String, Integer>();
        HashMap<String, Integer> inputFields = new HashMap<String, Integer>();
        HashMap<String, Integer> inputFieldType = new HashMap<String, Integer>();
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        if (stepMeta != null) {
            try {
                RowMetaInterface row = this.transMeta.getPrevStepFields(stepMeta);
                for (int i = 0; i < row.size(); ++i) {
                    ValueMetaInterface valueMetaInterface = row.getValueMeta(i);
                    inputFields.put(valueMetaInterface.getName(), i);
                    inputFieldType.put(valueMetaInterface.getName(), valueMetaInterface.getType());
                    inputFieldLength.put(valueMetaInterface.getName(), valueMetaInterface.getLength());
                }
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
            }
        }
        return new InputFields(inputFields, inputFieldType, inputFieldLength);
    }

    private GeneralTabWidgets createExecutionTab() {
        CTabItem tiExecutionItems = new CTabItem(this.fItemSet, 0);
        Composite cExecutionItems = new Composite((Composite)this.fItemSet, 2048);
        this.props.setLook((Control)cExecutionItems);
        tiExecutionItems.setControl((Control)cExecutionItems);
        tiExecutionItems.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ExecutionTab.Label", (String[])new String[0]));
        Group locationsGroup = new Group(cExecutionItems, 32);
        this.props.setLook((Control)locationsGroup);
        locationsGroup.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.LocationGroup.Label", (String[])new String[0]));
        FormLayout locationsGroupLayout = new FormLayout();
        locationsGroupLayout.marginWidth = 10;
        locationsGroupLayout.marginHeight = 10;
        locationsGroup.setLayout((Layout)locationsGroupLayout);
        FormData locationsData = new FormData();
        locationsData.left = new FormAttachment(0, this.margin);
        locationsData.top = new FormAttachment(0, 2 * this.margin);
        locationsData.right = new FormAttachment(100, -this.margin);
        locationsGroup.setLayoutData((Object)locationsData);
        final DirectoryTextVarMenuItem wTdInstall = new DirectoryTextVarMenuItem(this.shell, (Composite)locationsGroup, this.props, this.transMeta, this.lsMod, (Control)null, "TeraDataBulkLoaderDialog.TdInstall.Label");
        final DirectoryTextVarMenuItem wTwbRoot = new DirectoryTextVarMenuItem(this.shell, (Composite)locationsGroup, this.props, this.transMeta, this.lsMod, wTdInstall, "TeraDataBulkLoaderDialog.TwbRoot.Label");
        final DirectoryTextVarMenuItem wLibPath = new DirectoryTextVarMenuItem(this.shell, (Composite)locationsGroup, this.props, this.transMeta, this.lsMod, wTwbRoot, "TeraDataBulkLoaderDialog.TDLibPath.Label");
        final DirectoryTextVarMenuItem wTbuildLibPath = new DirectoryTextVarMenuItem(this.shell, (Composite)locationsGroup, this.props, this.transMeta, this.lsMod, wLibPath, "TeraDataBulkLoaderDialog.TbuildLibPath.Label");
        final DirectoryTextVarMenuItem wTdicuLibPath = new DirectoryTextVarMenuItem(this.shell, (Composite)locationsGroup, this.props, this.transMeta, this.lsMod, wTbuildLibPath, "TeraDataBulkLoaderDialog.TdicuLibPath.Label");
        final DirectoryTextVarMenuItem wCopLibPath = new DirectoryTextVarMenuItem(this.shell, (Composite)locationsGroup, this.props, this.transMeta, this.lsMod, wTdicuLibPath, "TeraDataBulkLoaderDialog.CopLibPath.Label");
        final FileTextVarMenuItem wTbuildPath = new FileTextVarMenuItem(this.shell, (Composite)locationsGroup, this.props, this.transMeta, this.lsMod, wCopLibPath, "TeraDataBulkLoaderDialog.TbuildPath.Label");
        Group otherGroup = new Group(cExecutionItems, 32);
        this.props.setLook((Control)otherGroup);
        otherGroup.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.OtherGroup.Label", (String[])new String[0]));
        FormLayout otherGroupLayout = new FormLayout();
        otherGroupLayout.marginWidth = 10;
        otherGroupLayout.marginHeight = 10;
        otherGroup.setLayout((Layout)otherGroupLayout);
        FormData otherData = new FormData();
        otherData.top = new FormAttachment((Control)locationsGroup, this.margin);
        otherData.left = new FormAttachment(0, this.margin);
        otherData.right = new FormAttachment(100, -this.margin);
        otherData.bottom = new FormAttachment(100, -this.margin);
        otherGroup.setLayoutData((Object)otherData);
        final NoButtonTextVarMenuItem wDataFile = new NoButtonTextVarMenuItem((Composite)otherGroup, this.props, this.transMeta, this.lsMod, wTbuildPath, "TeraDataBulkLoaderDialog.DataFile.Label");
        CompositeMenuItem wRandomizeFifoName = new CompositeMenuItem(this.props, this.lsMod, this.lsModSelect, (BaseStepMeta)this.input, (Composite)otherGroup, (Control)wDataFile.getTextVar(), "TeraDataBulkLoaderDialog.DataFileRandomize.Label", 0);
        final Button randomizeFifoName = wRandomizeFifoName.addButton("", 32);
        final NoButtonTextVarMenuItem wJobName = new NoButtonTextVarMenuItem((Composite)otherGroup, this.props, this.transMeta, this.lsMod, wRandomizeFifoName, "TeraDataBulkLoaderDialog.JobName.Label");
        cExecutionItems.setLayout((Layout)new FormLayout());
        FormData fdExecutionItems = new FormData();
        fdExecutionItems.left = new FormAttachment(0, this.margin);
        fdExecutionItems.top = new FormAttachment((Control)this.wScriptOption.getComposite(), this.margin);
        fdExecutionItems.right = new FormAttachment(100, -this.margin);
        cExecutionItems.setLayoutData((Object)fdExecutionItems);
        this.dialogPopulators.add(new DialogPopulator(){

            @Override
            public void validate(List<String> errors) {
                TeraDataBulkLoaderDialog.this.addIfTrue(errors, Const.isEmpty((String)wTdInstall.getText()), "TeraDataBulkLoaderDialog.MissingInstallPath.DialogMessage");
            }

            @Override
            public void populateMeta(TeraDataBulkLoaderMeta inf) {
                inf.setTdInstallPath(wTdInstall.getText());
                inf.setTwbRoot(wTwbRoot.getText());
                inf.setLibPath(wLibPath.getText());
                inf.setTbuildLibPath(wTbuildLibPath.getText());
                inf.setTdicuLibPath(wTdicuLibPath.getText());
                inf.setCopLibPath(wCopLibPath.getText());
                inf.setTbuildPath(wTbuildPath.getText());
                inf.setFifoFileName(wDataFile.getText());
                inf.setJobName(wJobName.getText());
                inf.setRandomizeFifoFilename(randomizeFifoName.getSelection());
            }

            @Override
            public void populateDialog(TeraDataBulkLoaderMeta input) {
                String val = input.getTdInstallPath();
                if (val != null) {
                    wTdInstall.setText(val);
                }
                if ((val = input.getTwbRoot()) != null) {
                    wTwbRoot.setText(val);
                }
                if ((val = input.getLibPath()) != null) {
                    wLibPath.setText(val);
                }
                if ((val = input.getTbuildLibPath()) != null) {
                    wTbuildLibPath.setText(val);
                }
                if ((val = input.getTdicuLibPath()) != null) {
                    wTdicuLibPath.setText(val);
                }
                if ((val = input.getCopLibPath()) != null) {
                    wCopLibPath.setText(val);
                }
                if ((val = input.getTbuildPath()) != null) {
                    wTbuildPath.setText(val);
                }
                if ((val = input.getFifoFileName()) != null) {
                    wDataFile.setText(val);
                }
                if ((val = input.getJobName()) != null) {
                    wJobName.setText(val);
                }
                randomizeFifoName.setSelection(input.isRandomizeFifoFilename());
            }
        });
        return new GeneralTabWidgets(tiExecutionItems, randomizeFifoName);
    }

    private Button createCheckbox(Composite parent, int style, String label, Listener listener) {
        Button button = new Button(parent, style | 0x20);
        if (!Const.isEmpty((String)label)) {
            button.setText(BaseMessages.getString(PKG, (String)label, (String[])new String[0]));
        }
        button.addListener(32, listener);
        this.props.setLook((Control)button);
        return button;
    }

    private void createGenScriptTabs() {
        CTabItem tiGenScriptControlItems = new CTabItem(this.fItemSet, 0);
        tiGenScriptControlItems.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.GenerateScriptControlTab.Label", (String[])new String[0]));
        Composite cGenScriptControlItems = new Composite((Composite)this.fItemSet, 2048);
        this.props.setLook((Control)cGenScriptControlItems);
        final NoButtonTextVarMenuItem wSchema = new NoButtonTextVarMenuItem(cGenScriptControlItems, this.props, this.transMeta, this.lsMod, (Control)null, "TeraDataBulkLoaderDialog.TargetSchema.Label");
        final TableTextVarMenuItem wTable = new TableTextVarMenuItem(this.shell, cGenScriptControlItems, this.props, this.transMeta, this.lsMod, wSchema, "TeraDataBulkLoaderDialog.TargetTable.Label");
        final Runnable setTableFieldCombo = new Runnable(){

            @Override
            public void run() {
                TeraDataBulkLoaderDialog.this.setTableFieldCombo(wSchema, wTable);
            }
        };
        ModifyListener lsTableMod = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                TeraDataBulkLoaderDialog.this.input.setChanged();
                setTableFieldCombo.run();
            }
        };
        wSchema.getTextVar().addModifyListener(lsTableMod);
        ((Button)wTable.getButton()).addSelectionListener((SelectionListener)new TableSelectionButtonListener(this.transMeta, wTable.getTextVar(), this.wConnection, this.shell, wSchema, wTable, setTableFieldCombo, (LogChannelInterface)this.log));
        wTable.getTextVar().addModifyListener(lsTableMod);
        final NoButtonTextVarMenuItem wLogTable = new NoButtonTextVarMenuItem(cGenScriptControlItems, this.props, this.transMeta, this.lsMod, wTable, "TeraDataBulkLoaderDialog.LogTablePrompt.Label");
        final NoButtonTextVarMenuItem wWorkTable = new NoButtonTextVarMenuItem(cGenScriptControlItems, this.props, this.transMeta, this.lsMod, wLogTable, "TeraDataBulkLoaderDialog.WorkTablePrompt.Label");
        final NoButtonTextVarMenuItem wErrorTable = new NoButtonTextVarMenuItem(cGenScriptControlItems, this.props, this.transMeta, this.lsMod, wWorkTable, "TeraDataBulkLoaderDialog.ErrorTablePrompt.Label");
        final NoButtonTextVarMenuItem wErrorTable2 = new NoButtonTextVarMenuItem(cGenScriptControlItems, this.props, this.transMeta, this.lsMod, wErrorTable, "TeraDataBulkLoaderDialog.ErrorTable2Prompt.Label");
        final NoButtonTextVarMenuItem wScriptFile = new NoButtonTextVarMenuItem(cGenScriptControlItems, this.props, this.transMeta, this.lsMod, wErrorTable2, "TeraDataBulkLoaderDialog.ScriptFile.Label");
        Group dropTablesBeforeLoadGroup = new Group(cGenScriptControlItems, 32);
        this.props.setLook((Control)dropTablesBeforeLoadGroup);
        dropTablesBeforeLoadGroup.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DropTables.Label", (String[])new String[0]));
        dropTablesBeforeLoadGroup.setLayout((Layout)new FormLayout());
        FormData dropTablesBeforeLoadGroupData = new FormData();
        dropTablesBeforeLoadGroupData.left = new FormAttachment(0, this.margin);
        dropTablesBeforeLoadGroupData.top = new FormAttachment((Control)wScriptFile.getTextVar(), 2 * this.margin);
        dropTablesBeforeLoadGroupData.right = new FormAttachment(100, -this.margin);
        dropTablesBeforeLoadGroup.setLayoutData((Object)dropTablesBeforeLoadGroupData);
        Composite dropTablesBeforeLoadComposite = new Composite((Composite)dropTablesBeforeLoadGroup, 0);
        this.props.setLook((Control)dropTablesBeforeLoadComposite);
        RowLayout dropTablesBeforeLoadLayout = new RowLayout();
        dropTablesBeforeLoadLayout.spacing = 10;
        dropTablesBeforeLoadComposite.setLayout((Layout)dropTablesBeforeLoadLayout);
        FormData dropTablesBeforeLoadData = new FormData();
        dropTablesBeforeLoadData.left = new FormAttachment(this.props.getMiddlePct(), 0);
        dropTablesBeforeLoadData.top = new FormAttachment(0, 0);
        dropTablesBeforeLoadData.right = new FormAttachment(100, 0);
        dropTablesBeforeLoadComposite.setLayoutData((Object)dropTablesBeforeLoadData);
        final Button wbDropLog = this.createCheckbox(dropTablesBeforeLoadComposite, 131072, "TeraDataBulkLoaderDialog.LogTable.Label", this.lsModSelect);
        final Button wbDropWork = this.createCheckbox(dropTablesBeforeLoadComposite, 131072, "TeraDataBulkLoaderDialog.WorkTable.Label", this.lsModSelect);
        final Button wbDropError = this.createCheckbox(dropTablesBeforeLoadComposite, 131072, "TeraDataBulkLoaderDialog.ErrorTable.Label", this.lsModSelect);
        final Button wbDropError2 = this.createCheckbox(dropTablesBeforeLoadComposite, 131072, "TeraDataBulkLoaderDialog.ErrorTable2.Label", this.lsModSelect);
        Group rowHandlingGroupWrapper = new Group(cGenScriptControlItems, 32);
        rowHandlingGroupWrapper.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.RowHandling.Label", (String[])new String[0]));
        this.props.setLook((Control)rowHandlingGroupWrapper);
        rowHandlingGroupWrapper.setLayout((Layout)new FormLayout());
        FormData rowHandlingGroupWrapperData = new FormData();
        rowHandlingGroupWrapperData.left = new FormAttachment(0, this.margin);
        rowHandlingGroupWrapperData.top = new FormAttachment((Control)dropTablesBeforeLoadGroup, this.margin);
        rowHandlingGroupWrapperData.right = new FormAttachment(100, -this.margin);
        rowHandlingGroupWrapper.setLayoutData((Object)rowHandlingGroupWrapperData);
        Composite rowHandlingComposite = new Composite((Composite)rowHandlingGroupWrapper, 0);
        this.props.setLook((Control)rowHandlingComposite);
        RowLayout rowHandlingCompositeLayout = new RowLayout();
        rowHandlingCompositeLayout.spacing = 10;
        rowHandlingComposite.setLayout((Layout)rowHandlingCompositeLayout);
        FormData rowHandlingCompositeLayoutData = new FormData();
        rowHandlingCompositeLayoutData.left = new FormAttachment(this.props.getMiddlePct(), 0);
        rowHandlingCompositeLayoutData.top = new FormAttachment(0, 0);
        rowHandlingCompositeLayoutData.right = new FormAttachment(100, 0);
        rowHandlingComposite.setLayoutData((Object)rowHandlingCompositeLayoutData);
        final Button wbIgnoreDupUpdate = this.createCheckbox(rowHandlingComposite, 131072, "TeraDataBulkLoaderDialog.IgnoreDupUpdate.Label", this.lsModSelect);
        final Button wbInsertMissingUpdate = this.createCheckbox(rowHandlingComposite, 131072, "TeraDataBulkLoaderDialog.InsertMissingUpdate.Label", this.lsModSelect);
        final Button wbIgnoreMissingUpdate = this.createCheckbox(rowHandlingComposite, 131072, "TeraDataBulkLoaderDialog.IgnoreMissing.Label", this.lsModSelect);
        Group logFilesGroup = new Group(cGenScriptControlItems, 32);
        this.props.setLook((Control)logFilesGroup);
        logFilesGroup.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.LogFiles.Label", (String[])new String[0]));
        FormLayout logFilesGroupLayout = new FormLayout();
        logFilesGroupLayout.marginWidth = 10;
        logFilesGroupLayout.marginHeight = 10;
        logFilesGroup.setLayout((Layout)logFilesGroupLayout);
        FormData logFilesGroupData = new FormData();
        logFilesGroupData.left = new FormAttachment(0, this.margin);
        logFilesGroupData.top = new FormAttachment((Control)rowHandlingGroupWrapper, 2 * this.margin);
        logFilesGroupData.right = new FormAttachment(100, -this.margin);
        logFilesGroup.setLayoutData((Object)logFilesGroupData);
        final FileTextVarMenuItem wAccessLogFile = new FileTextVarMenuItem(this.shell, (Composite)logFilesGroup, this.props, this.transMeta, this.lsMod, (Control)rowHandlingComposite, "TeraDataBulkLoaderDialog.AccessLogFile.Label");
        final FileTextVarMenuItem wUpdateLogFile = new FileTextVarMenuItem(this.shell, (Composite)logFilesGroup, this.props, this.transMeta, this.lsMod, wAccessLogFile, "TeraDataBulkLoaderDialog.UpdateLogFile.Label");
        tiGenScriptControlItems.setControl((Control)cGenScriptControlItems);
        cGenScriptControlItems.setLayout((Layout)new FormLayout());
        this.dialogPopulators.add(new DialogPopulator(){

            @Override
            public void validate(List<String> errors) {
                TeraDataBulkLoaderDialog.this.addIfTrue(errors, Const.isEmpty((String)wSchema.getText()), "TeraDataBulkLoaderDialog.MissingSchema.DialogMessage");
                TeraDataBulkLoaderDialog.this.addIfTrue(errors, Const.isEmpty((String)wTable.getText()), "TeraDataBulkLoaderDialog.MissingTargetTable.DialogMessage");
                TeraDataBulkLoaderDialog.this.addIfTrue(errors, Const.isEmpty((String)wLogTable.getText()), "TeraDataBulkLoaderDialog.MissingLogTable.DialogMessage");
            }

            @Override
            public void populateMeta(TeraDataBulkLoaderMeta inf) {
                inf.setSchemaName(wSchema.getText());
                inf.setTableName(wTable.getText());
                inf.setLogTable(wLogTable.getText());
                inf.setWorkTable(wWorkTable.getText());
                inf.setErrorTable(wErrorTable.getText());
                inf.setErrorTable2(wErrorTable2.getText());
                inf.setDropLogTable(wbDropLog.getSelection());
                inf.setDropWorkTable(wbDropWork.getSelection());
                inf.setDropErrorTable(wbDropError.getSelection());
                inf.setDropErrorTable2(wbDropError2.getSelection());
                inf.setIgnoreDupUpdate(wbIgnoreDupUpdate.getSelection());
                inf.setInsertMissingUpdate(wbInsertMissingUpdate.getSelection());
                inf.setIgnoreMissingUpdate(wbIgnoreMissingUpdate.getSelection());
                inf.setAccessLogFile(wAccessLogFile.getText());
                inf.setUpdateLogFile(wUpdateLogFile.getText());
                inf.setScriptFileName(wScriptFile.getText());
            }

            @Override
            public void populateDialog(TeraDataBulkLoaderMeta input) {
                String val = input.getSchemaName();
                if (val != null) {
                    wSchema.setText(val);
                }
                if ((val = input.getTableName()) != null) {
                    wTable.setText(val);
                }
                if ((val = input.getLogTable()) != null) {
                    wLogTable.setText(val);
                }
                if ((val = input.getWorkTable()) != null) {
                    wWorkTable.setText(val);
                }
                if ((val = input.getErrorTable()) != null) {
                    wErrorTable.setText(val);
                }
                if ((val = input.getErrorTable2()) != null) {
                    wErrorTable2.setText(val);
                }
                if ((val = input.getAccessLogFile()) != null) {
                    wAccessLogFile.setText(val);
                }
                if ((val = input.getUpdateLogFile()) != null) {
                    wUpdateLogFile.setText(val);
                }
                if ((val = input.getScriptFileName()) != null) {
                    wScriptFile.setText(val);
                }
                wbDropLog.setSelection(input.getDropLogTable());
                wbDropWork.setSelection(input.getDropWorkTable());
                wbDropError.setSelection(input.getDropErrorTable());
                wbDropError2.setSelection(input.getDropErrorTable2());
                wbIgnoreDupUpdate.setSelection(input.getIgnoreDupUpdate());
                wbInsertMissingUpdate.setSelection(input.getInsertMissingUpdate());
                wbIgnoreMissingUpdate.setSelection(input.getIgnoreMissingUpdate());
            }
        });
        this.tableFieldColumns.clear();
        CTabItem tiGenScriptFields = new CTabItem(this.fItemSet, 0);
        tiGenScriptFields.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.GenerateScriptFieldsTab.Label", (String[])new String[0]));
        Composite cGenScriptFields = new Composite((Composite)this.fItemSet, 2048);
        this.props.setLook((Control)cGenScriptFields);
        CompositeMenuItem wActionType = new CompositeMenuItem(this.props, this.lsMod, this.lsModSelect, (BaseStepMeta)this.input, cGenScriptFields, (Control)null, "TeraDataBulkLoaderDialog.ActionType.Label", 0);
        final RadioComposite cActionType = wActionType.addRadioComposite(TeraDataBulkLoader.ActionTypes, 0x400000, (Object)this, null);
        int nrKeyCols = 3;
        int nrKeyRows = this.input.getKeyStream() != null && this.input.getKeyStream().length > 3 ? this.input.getKeyStream().length : 3;
        final Label wlKey = new Label(cGenScriptFields, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Keys.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)wActionType.getComposite(), this.margin);
        wlKey.setLayoutData((Object)fdlKey);
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, new String[]{"=", "= ~NULL", "<>", "<", "<=", ">", ">=", "LIKE", "IS NULL", "IS NOT NULL"});
        ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(ciKey[0]);
        final TableView wKey = new TableView((VariableSpace)this.transMeta, cGenScriptFields, 68354, ciKey, nrKeyRows, this.lsMod, this.props);
        final Button wGet = new Button(cGenScriptFields, 8);
        wGet.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.GetFields.Button", (String[])new String[0]));
        wGet.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                setTableFieldCombo.run();
                try {
                    RowMetaInterface r = TeraDataBulkLoaderDialog.this.transMeta.getPrevStepFields(TeraDataBulkLoaderDialog.this.stepname);
                    if (r != null) {
                        TableItemInsertListener listener = new TableItemInsertListener(){

                            public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                                tableItem.setText(2, "=");
                                return true;
                            }
                        };
                        BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)wKey, (int)1, (int[])new int[]{1, 3}, (int[])new int[0], (int)-1, (int)-1, (TableItemInsertListener)listener);
                    }
                }
                catch (KettleException ke) {
                    new ErrorDialog(TeraDataBulkLoaderDialog.this.shell, BaseMessages.getString(PKG, (String)"InsertUpdateDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"InsertUpdateDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
                }
            }
        });
        FormData fdGet = new FormData();
        fdGet.right = new FormAttachment(100, 0);
        fdGet.top = new FormAttachment((Control)wlKey, this.margin);
        wGet.setLayoutData((Object)fdGet);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, this.margin);
        fdKey.right = new FormAttachment((Control)wGet, -this.margin);
        wKey.setLayoutData((Object)fdKey);
        Label wlReturn = new Label(cGenScriptFields, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)wKey, this.margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int UpInsCols = 3;
        int UpInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        ColumnInfo[] ciReturn = new ColumnInfo[UpInsCols];
        ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ColumnInfo.UpdateField", (String[])new String[0]), 2, new String[]{"Y", "N"});
        this.tableFieldColumns.add(ciReturn[0]);
        final TableView wReturn = new TableView((VariableSpace)this.transMeta, cGenScriptFields, 68354, ciReturn, UpInsRows, this.lsMod, this.props);
        Button wGetMapping = new Button(cGenScriptFields, 8);
        wGetMapping.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        wGetMapping.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                try {
                    setTableFieldCombo.run();
                    RowMetaInterface r = TeraDataBulkLoaderDialog.this.transMeta.getPrevStepFields(TeraDataBulkLoaderDialog.this.stepname);
                    if (r != null) {
                        TableItemInsertListener listener = new TableItemInsertListener(){

                            public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                                if (v.getType() == 3) {
                                    tableItem.setText(3, "Y");
                                } else {
                                    tableItem.setText(3, "Y");
                                }
                                return true;
                            }
                        };
                        BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, (TableView)wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (TableItemInsertListener)listener);
                    }
                }
                catch (KettleException ke) {
                    new ErrorDialog(TeraDataBulkLoaderDialog.this.shell, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
                }
            }
        });
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wlReturn, this.margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetMapping.setLayoutData((Object)fdGetLU);
        Button wDoMapping = new Button(cGenScriptFields, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wGetMapping, this.margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                TeraDataBulkLoaderDialog.this.generateMappings(wReturn, wSchema, wTable);
            }
        });
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, this.margin);
        fdReturn.right = new FormAttachment((Control)wGetMapping, -this.margin);
        fdReturn.bottom = new FormAttachment(100, 0);
        wReturn.setLayoutData((Object)fdReturn);
        Runnable disableKeytable = new Runnable(){

            @Override
            public void run() {
                int choice = cActionType.getSelection();
                if (choice == 0) {
                    wKey.setEnabled(false);
                    wKey.setVisible(false);
                    wGet.setEnabled(false);
                    wGet.setVisible(false);
                    wlKey.setVisible(false);
                } else {
                    wKey.setEnabled(true);
                    wKey.setVisible(true);
                    wGet.setEnabled(true);
                    wGet.setVisible(true);
                    wlKey.setVisible(true);
                }
            }
        };
        cActionType.setCallback(disableKeytable);
        this.dialogPopulators.add(new DialogPopulator(){

            @Override
            public void validate(List<String> errors) {
            }

            @Override
            public void populateMeta(TeraDataBulkLoaderMeta inf) {
                TableItem item;
                int i;
                int nrkeys = wKey.nrNonEmpty();
                int nrfields = wReturn.nrNonEmpty();
                inf.allocate(nrkeys, nrfields);
                if (TeraDataBulkLoaderDialog.this.log.isDebug()) {
                    TeraDataBulkLoaderDialog.this.logDebug(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
                }
                for (i = 0; i < nrkeys; ++i) {
                    item = wKey.getNonEmpty(i);
                    inf.getKeyLookup()[i] = item.getText(1);
                    inf.getKeyCondition()[i] = item.getText(2);
                    inf.getKeyStream()[i] = item.getText(3);
                }
                for (i = 0; i < nrfields; ++i) {
                    item = wReturn.getNonEmpty(i);
                    inf.getFieldTable()[i] = item.getText(1);
                    inf.getFieldStream()[i] = item.getText(2);
                    inf.getFieldUpdate()[i] = "Y".equals(item.getText(3));
                }
                inf.setActionType(cActionType.getSelection());
            }

            @Override
            public void populateDialog(TeraDataBulkLoaderMeta input) {
                TableItem item;
                int i;
                int ival = input.getActionType();
                if (ival >= 0) {
                    cActionType.setSelection(ival);
                }
                if (TeraDataBulkLoaderDialog.this.log.isDebug()) {
                    TeraDataBulkLoaderDialog.this.logDebug(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
                }
                if (input.getKeyStream() != null) {
                    for (i = 0; i < input.getKeyStream().length; ++i) {
                        item = wKey.table.getItem(i);
                        if (input.getKeyLookup()[i] != null) {
                            item.setText(1, input.getKeyLookup()[i]);
                        }
                        if (input.getKeyCondition()[i] != null) {
                            item.setText(2, input.getKeyCondition()[i]);
                        }
                        if (input.getKeyStream()[i] == null) continue;
                        item.setText(3, input.getKeyStream()[i]);
                    }
                }
                if (input.getFieldTable() != null) {
                    TeraDataBulkLoaderDialog.this.logDebug(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.FieldTableLength", (Object[])new Object[]{input.getFieldTable().length}));
                    for (i = 0; i < input.getFieldTable().length; ++i) {
                        item = wReturn.table.getItem(i);
                        if (input.getFieldTable()[i] != null) {
                            item.setText(1, input.getFieldTable()[i]);
                        }
                        if (input.getFieldStream()[i] != null) {
                            item.setText(2, input.getFieldStream()[i]);
                        }
                        if (input.getFieldUpdate()[i] == null || input.getFieldUpdate()[i].booleanValue()) {
                            item.setText(3, "Y");
                        } else {
                            item.setText(3, "N");
                        }
                        TeraDataBulkLoaderDialog.this.logDebug(item.toString());
                    }
                }
                wReturn.setRowNums();
                wReturn.optWidth(true);
            }
        });
        cGenScriptFields.setLayout((Layout)new FormLayout());
        tiGenScriptFields.setControl((Control)cGenScriptFields);
        ArrayList<String> fields = new ArrayList<String>(this.getInputFields().getInputFields().keySet());
        Collections.sort(fields);
        ciKey[2].setComboValues(fields.toArray(new String[fields.size()]));
        ciReturn[1].setComboValues(fields.toArray(new String[fields.size()]));
        disableKeytable.run();
        setTableFieldCombo.run();
    }

    private void createUseScriptItemsTab(final GeneralTabWidgets generalTabWidgets) {
        final CTabItem tiUseScriptItems = new CTabItem(this.fItemSet, 0);
        tiUseScriptItems.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.ScriptTab.Label", (String[])new String[0]));
        Composite cUseScriptItems = new Composite((Composite)this.fItemSet, 2048);
        final FileTextVarMenuItem wControlFile = new FileTextVarMenuItem(this.shell, cUseScriptItems, this.props, this.transMeta, this.lsMod, (Control)null, "TeraDataBulkLoaderDialog.ControlFile.Label");
        CompositeMenuItem wSubstituteControlFile = new CompositeMenuItem(this.props, this.lsMod, this.lsModSelect, (BaseStepMeta)this.input, cUseScriptItems, wControlFile, "TeraDataBulkLoaderDialog.SubstituteControlFile.Label", 0);
        final Button wbSubstituteControlFile = wSubstituteControlFile.addButton("", 32);
        wSubstituteControlFile.addLabel("TeraDataBulkLoaderDialog.DataFileRandomizeVariable.Label").setForeground(GUIResource.getInstance().getColorOrange());
        final FileTextVarMenuItem wVariableFile = new FileTextVarMenuItem(this.shell, cUseScriptItems, this.props, this.transMeta, this.lsMod, wSubstituteControlFile, "TeraDataBulkLoaderDialog.VariableFile.Label");
        tiUseScriptItems.setControl((Control)cUseScriptItems);
        cUseScriptItems.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)cUseScriptItems);
        FormData fdScript = new FormData();
        fdScript.left = new FormAttachment(0, this.margin);
        fdScript.top = new FormAttachment(0, this.margin);
        fdScript.right = new FormAttachment(100, -this.margin);
        fdScript.bottom = new FormAttachment(100, -this.margin);
        cUseScriptItems.setLayoutData((Object)fdScript);
        this.dialogPopulators.add(new DialogPopulator(){

            @Override
            public void validate(List<String> errors) {
                TeraDataBulkLoaderDialog.this.addIfTrue(errors, Const.isEmpty((String)wControlFile.getText()), "TeraDataBulkLoaderDialog.MissingControlFile.DialogMessage");
                boolean fifoBadState = generalTabWidgets.getRandomizeFifoButton().getSelection() && !wbSubstituteControlFile.getSelection();
                TeraDataBulkLoaderDialog.this.addIfTrue(errors, fifoBadState, "TeraDataBulkLoaderDialog.FIFOState.DialogMessage");
                if (fifoBadState) {
                    TeraDataBulkLoaderDialog.this.fItemSet.setSelection(tiUseScriptItems);
                }
            }

            @Override
            public void populateMeta(TeraDataBulkLoaderMeta inf) {
                inf.setExistingScriptFile(wControlFile.getText());
                inf.setSubstituteControlFile(wbSubstituteControlFile.getSelection());
                inf.setVariableFile(wVariableFile.getText());
            }

            @Override
            public void populateDialog(TeraDataBulkLoaderMeta input) {
                String val = input.getExistingScriptFile();
                if (val != null) {
                    wControlFile.setText(val);
                }
                wbSubstituteControlFile.setSelection(input.getSubstituteControlFile());
                val = input.getVariableFile();
                if (val != null) {
                    wVariableFile.setText(val);
                }
            }
        });
    }

    public void createDynamicTabs() {
        int thisSelection = this.cScriptOption.getSelection();
        if (this.lastTypeSelection != thisSelection) {
            if (thisSelection == 0) {
                this.wPreviewScript.setEnabled(true);
                this.createDynamicTabs(true);
            } else {
                this.wPreviewScript.setEnabled(false);
                this.createDynamicTabs(false);
            }
            this.getDynamicData();
        }
        this.lastTypeSelection = thisSelection;
    }

    public void createDynamicTabs(boolean generated) {
        this.dialogPopulators.clear();
        int i = 0;
        while ((i = this.fItemSet.getItemCount() - 1) >= 0) {
            CTabItem tab = this.fItemSet.getItem(i);
            tab.getControl().dispose();
            tab.dispose();
        }
        GeneralTabWidgets tiExecutionItems = this.createExecutionTab();
        if (generated) {
            this.createGenScriptTabs();
        } else {
            this.createUseScriptItemsTab(tiExecutionItems);
        }
        this.fItemSet.setSelection(tiExecutionItems.getTab());
    }

    private void generateMappings(TableView wReturn, TextVarMenuItem wSchema, TextVarMenuItem wTable) {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(wTable.getText()));
        this.input.setSchemaName(this.transMeta.environmentSubstitute(wSchema.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            wReturn.table.removeAll();
            wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            wReturn.setRowNums();
            wReturn.optWidth(true);
        }
    }

    public String[] getStreamAndTableFields() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.input.getFieldTable() != null) {
            for (int i = 0; i < this.input.getFieldTable().length; ++i) {
                if (this.input.getFieldTable()[i] == null || this.input.getFieldStream()[i] == null) continue;
                list.add(this.input.getFieldTable()[i] + " = :" + this.input.getFieldStream()[i]);
            }
        }
        String[] simpleArray = new String[list.size()];
        return list.toArray(simpleArray);
    }

    private void setTableFieldCombo(TextVarMenuItem wSchema, TextVarMenuItem wTable) {
        block7: {
            if (!wTable.getTextVar().isDisposed() && !this.wConnection.isDisposed()) {
                DatabaseMeta ci;
                for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                    ColumnInfo colInfo = this.tableFieldColumns.get(i);
                    colInfo.setComboValues(new String[0]);
                }
                if (!Const.isEmpty((String)wTable.getText()) && (ci = this.transMeta.findDatabase(this.wConnection.getText())) != null) {
                    Database db = new Database(loggingObject, ci);
                    try {
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = ci.getQuotedSchemaTableCombination(this.transMeta.environmentSubstitute(wSchema.getText()), this.transMeta.environmentSubstitute(wTable.getText()));
                        RowMetaInterface r = db.getTableFields(schemaTable);
                        if (null == r || null == (fieldNames = r.getFieldNames())) break block7;
                        for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                            ColumnInfo colInfo = this.tableFieldColumns.get(i);
                            colInfo.setComboValues(fieldNames);
                        }
                    }
                    catch (Exception e) {
                        for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                            ColumnInfo colInfo = this.tableFieldColumns.get(i);
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                }
            }
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(TeraDataBulkLoaderMeta inf) {
        for (DialogPopulator dialogPopulator : this.dialogPopulators) {
            dialogPopulator.populateMeta(inf);
        }
        inf.setGenerateScript(this.cScriptOption.getSelection() == 0);
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.stepname = this.wStepname.getText();
    }

    private <T> void addIfTrue(List<String> list, boolean condition, String message) {
        if (condition) {
            list.add(BaseMessages.getString(PKG, (String)message, (String[])new String[0]));
        }
    }

    private void ok() {
        RequiredFieldsError errorPopup = new RequiredFieldsError(this.shell, BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.MissingRequiredTitle.DialogMessage", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.MissingRequiredMsg.DialogMessage", (String[])new String[0]));
        errorPopup.addIfUndef(this.wStepname, "TeraDataBulkLoaderDialog.MissingStepname.DialogMessage");
        errorPopup.addIfUndef(this.wConnection, "TeraDataBulkLoaderDialog.InvalidConnection.DialogMessage");
        ArrayList<String> errors = new ArrayList<String>();
        for (DialogPopulator dialogPopulator : this.dialogPopulators) {
            dialogPopulator.validate(errors);
        }
        for (String error : errors) {
            errorPopup.addMessage(error);
        }
        if (errorPopup.hasErrors()) {
            errorPopup.display();
        } else {
            this.getInfo(this.input);
            this.dispose();
        }
    }

    public void getData() {
        this.cScriptOption.setSelection(this.input.getGenerateScript() ? 0 : 1);
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        this.createDynamicTabs();
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    public void getDynamicData() {
        for (DialogPopulator dialogPopulator : this.dialogPopulators) {
            dialogPopulator.populateDialog(this.input);
        }
    }

    public void previewScript() {
        InputFields inputFields = this.getInputFields();
        TeraDataBulkLoaderMeta metacopy = new TeraDataBulkLoaderMeta();
        this.getInfo(metacopy);
        TeraDataBulkLoaderRoutines routines = new TeraDataBulkLoaderRoutines(null, metacopy);
        try {
            String script = routines.createGeneratedScriptFile(inputFields.getInputFieldType(), inputFields.getInputFieldLength());
            Shell mb = new Shell();
            mb.setLayout((Layout)new FillLayout());
            Text msg = new Text((Composite)mb, 515);
            mb.setText(BaseMessages.getString(PKG, (String)"TeraDataBulkLoaderDialog.Preview.MessageBoxTitle", (String[])new String[0]));
            msg.setText(script);
            msg.setEditable(false);
            mb.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

