/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;

public class HttpUtil {
    public static final int ZIP_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execService(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts) throws Exception {
        HttpClient client = SlaveConnectionManager.getInstance().createHttpClient();
        HttpUtil.addCredentials(client, space, hostname, port, webAppName, username, password);
        HttpUtil.addProxy(client, space, hostname, proxyHostname, proxyPort, nonProxyHosts);
        String urlString = HttpUtil.constructUrl(space, hostname, port, webAppName, serviceAndArguments);
        GetMethod method = new GetMethod(urlString);
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            String body;
            int result = client.executeMethod((HttpMethod)method);
            if (result != 200) {
                throw new KettleException("Response code " + result + " received while querying " + urlString);
            }
            String string = body = method.getResponseBodyAsString();
            return string;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            method.releaseConnection();
        }
    }

    public static String constructUrl(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments) throws UnsupportedEncodingException {
        String realHostname = space.environmentSubstitute(hostname);
        if (!StringUtils.isEmpty((String)webAppName)) {
            serviceAndArguments = "/" + space.environmentSubstitute(webAppName) + serviceAndArguments;
        }
        String retval = "http://" + realHostname + HttpUtil.getPortSpecification(space, port) + serviceAndArguments;
        retval = Const.replace(retval, " ", "%20");
        return retval;
    }

    public static String getPortSpecification(VariableSpace space, String port) {
        String realPort = space.environmentSubstitute(port);
        String portSpec = ":" + realPort;
        if (Const.isEmpty(realPort) || port.equals("80")) {
            portSpec = "";
        }
        return portSpec;
    }

    public static void addProxy(HttpClient client, VariableSpace space, String hostname, String proxyHostname, String proxyPort, String nonProxyHosts) {
        String host = space.environmentSubstitute(hostname);
        String phost = space.environmentSubstitute(proxyHostname);
        String pport = space.environmentSubstitute(proxyPort);
        String nonprox = space.environmentSubstitute(nonProxyHosts);
        if (!Const.isEmpty(phost) && !Const.isEmpty(pport)) {
            if (!Const.isEmpty(nonprox) && !Const.isEmpty(host) && host.matches(nonprox)) {
                return;
            }
            client.getHostConfiguration().setProxy(phost, Integer.parseInt(pport));
        }
    }

    public static void addCredentials(HttpClient client, VariableSpace space, String hostname, String port, String webAppName, String username, String password) {
        if (StringUtils.isEmpty((String)webAppName)) {
            client.getState().setCredentials(new AuthScope(space.environmentSubstitute(hostname), Const.toInt(space.environmentSubstitute(port), 80), "Kettle"), (Credentials)new UsernamePasswordCredentials(space.environmentSubstitute(username), Encr.decryptPasswordOptionallyEncrypted(space.environmentSubstitute(password))));
        } else {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(space.environmentSubstitute(username), Encr.decryptPasswordOptionallyEncrypted(space.environmentSubstitute(password)));
            client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
            client.getParams().setAuthenticationPreemptive(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeBase64ZippedString(String loggingString64) throws IOException {
        if (loggingString64 == null || loggingString64.isEmpty()) {
            return "";
        }
        StringWriter writer = new StringWriter();
        byte[] bytes64 = Base64.decodeBase64((byte[])loggingString64.getBytes());
        ByteArrayInputStream zip = new ByteArrayInputStream(bytes64);
        GZIPInputStream unzip = null;
        InputStreamReader reader = null;
        BufferedInputStream in = null;
        try {
            unzip = new GZIPInputStream((InputStream)zip, 8192);
            in = new BufferedInputStream(unzip, 8192);
            reader = new InputStreamReader((InputStream)in, "UTF-8");
            writer = new StringWriter();
            char[] buff = new char[8192];
            int length = 0;
            while ((length = reader.read(buff)) > 0) {
                writer.write(buff, 0, length);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (unzip != null) {
                try {
                    unzip.close();
                }
                catch (IOException e) {}
            }
        }
        return writer.toString();
    }

    public static String encodeBase64ZippedString(String in) throws IOException {
        Charset charset = Charset.forName("UTF-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        gzos.write(in.getBytes(charset));
        gzos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }
}

