/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseTransactionListener;

public class DatabaseConnectionMap {
    private Map<String, Database> map = new Hashtable<String, Database>();
    private AtomicInteger transactionId = new AtomicInteger(0);
    private Map<String, List<DatabaseTransactionListener>> transactionListenersMap = new HashMap<String, List<DatabaseTransactionListener>>();
    private static DatabaseConnectionMap connectionMap;

    public static final synchronized DatabaseConnectionMap getInstance() {
        if (connectionMap != null) {
            return connectionMap;
        }
        connectionMap = new DatabaseConnectionMap();
        return connectionMap;
    }

    private DatabaseConnectionMap() {
    }

    public synchronized void storeDatabase(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        this.map.put(key, database);
    }

    public synchronized void removeConnection(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        this.map.remove(key);
    }

    public synchronized Database getDatabase(String connectionGroup, String partitionID, Database database) {
        String key = DatabaseConnectionMap.createEntryKey(connectionGroup, partitionID, database);
        return this.map.get(key);
    }

    public static final String createEntryKey(String connectionGroup, String partitionID, Database database) {
        StringBuffer key = new StringBuffer(connectionGroup);
        key.append(':').append(database.getDatabaseMeta().getName());
        if (!Const.isEmpty(partitionID)) {
            key.append(':').append(partitionID);
        }
        return key.toString();
    }

    public Map<String, Database> getMap() {
        return this.map;
    }

    public String getNextTransactionId() {
        return Integer.toString(this.transactionId.incrementAndGet());
    }

    public void addTransactionListener(String transactionId, DatabaseTransactionListener listener) {
        List<DatabaseTransactionListener> transactionListeners = this.getTransactionListeners(transactionId);
        transactionListeners.add(listener);
    }

    public void removeTransactionListener(String transactionId, DatabaseTransactionListener listener) {
        List<DatabaseTransactionListener> transactionListeners = this.getTransactionListeners(transactionId);
        transactionListeners.remove(listener);
    }

    public List<DatabaseTransactionListener> getTransactionListeners(String transactionId) {
        List<DatabaseTransactionListener> transactionListeners = this.transactionListenersMap.get(transactionId);
        if (transactionListeners == null) {
            transactionListeners = new ArrayList<DatabaseTransactionListener>();
            this.transactionListenersMap.put(transactionId, transactionListeners);
        }
        return transactionListeners;
    }

    public void removeTransactionListeners(String transactionId) {
        this.transactionListenersMap.remove(transactionId);
    }
}

