/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.mapred;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class PentahoTableRecordReaderImpl {
    static final Log LOG = LogFactory.getLog(PentahoTableRecordReaderImpl.class);
    private byte[] startRow;
    private byte[] endRow;
    private byte[] lastRow;
    private Filter trrRowFilter;
    private ResultScanner scanner;
    private HTable htable;
    private byte[][] trrInputColumns;
    private int scanCacheRows = -1;
    private Long timeStamp;
    private Long timeStampStart;
    private Long timeStampEnd;

    public void restart(byte[] firstRow) throws IOException {
        Scan scan = null;
        if (this.endRow != null && this.endRow.length > 0) {
            if (this.trrRowFilter != null) {
                scan = new Scan(firstRow, this.endRow);
                PentahoTableRecordReaderImpl.configureScanWithInputColumns(scan, this.trrInputColumns);
                scan.setFilter(this.trrRowFilter);
                scan.setCacheBlocks(false);
            } else {
                LOG.debug((Object)("TIFB.restart, firstRow: " + Bytes.toStringBinary((byte[])firstRow) + ", endRow: " + Bytes.toStringBinary((byte[])this.endRow)));
                scan = new Scan(firstRow, this.endRow);
                PentahoTableRecordReaderImpl.configureScanWithInputColumns(scan, this.trrInputColumns);
            }
        } else {
            LOG.debug((Object)("TIFB.restart, firstRow: " + Bytes.toStringBinary((byte[])firstRow) + ", no endRow"));
            scan = new Scan(firstRow);
            PentahoTableRecordReaderImpl.configureScanWithInputColumns(scan, this.trrInputColumns);
        }
        if (this.scanCacheRows > 0) {
            scan.setCaching(this.scanCacheRows);
        }
        if (this.timeStamp != null) {
            scan.setTimeStamp(this.timeStamp.longValue());
        } else if (this.timeStampStart != null && this.timeStampEnd != null && this.timeStampEnd - this.timeStampStart > 0L) {
            scan.setTimeRange(this.timeStampStart.longValue(), this.timeStampEnd.longValue());
        }
        this.scanner = this.htable.getScanner(scan);
    }

    protected static void configureScanWithInputColumns(Scan scan, byte[][] inputColumns) {
        for (byte[] familyAndQualifier : inputColumns) {
            byte[][] fq = KeyValue.parseColumn((byte[])familyAndQualifier);
            if (fq.length > 1 && fq[1] != null && fq[1].length > 0) {
                scan.addColumn(fq[0], fq[1]);
                continue;
            }
            scan.addFamily(fq[0]);
        }
    }

    public void setScanCacheRowSize(int size) {
        this.scanCacheRows = size;
    }

    public void setTimestamp(Long ts) {
        this.timeStamp = ts;
    }

    public void setTimeStampRange(Long start, Long end) {
        this.timeStampStart = start;
        this.timeStampEnd = end;
    }

    public void init() throws IOException {
        this.restart(this.startRow);
    }

    byte[] getStartRow() {
        return this.startRow;
    }

    public void setHTable(HTable htable) {
        this.htable = htable;
    }

    public void setInputColumns(byte[][] inputColumns) {
        this.trrInputColumns = inputColumns;
    }

    public void setStartRow(byte[] startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(byte[] endRow) {
        this.endRow = endRow;
    }

    public void setRowFilter(Filter rowFilter) {
        this.trrRowFilter = rowFilter;
    }

    public void close() {
        this.scanner.close();
    }

    public ImmutableBytesWritable createKey() {
        return new ImmutableBytesWritable();
    }

    public Result createValue() {
        return new Result();
    }

    public long getPos() {
        return 0L;
    }

    public float getProgress() {
        return 0.0f;
    }

    public boolean next(ImmutableBytesWritable key, Result value) throws IOException {
        Result result;
        try {
            result = this.scanner.next();
        }
        catch (UnknownScannerException e) {
            LOG.debug((Object)("recovered from " + StringUtils.stringifyException((Throwable)e)));
            this.restart(this.lastRow);
            this.scanner.next();
            result = this.scanner.next();
        }
        if (result != null && result.size() > 0) {
            key.set(result.getRow());
            this.lastRow = key.get();
            if (result instanceof Writable && value instanceof Writable) {
                Writables.copyWritable((Writable)((Writable)result), (Writable)((Writable)value));
            } else {
                try {
                    Method m = result.getClass().getMethod("copyFrom", Result.class);
                    m.invoke((Object)value, result);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(e);
                }
                catch (SecurityException e) {
                    throw new IOException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (IllegalArgumentException e) {
                    throw new IOException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IOException(e);
                }
            }
            return true;
        }
        return false;
    }
}

