/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.openerp.objectoutput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.openerp.objectoutput.OpenERPObjectOutput;
import org.pentaho.di.trans.steps.openerp.objectoutput.OpenERPObjectOutputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="OpenERPObjectOutputImport", image="OpenERPObjectOutput.svg", i18nPackageName="org.pentaho.di.trans.steps.openerp.objectoutput", name="OpenERPObjectOutput.TransName", description="OpenERPObjectOutput.TransDescription", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.OpenERP")
public class OpenERPObjectOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta;
    private String modelName;
    private int commitBatchSize = 100;
    private String[] modelFields = new String[0];
    private String[] streamFields = new String[0];
    private boolean outputIDField = false;
    private String outputIDFieldName = "";
    private ArrayList<String[]> keyLookups = new ArrayList();

    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.outputIDField) {
            if (this.outputIDFieldName == null || this.outputIDFieldName.length() == 0) {
                throw new KettleStepException("Error while retrieving fields", (Throwable)new Exception("ID field name is null"));
            }
            ValueMeta v = new ValueMeta(this.outputIDFieldName, 5);
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new OpenERPObjectOutput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        try {
            return new OpenERPObjectOutputData(this.databaseMeta);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"modelName", (String)this.modelName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"readBatchSize", (int)this.commitBatchSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"outputIDField", (boolean)this.outputIDField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"outputIDFieldName", (String)this.outputIDFieldName));
        retval.append("    <mappings>").append(Const.CR);
        for (i = 0; i < this.modelFields.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"model_field", (String)this.modelFields[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_field", (String)this.streamFields[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        retval.append("    </mappings>").append(Const.CR);
        retval.append("    <key_mappings>").append(Const.CR);
        for (i = 0; i < this.keyLookups.size(); ++i) {
            retval.append("      <key_map>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"model_key_field", (String)this.keyLookups.get(i)[0]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"comparitor", (String)this.keyLookups.get(i)[1]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_key_field", (String)this.keyLookups.get(i)[2]));
            retval.append("      </key_map>").append(Const.CR);
        }
        retval.append("    </key_mappings>").append(Const.CR);
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    private void allocate(int size) {
        this.modelFields = new String[size];
        this.streamFields = new String[size];
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(idStep, "connection", databases);
            this.modelName = rep.getStepAttributeString(idStep, "modelName");
            this.commitBatchSize = Integer.parseInt(rep.getStepAttributeString(idStep, "readBatchSize"));
            this.outputIDField = rep.getStepAttributeBoolean(idStep, "outputIDField");
            this.outputIDFieldName = rep.getStepAttributeString(idStep, "outputIDFieldName");
            int nrMappings = rep.countNrStepAttributes(idStep, "model_field");
            this.allocate(nrMappings);
            for (i = 0; i < nrMappings; ++i) {
                this.modelFields[i] = rep.getStepAttributeString(idStep, i, "model_field");
                this.streamFields[i] = rep.getStepAttributeString(idStep, i, "stream_field");
            }
            nrMappings = rep.countNrStepAttributes(idStep, "model_key_field");
            this.allocate(nrMappings);
            this.keyLookups.clear();
            for (i = 0; i < nrMappings; ++i) {
                String[] key_maps = new String[]{rep.getStepAttributeString(idStep, i, "model_key_field"), rep.getStepAttributeString(idStep, i, "comparitor"), rep.getStepAttributeString(idStep, i, "stream_key_field")};
                this.keyLookups.add(key_maps);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            int i;
            rep.saveDatabaseMetaStepAttribute(idTransformation, idStep, "connection", this.databaseMeta);
            rep.saveStepAttribute(idTransformation, idStep, "modelName", this.modelName);
            rep.saveStepAttribute(idTransformation, idStep, "readBatchSize", (long)this.commitBatchSize);
            rep.saveStepAttribute(idTransformation, idStep, "outputIDField", this.outputIDField);
            rep.saveStepAttribute(idTransformation, idStep, "outputIDFieldName", this.outputIDFieldName);
            for (i = 0; i < this.modelFields.length; ++i) {
                rep.saveStepAttribute(idTransformation, idStep, i, "model_field", this.modelFields[i]);
                rep.saveStepAttribute(idTransformation, idStep, i, "stream_field", this.streamFields[i]);
            }
            for (i = 0; i < this.keyLookups.size(); ++i) {
                rep.saveStepAttribute(idTransformation, idStep, i, "model_key_field", this.keyLookups.get(i)[0]);
                rep.saveStepAttribute(idTransformation, idStep, i, "comparitor", this.keyLookups.get(i)[1]);
                rep.saveStepAttribute(idTransformation, idStep, i, "stream_key_field", this.keyLookups.get(i)[2]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for idStep=" + idStep, (Throwable)e);
        }
    }

    public void setDefault() {
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.modelName = XMLHandler.getTagValue((Node)stepnode, (String)"modelName");
            this.commitBatchSize = Integer.parseInt(XMLHandler.getTagValue((Node)stepnode, (String)"readBatchSize"));
            this.outputIDField = XMLHandler.getTagValue((Node)stepnode, (String)"outputIDField").equals("Y");
            this.outputIDFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"outputIDFieldName");
            Node mappings = XMLHandler.getSubNode((Node)stepnode, (String)"mappings");
            int nrLevels = XMLHandler.countNodes((Node)mappings, (String)"mapping");
            this.allocate(nrLevels);
            for (int i = 0; i < nrLevels; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)mappings, (String)"mapping", (int)i);
                this.modelFields[i] = XMLHandler.getTagValue((Node)fnode, (String)"model_field");
                this.streamFields[i] = XMLHandler.getTagValue((Node)fnode, (String)"stream_field");
            }
            Node keyMappings = XMLHandler.getSubNode((Node)stepnode, (String)"key_mappings");
            nrLevels = XMLHandler.countNodes((Node)keyMappings, (String)"key_map");
            this.keyLookups.clear();
            for (int i = 0; i < nrLevels; ++i) {
                String[] key_maps = new String[3];
                Node fnode = XMLHandler.getSubNodeByNr((Node)keyMappings, (String)"key_map", (int)i);
                key_maps[0] = XMLHandler.getTagValue((Node)fnode, (String)"model_key_field");
                key_maps[1] = XMLHandler.getTagValue((Node)fnode, (String)"comparitor");
                key_maps[2] = XMLHandler.getTagValue((Node)fnode, (String)"stream_key_field");
                this.keyLookups.add(key_maps);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public final void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public final DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setCommitBatchSize(int commitBatchSize) {
        this.commitBatchSize = commitBatchSize;
    }

    public int getCommitBatchSize() {
        return this.commitBatchSize;
    }

    public void setModelFields(String[] modelFields) {
        this.modelFields = modelFields;
    }

    public String[] getModelFields() {
        return this.modelFields;
    }

    public void setStreamFields(String[] streamFields) {
        this.streamFields = streamFields;
    }

    public String[] getStreamFields() {
        return this.streamFields;
    }

    public void setKeyLookups(ArrayList<String[]> keyLookups) {
        this.keyLookups = keyLookups;
    }

    public ArrayList<String[]> getKeyLookups() {
        return this.keyLookups;
    }

    public void setOutputIDField(boolean outputIDField) {
        this.outputIDField = outputIDField;
    }

    public boolean getOutputIDField() {
        return this.outputIDField;
    }

    public void setOutputIDFieldName(String outputIDFieldName) {
        this.outputIDFieldName = outputIDFieldName;
    }

    public String getOutputIDFieldName() {
        return this.outputIDFieldName;
    }
}

