/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.openerp.objectinput;

import com.debortoliwines.openerp.api.helpers.FilterHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.openerp.core.FieldMapping;
import org.pentaho.di.openerp.core.ReadFilter;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.openerp.objectinput.OpenERPObjectInputData;
import org.pentaho.di.trans.steps.openerp.objectinput.OpenERPObjectInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class OpenERPObjectInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = OpenERPObjectInputMeta.class;
    private static Class<?> PKGStepInterface = StepInterface.class;
    ArrayList<FieldMapping> sourceListMapping;
    private ColumnInfo[] filterViewColinf;
    private final OpenERPObjectInputMeta meta;
    private Label labelStepName;
    private Text textStepName;
    private CCombo addConnectionLine;
    private Label labelModelName;
    private CCombo comboModelName;
    private Label labelReadBatchSize;
    private Text textReadBatchSize;
    private Label labelFilter;
    private TableView tableViewFilter;
    private Button buttonHelpFilter;
    private Label labelFields;
    private TableView tableViewFields;
    private Button buttonGetFields;
    private Button buttonOk;
    private Button buttonCancel;
    private Button buttonPreview;

    public OpenERPObjectInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.meta = (OpenERPObjectInputMeta)((Object)in);
    }

    public String open() {
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenERPObjectInputDialog.this.meta.setChanged();
            }
        };
        Display display = this.getParent().getDisplay();
        this.shell = new Shell(this.getParent(), 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.labelStepName = new Label((Composite)this.shell, 131072);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.labelStepName.setLayoutData((Object)fd);
        this.textStepName = new Text((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, margin);
        this.textStepName.setLayoutData((Object)fd);
        this.addConnectionLine = this.addConnectionLine((Composite)this.shell, (Control)this.textStepName, 35, margin);
        this.labelModelName = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.labelModelName.setLayoutData((Object)fd);
        this.comboModelName = new CCombo((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.addConnectionLine, margin);
        this.comboModelName.setLayoutData((Object)fd);
        this.labelReadBatchSize = new Label((Composite)this.shell, 131072);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment((Control)this.comboModelName, margin);
        this.labelReadBatchSize.setLayoutData((Object)fd);
        this.textReadBatchSize = new Text((Composite)this.shell, 2048);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.comboModelName, margin);
        this.textReadBatchSize.setLayoutData((Object)fd);
        this.labelFilter = new Label((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.textReadBatchSize, margin);
        this.labelFilter.setLayoutData((Object)fd);
        this.filterViewColinf = new ColumnInfo[]{new ColumnInfo(this.getLocalizedFilterColumn(0), 2, new String[]{""}, false), new ColumnInfo(this.getLocalizedFilterColumn(1), 2, new String[]{""}, false), new ColumnInfo(this.getLocalizedFilterColumn(2), 2, new String[]{""}, false), new ColumnInfo(this.getLocalizedFilterColumn(3), 1, false, false)};
        this.tableViewFilter = new TableView(null, (Composite)this.shell, 2050, this.filterViewColinf, 0, true, lsMod, this.props);
        this.tableViewFilter.setReadonly(false);
        this.tableViewFilter.setSortable(false);
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment((Control)this.labelFilter, 3 * margin);
        fd.right = new FormAttachment(100, -150);
        fd.bottom = new FormAttachment((Control)this.labelFilter, 200);
        this.tableViewFilter.setLayoutData((Object)fd);
        this.buttonHelpFilter = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFilter, margin);
        fd.top = new FormAttachment((Control)this.labelFilter, 3 * margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonHelpFilter.setLayoutData((Object)fd);
        this.labelFields = new Label((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.tableViewFilter, margin);
        this.labelFields.setLayoutData((Object)fd);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(this.getLocalizedColumn(0), 1, false, true), new ColumnInfo(this.getLocalizedColumn(1), 1, false, true), new ColumnInfo(this.getLocalizedColumn(2), 1, false, true)};
        this.tableViewFields = new TableView(null, (Composite)this.shell, 2050, colinf, 0, true, lsMod, this.props);
        this.tableViewFields.setSize(477, 280);
        this.tableViewFields.setBounds(5, 125, 477, 280);
        this.tableViewFields.setReadonly(false);
        this.tableViewFields.setSortable(true);
        fd = new FormData();
        fd.left = new FormAttachment(0, margin);
        fd.top = new FormAttachment((Control)this.labelFields, 3 * margin);
        fd.right = new FormAttachment(100, -150);
        fd.bottom = new FormAttachment(100, -50);
        this.tableViewFields.setLayoutData((Object)fd);
        this.buttonGetFields = new Button((Composite)this.shell, 0);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.tableViewFields, margin);
        fd.top = new FormAttachment((Control)this.labelFields, 3 * margin);
        fd.right = new FormAttachment(100, 0);
        this.buttonGetFields.setLayoutData((Object)fd);
        this.buttonOk = new Button((Composite)this.shell, 0x1000000);
        this.buttonCancel = new Button((Composite)this.shell, 0x1000000);
        this.buttonPreview = new Button((Composite)this.shell, 0x1000000);
        this.buttonOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.buttonPreview.setText(BaseMessages.getString((String)"System.Button.Preview"));
        this.buttonCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.buttonOk, this.buttonPreview, this.buttonCancel}, margin, null);
        this.addConnectionLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.fillModelCombo();
            }
        });
        this.comboModelName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.fillFilterCombos();
            }
        });
        this.comboModelName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                OpenERPObjectInputDialog.this.fillFilterCombos();
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.comboModelName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.fillFilterCombos();
            }
        });
        this.buttonHelpFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.showHelp();
            }
        });
        this.buttonGetFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.getFields();
            }
        });
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.cancel();
            }
        });
        this.buttonPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.preview();
            }
        });
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenERPObjectInputDialog.this.ok();
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OpenERPObjectInputDialog.this.fillModelCombo();
            }
        };
        display.asyncExec(runnable);
        this.fillLocalizationData();
        this.fillStoredData();
        this.props.setLook((Control)this.labelStepName);
        this.props.setLook((Control)this.textStepName);
        this.props.setLook((Control)this.addConnectionLine);
        this.props.setLook((Control)this.labelModelName);
        this.props.setLook((Control)this.comboModelName);
        this.props.setLook((Control)this.labelReadBatchSize);
        this.props.setLook((Control)this.textReadBatchSize);
        this.props.setLook((Control)this.labelFilter);
        this.props.setLook((Control)this.tableViewFilter);
        this.props.setLook((Control)this.labelFields);
        this.props.setLook((Control)this.tableViewFields);
        this.meta.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private String getLocalizedColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.TableViewLabel", (String[])new String[0]);
            }
            case 1: {
                return BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.TableViewModelName", (String[])new String[0]);
            }
            case 2: {
                return BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.TableViewFieldName", (String[])new String[0]);
            }
        }
        return "";
    }

    private String getLocalizedFilterColumn(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.TableViewFilterOperator", (String[])new String[0]);
            }
            case 1: {
                return BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.TableViewFilterField", (String[])new String[0]);
            }
            case 2: {
                return BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.TableViewFilterComparator", (String[])new String[0]);
            }
            case 3: {
                return BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.TableViewFilterValue", (String[])new String[0]);
            }
        }
        return "";
    }

    private void showHelp() {
        EnterTextDialog text = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.FilterHelp.Title", (String[])new String[0]), "", BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.FilterHelp.Text", (String[])new String[0]));
        text.setReadOnly();
        text.open();
    }

    private void getFields() {
        ArrayList<FieldMapping> mappings = this.getFieldMappings(false);
        if (mappings != null) {
            this.populateFielsTable(mappings);
        } else {
            String[] modelList = this.getModelList();
            if (modelList == null) {
                this.getFieldMappings(true);
                return;
            }
            boolean found = false;
            for (String model : modelList) {
                if (!model.equals(this.comboModelName.getText())) continue;
                found = true;
                break;
            }
            if (!found) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ConnectionErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ConnectionErrorString", (String[])new String[0]), new Exception(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ModelNotFoundError", (String[])new String[]{this.comboModelName.getText()})));
                return;
            }
        }
    }

    private void populateFielsTable(ArrayList<FieldMapping> mappings) {
        int choice = 0;
        if (this.tableViewFields.table.getItemCount() > 0) {
            MessageDialog md = new MessageDialog(this.tableViewFields.getShell(), BaseMessages.getString(PKGStepInterface, (String)"BaseStepDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKGStepInterface, (String)"BaseStepDialog.GetFieldsChoice.Message", (String[])new String[]{"" + this.tableViewFields.table.getItemCount(), "" + mappings.size()}), 4, new String[]{BaseMessages.getString(PKGStepInterface, (String)"BaseStepDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKGStepInterface, (String)"BaseStepDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKGStepInterface, (String)"BaseStepDialog.Cancel", (String[])new String[0])}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 2 || choice == 255) {
            return;
        }
        if (choice == 1) {
            this.tableViewFields.table.removeAll();
        }
        Hashtable<String, Boolean> currentMaps = new Hashtable<String, Boolean>();
        for (int i = 0; i < this.tableViewFields.table.getItemCount(); ++i) {
            currentMaps.put(this.tableViewFields.table.getItem(i).getText(1) + this.tableViewFields.table.getItem(i).getText(2) + this.tableViewFields.table.getItem(i).getText(3), true);
        }
        this.sourceListMapping = mappings;
        for (FieldMapping map : mappings) {
            if (currentMaps.containsKey(map.target_field_label + map.target_model + map.target_field)) continue;
            this.tableViewFields.add(new String[]{map.target_field_label, map.target_model, map.target_field, map.source_model, map.source_field, String.valueOf(map.source_index), String.valueOf(map.target_field_type)});
        }
        this.tableViewFields.setRowNums();
        this.tableViewFields.optWidth(true);
    }

    private void populateFiltersTable(ArrayList<ReadFilter> filters) {
        this.tableViewFilter.table.removeAll();
        for (ReadFilter filter : filters) {
            this.tableViewFilter.add(new String[]{filter.getOperator(), filter.getFieldName(), filter.getComparator(), filter.getValue()});
        }
        this.tableViewFilter.add(new String[]{"", "", "", ""});
        this.tableViewFilter.setRowNums();
        this.tableViewFilter.optWidth(true);
    }

    private void fillModelCombo() {
        String[] modelList = this.getModelList();
        if (modelList != null) {
            for (String modelName : modelList) {
                if (this.comboModelName.indexOf(modelName) != -1) continue;
                this.comboModelName.add(modelName);
            }
        }
    }

    private String[] getModelList() {
        DatabaseMeta dbMeta;
        String[] modelList = null;
        if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
            OpenERPObjectInputData data = null;
            try {
                data = new OpenERPObjectInputData(dbMeta);
                data.helper.StartSession();
                modelList = data.helper.getModelList();
            }
            catch (Exception e) {
                return null;
            }
        }
        return modelList;
    }

    private void fillFilterCombos(ArrayList<FieldMapping> mappings) {
        ArrayList<String> fieldList = new ArrayList<String>();
        for (FieldMapping map : mappings) {
            if (fieldList.contains(map.source_field)) continue;
            fieldList.add(map.source_field);
        }
        String[] fieldStringList = new String[fieldList.size()];
        fieldStringList = fieldList.toArray(fieldStringList);
        Arrays.sort(fieldStringList, String.CASE_INSENSITIVE_ORDER);
        this.filterViewColinf[0].setComboValues(FilterHelper.getOperators());
        this.filterViewColinf[1].setComboValues(fieldStringList);
        this.filterViewColinf[2].setComboValues(FilterHelper.getComparators());
        this.tableViewFilter.optWidth(true);
    }

    private void fillFilterCombos() {
        ArrayList<FieldMapping> mappings = this.getFieldMappings(false);
        if (mappings != null) {
            this.fillFilterCombos(mappings);
        }
    }

    private ArrayList<FieldMapping> getFieldMappings(boolean showError) {
        DatabaseMeta dbMeta;
        if (this.addConnectionLine.getText() != null && (dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText())) != null) {
            try {
                OpenERPObjectInputData data = new OpenERPObjectInputData(dbMeta);
                data.helper.StartSession();
                ArrayList<FieldMapping> mappings = data.helper.getDefaultFieldMappings(this.comboModelName.getText());
                return mappings;
            }
            catch (Exception e) {
                if (showError) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ConnectionErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ConnectionErrorString", (String[])new String[0]), e);
                }
                return null;
            }
        }
        return null;
    }

    private void fillStoredData() {
        int index;
        if (this.stepname != null) {
            this.textStepName.setText(this.stepname);
        }
        if ((index = this.addConnectionLine.indexOf(this.meta.getDatabaseMeta() != null ? this.meta.getDatabaseMeta().getName() : "")) >= 0) {
            this.addConnectionLine.select(index);
        }
        if (this.meta.getModelName() != null) {
            this.comboModelName.add(this.meta.getModelName());
            this.comboModelName.select(0);
        }
        this.textReadBatchSize.setText(String.valueOf(this.meta.getReadBatchSize()));
        this.tableViewFields.table.removeAll();
        this.tableViewFilter.table.removeAll();
        this.populateFielsTable(this.meta.getMappings());
        this.populateFiltersTable(this.meta.getFilterList());
        this.fillFilterCombos();
    }

    private void fillLocalizationData() {
        this.shell.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.Title", (String[])new String[0]));
        this.labelStepName.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.StepName", (String[])new String[0]));
        this.labelModelName.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ModelName", (String[])new String[0]));
        this.labelReadBatchSize.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ReadBatchSize", (String[])new String[0]));
        this.labelFilter.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.LabelFilterSpecify", (String[])new String[0]));
        this.labelFields.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.LabelSpecifyFields", (String[])new String[0]));
        this.buttonHelpFilter.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ButtonFilterHelp", (String[])new String[0]));
        this.buttonGetFields.setText(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ButtonGetFields", (String[])new String[0]));
    }

    private void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (this.SaveToMeta(this.meta)) {
            this.dispose();
        }
    }

    private boolean SaveToMeta(OpenERPObjectInputMeta targetMeta) {
        this.stepname = this.textStepName.getText();
        DatabaseMeta dbMeta = this.transMeta.findDatabase(this.addConnectionLine.getText());
        if (dbMeta != null) {
            try {
                new OpenERPObjectInputData(dbMeta);
            }
            catch (KettleException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ConnectionTypeErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ConnectionTypeErrorString", (String[])new String[0]), (Exception)((Object)e));
                return false;
            }
        }
        int readBatchSize = 0;
        try {
            readBatchSize = Integer.parseInt(this.textReadBatchSize.getText());
        }
        catch (NumberFormatException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ParseErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.ParseErrorString", (String[])new String[]{this.textReadBatchSize.getText()}), (Exception)e);
            return false;
        }
        ArrayList<FieldMapping> mappings = new ArrayList<FieldMapping>();
        for (int i = 0; i < this.tableViewFields.table.getItemCount(); ++i) {
            FieldMapping map = null;
            for (FieldMapping sourceMap : this.sourceListMapping) {
                if (!sourceMap.target_field_label.equals(this.tableViewFields.table.getItem(i).getText(1)) || !sourceMap.target_model.equals(this.tableViewFields.table.getItem(i).getText(2)) || !sourceMap.target_field.equals(this.tableViewFields.table.getItem(i).getText(3))) continue;
                map = sourceMap.Clone();
            }
            if (map == null) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.MappingErrorTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.MappingErrorTitle", (String[])new String[0]), new Exception(BaseMessages.getString(PKG, (String)"OpenERPObjectInputDialog.MappingErrorString", (String[])new String[]{this.tableViewFields.table.getItem(i).getText(2)})));
                return false;
            }
            mappings.add(map);
        }
        ArrayList<ReadFilter> filters = new ArrayList<ReadFilter>();
        for (int i = 0; i < this.tableViewFilter.table.getItemCount(); ++i) {
            ReadFilter filter = new ReadFilter();
            filter.setOperator(this.tableViewFilter.table.getItem(i).getText(1));
            filter.setFieldName(this.tableViewFilter.table.getItem(i).getText(2));
            filter.setComparator(this.tableViewFilter.table.getItem(i).getText(3));
            filter.setValue(this.tableViewFilter.table.getItem(i).getText(4));
            if (filter.getFieldName() == "") continue;
            filters.add(filter);
        }
        targetMeta.setDatabaseMeta(this.transMeta.findDatabase(this.addConnectionLine.getText()));
        targetMeta.setModelName(this.comboModelName.getText());
        targetMeta.setReadBatchSize(readBatchSize);
        targetMeta.setMappings(mappings);
        targetMeta.setFilterList(filters);
        targetMeta.setChanged(true);
        return true;
    }

    private void preview() {
        OpenERPObjectInputMeta testMeta = new OpenERPObjectInputMeta();
        if (!this.SaveToMeta(testMeta)) {
            return;
        }
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)testMeta, (String)this.textStepName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, 500, BaseMessages.getString((String)"System.Dialog.EnterPreviewSize.Title"), BaseMessages.getString((String)"System.Dialog.EnterPreviewSize.Message"));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.textStepName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString((String)"System.Dialog.PreviewError.Title"), BaseMessages.getString((String)"System.Dialog.PreviewError.Message"), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.textStepName.getText(), progressDialog.getPreviewRowsMeta(this.textStepName.getText()), progressDialog.getPreviewRows(this.textStepName.getText()), loggingText);
            prd.open();
        }
    }
}

