/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.shapefilereader;

import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.shapefilereader.ShapeFileReaderMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ShapeFileReaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private Label wlShape;
    private Button wbShape;
    private Button wbcShape;
    private Text wShape;
    private FormData fdlShape;
    private FormData fdbShape;
    private FormData fdbcShape;
    private FormData fdShape;
    private Label wlDbf;
    private Button wbDbf;
    private Button wbcDbf;
    private Text wDbf;
    private FormData fdlDbf;
    private FormData fdbDbf;
    private FormData fdbcDbf;
    private FormData fdDbf;
    private ShapeFileReaderMeta input;
    private boolean backup_changed;

    public ShapeFileReaderDialog(Shell shell, Object object, TransMeta transMeta, String string) {
        super(shell, (BaseStepMeta)object, transMeta, string);
        this.input = (ShapeFileReaderMeta)((Object)object);
    }

    public String open() {
        Shell shell = this.getParent();
        Display display = shell.getDisplay();
        this.shell = new Shell(shell, 3312);
        this.props.setLook((Control)this.shell);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ShapeFileReaderDialog.this.input.setChanged();
            }
        };
        this.backup_changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("XBase input");
        int n = this.props.getMiddlePct();
        int n2 = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText("Step name ");
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(n, -n2);
        this.fdlStepname.top = new FormAttachment(0, n2);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(modifyListener);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(n, 0);
        this.fdStepname.top = new FormAttachment(0, n2);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlShape = new Label((Composite)this.shell, 131072);
        this.wlShape.setText("Name of the shapefile (.shp) ");
        this.props.setLook((Control)this.wlShape);
        this.fdlShape = new FormData();
        this.fdlShape.left = new FormAttachment(0, 0);
        this.fdlShape.top = new FormAttachment((Control)this.wStepname, n2);
        this.fdlShape.right = new FormAttachment(n, -n2);
        this.wlShape.setLayoutData((Object)this.fdlShape);
        this.wbShape = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbShape);
        this.wbShape.setText("&Browse...");
        this.fdbShape = new FormData();
        this.fdbShape.right = new FormAttachment(100, 0);
        this.fdbShape.top = new FormAttachment((Control)this.wStepname, n2);
        this.wbShape.setLayoutData((Object)this.fdbShape);
        this.wbcShape = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbcShape);
        this.wbcShape.setText("&Variable...");
        this.fdbcShape = new FormData();
        this.fdbcShape.right = new FormAttachment((Control)this.wbShape, -n2);
        this.fdbcShape.top = new FormAttachment((Control)this.wStepname, n2);
        this.wbcShape.setLayoutData((Object)this.fdbcShape);
        this.wShape = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wShape);
        this.wShape.addModifyListener(modifyListener);
        this.fdShape = new FormData();
        this.fdShape.left = new FormAttachment(n, 0);
        this.fdShape.right = new FormAttachment((Control)this.wbcShape, -n2);
        this.fdShape.top = new FormAttachment((Control)this.wStepname, n2);
        this.wShape.setLayoutData((Object)this.fdShape);
        this.wlDbf = new Label((Composite)this.shell, 131072);
        this.wlDbf.setText("Name of the DBF file (.dbf) ");
        this.props.setLook((Control)this.wlDbf);
        this.fdlDbf = new FormData();
        this.fdlDbf.left = new FormAttachment(0, 0);
        this.fdlDbf.top = new FormAttachment((Control)this.wShape, n2);
        this.fdlDbf.right = new FormAttachment(n, -n2);
        this.wlDbf.setLayoutData((Object)this.fdlDbf);
        this.wbDbf = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbDbf);
        this.wbDbf.setText("&Browse...");
        this.fdbDbf = new FormData();
        this.fdbDbf.right = new FormAttachment(100, 0);
        this.fdbDbf.top = new FormAttachment((Control)this.wShape, n2);
        this.wbDbf.setLayoutData((Object)this.fdbDbf);
        this.wbcDbf = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbcDbf);
        this.wbcDbf.setText("&Variable...");
        this.fdbcDbf = new FormData();
        this.fdbcDbf.right = new FormAttachment((Control)this.wbDbf, -n2);
        this.fdbcDbf.top = new FormAttachment((Control)this.wShape, n2);
        this.wbcDbf.setLayoutData((Object)this.fdbcDbf);
        this.wDbf = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDbf);
        this.wDbf.addModifyListener(modifyListener);
        this.fdDbf = new FormData();
        this.fdDbf.left = new FormAttachment(n, 0);
        this.fdDbf.right = new FormAttachment((Control)this.wbcDbf, -n2);
        this.fdDbf.top = new FormAttachment((Control)this.wShape, n2);
        this.wDbf.setLayoutData((Object)this.fdDbf);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText("  &OK  ");
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText("  &Cancel  ");
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, n2, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event event) {
                ShapeFileReaderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event event) {
                ShapeFileReaderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                ShapeFileReaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wShape.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ShapeFileReaderDialog.this.wShape.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wShape.getText()));
            }
        });
        this.wbShape.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(ShapeFileReaderDialog.this.shell, 4096);
                fileDialog.setFilterExtensions(new String[]{"*.shp;*.SHP", "*"});
                if (ShapeFileReaderDialog.this.wShape.getText() != null) {
                    fileDialog.setFileName(ShapeFileReaderDialog.this.wShape.getText());
                }
                fileDialog.setFilterNames(new String[]{"Shape files", "All files"});
                if (fileDialog.open() != null) {
                    String string = fileDialog.getFilterPath() + System.getProperty("file.separator") + fileDialog.getFileName();
                    ShapeFileReaderDialog.this.wShape.setText(string);
                    if (string.toUpperCase().endsWith(".SHP") && (ShapeFileReaderDialog.this.wDbf.getText() == null || ShapeFileReaderDialog.this.wDbf.getText().length() == 0)) {
                        String string2 = string.substring(0, string.length() - 4);
                        ShapeFileReaderDialog.this.wDbf.setText(string2 + ".dbf");
                    }
                }
            }
        });
        this.wbcShape.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Properties properties = System.getProperties();
                Enumeration<Object> enumeration = properties.keys();
                int n = properties.values().size();
                String[] stringArray = new String[n];
                String[] stringArray2 = new String[n];
                String[] stringArray3 = new String[n];
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    stringArray[n2] = (String)enumeration.nextElement();
                    stringArray2[n2] = properties.getProperty(stringArray[n2]);
                    stringArray3[n2] = stringArray[n2] + "  [" + stringArray2[n2] + "]";
                    ++n2;
                }
                EnterSelectionDialog enterSelectionDialog = new EnterSelectionDialog(ShapeFileReaderDialog.this.shell, stringArray3, "Select an Environment Variable", "Select an Environment Variable");
                if (enterSelectionDialog.open() != null) {
                    int n3 = enterSelectionDialog.getSelectionNr();
                    ShapeFileReaderDialog.this.wShape.insert("%%" + stringArray[n3] + "%%");
                    ShapeFileReaderDialog.this.wShape.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wShape.getText()));
                }
            }
        });
        this.wDbf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ShapeFileReaderDialog.this.wDbf.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wDbf.getText()));
            }
        });
        this.wbDbf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(ShapeFileReaderDialog.this.shell, 4096);
                fileDialog.setFilterExtensions(new String[]{"*.dbf;*.DBF", "*"});
                if (ShapeFileReaderDialog.this.wDbf.getText() != null) {
                    fileDialog.setFileName(ShapeFileReaderDialog.this.wDbf.getText());
                }
                fileDialog.setFilterNames(new String[]{"DBF files", "All files"});
                if (fileDialog.open() != null) {
                    String string = fileDialog.getFilterPath() + System.getProperty("file.separator") + fileDialog.getFileName();
                    ShapeFileReaderDialog.this.wDbf.setText(string);
                }
            }
        });
        this.wbcDbf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Properties properties = System.getProperties();
                Enumeration<Object> enumeration = properties.keys();
                int n = properties.values().size();
                String[] stringArray = new String[n];
                String[] stringArray2 = new String[n];
                String[] stringArray3 = new String[n];
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    stringArray[n2] = (String)enumeration.nextElement();
                    stringArray2[n2] = properties.getProperty(stringArray[n2]);
                    stringArray3[n2] = stringArray[n2] + "  [" + stringArray2[n2] + "]";
                    ++n2;
                }
                EnterSelectionDialog enterSelectionDialog = new EnterSelectionDialog(ShapeFileReaderDialog.this.shell, stringArray3, "Select an Environment Variable", "Select an Environment Variable");
                if (enterSelectionDialog.open() != null) {
                    int n3 = enterSelectionDialog.getSelectionNr();
                    ShapeFileReaderDialog.this.wDbf.insert("${" + stringArray[n3] + "}");
                    ShapeFileReaderDialog.this.wDbf.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wDbf.getText()));
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent shellEvent) {
                ShapeFileReaderDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.input.getShapeFilename() != null) {
            this.wShape.setText(this.input.getShapeFilename());
        }
        if (this.input.getDbfFilename() != null) {
            this.wDbf.setText(this.input.getDbfFilename());
        }
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backup_changed);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.input.setShapeFilename(this.wShape.getText());
        this.input.setDbfFilename(this.wDbf.getText());
        this.dispose();
    }
}

