/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

public class Converter {
    public static final int getIntegerLittle(byte[] byArray, int n) {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = byArray[n + i];
            if (nArray[i] >= 0) continue;
            int n2 = i;
            nArray[n2] = nArray[n2] + 256;
        }
        return nArray[0] + (nArray[1] << 8) + (nArray[2] << 16) + (nArray[3] << 24);
    }

    public static final int getIntegerBig(byte[] byArray, int n) {
        int[] nArray = new int[4];
        for (int i = 0; i < 4; ++i) {
            nArray[i] = byArray[n + i];
            if (nArray[i] >= 0) continue;
            int n2 = i;
            nArray[n2] = nArray[n2] + 256;
        }
        return nArray[3] + (nArray[2] << 8) + (nArray[1] << 16) + (nArray[0] << 24);
    }

    public static final long getLongLittle(byte[] byArray, int n) {
        long[] lArray = new long[8];
        for (int i = 0; i < 8; ++i) {
            lArray[i] = byArray[n + i];
            if (lArray[i] >= 0L) continue;
            int n2 = i;
            lArray[n2] = lArray[n2] + 256L;
        }
        return lArray[0] + (lArray[1] << 8) + (lArray[2] << 16) + (lArray[3] << 24) + (lArray[4] << 32) + (lArray[5] << 40) + (lArray[6] << 48) + (lArray[7] << 56);
    }

    public static final long getLongBig(byte[] byArray, int n) {
        long[] lArray = new long[8];
        for (int i = 0; i < 8; ++i) {
            lArray[i] = byArray[n + i];
            if (lArray[i] >= 0L) continue;
            int n2 = i;
            lArray[n2] = lArray[n2] + 256L;
        }
        return lArray[7] + (lArray[6] << 8) + (lArray[5] << 16) + (lArray[4] << 24) + (lArray[3] << 32) + (lArray[2] << 40) + (lArray[1] << 48) + (lArray[0] << 56);
    }

    public static final double getDoubleLittle(byte[] byArray, int n) {
        return Double.longBitsToDouble(Converter.getLongLittle(byArray, n));
    }

    public static final double getDoubleBig(byte[] byArray, int n) {
        return Double.longBitsToDouble(Converter.getLongBig(byArray, n));
    }
}

