/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import org.pentaho.di.core.row.RowMetaInterface;

public class Shape {
    public static final int SHAPE_TYPE_NULL = 0;
    public static final int SHAPE_TYPE_POINT = 1;
    public static final int SHAPE_TYPE_POLYLINE = 3;
    public static final int SHAPE_TYPE_POLYGON = 5;
    public static final int SHAPE_TYPE_MULTIPOINT = 8;
    public static final int SHAPE_TYPE_POINTZ = 11;
    public static final int SHAPE_TYPE_POLYLINE_Z = 13;
    public static final int SHAPE_TYPE_POLYGON_Z = 15;
    public static final int SHAPE_TYPE_MULTIPOINT_Z = 18;
    public static final int SHAPE_TYPE_POINT_M = 21;
    public static final int SHAPE_TYPE_POLYLINE_M = 23;
    public static final int SHAPE_TYPE_POLYGON_M = 25;
    public static final int SHAPE_TYPE_MULTIPOINT_M = 28;
    public static final int SHAPE_TYPE_MULTIPATCH = 31;
    private Object[] dbfData;
    private RowMetaInterface dbfMeta;
    protected int type;

    public static final String getEsriTypeDesc(int n) {
        String string = "Unknown";
        switch (n) {
            case 0: {
                string = "Null Shape";
                break;
            }
            case 1: {
                string = "Point";
                break;
            }
            case 3: {
                string = "PolyLine";
                break;
            }
            case 5: {
                string = "Polygon";
                break;
            }
            case 8: {
                string = "MultiPoint";
                break;
            }
            case 11: {
                string = "PointZ";
                break;
            }
            case 13: {
                string = "PolyLineZ";
                break;
            }
            case 15: {
                string = "PolygonZ";
                break;
            }
            case 18: {
                string = "MultiPointZ";
                break;
            }
            case 21: {
                string = "PointM";
                break;
            }
            case 23: {
                string = "PolyLineM";
                break;
            }
            case 25: {
                string = "PolygonM";
                break;
            }
            case 28: {
                string = "MultiPointM";
                break;
            }
            case 31: {
                string = "MultiPatch";
                break;
            }
        }
        return string;
    }

    public Shape(int n) {
        this.setType(n);
        this.dbfData = null;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeDesc() {
        return Shape.getEsriTypeDesc(this.type);
    }

    public void setType(int n) {
        this.type = n;
    }

    public Object[] getDbfData() {
        return this.dbfData;
    }

    public void setDbfData(Object[] objectArray) {
        this.dbfData = objectArray;
    }

    public RowMetaInterface getDbfMeta() {
        return this.dbfMeta;
    }

    public void setDbfMeta(RowMetaInterface rowMetaInterface) {
        this.dbfMeta = rowMetaInterface;
    }
}

