/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import java.awt.geom.Point2D;
import org.pentaho.gis.shapefiles.Converter;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeInterface;

public class ShapePoint
extends Shape
implements ShapeInterface {
    public double x;
    public double y;

    public ShapePoint(byte[] byArray) {
        super(1);
        this.x = Converter.getDoubleLittle(byArray, 4);
        this.y = Converter.getDoubleLittle(byArray, 12);
    }

    public ShapePoint(double d, double d2) {
        super(1);
        this.x = d;
        this.y = d2;
    }

    public boolean equals(ShapePoint shapePoint) {
        return this.getDistance(shapePoint) < 1.0E-4;
    }

    public double getDistance(ShapePoint shapePoint) {
        return (shapePoint.x - this.x) * (shapePoint.x - this.x) + (shapePoint.y - this.y) * (shapePoint.y - this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public Point2D.Double getPoint2D() {
        return new Point2D.Double(this.x, this.y);
    }
}

