/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import org.pentaho.gis.shapefiles.Converter;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeInterface;
import org.pentaho.gis.shapefiles.ShapePoint;

public class ShapePolyLineM
extends Shape
implements ShapeInterface {
    public int nrparts;
    public int nrpoints;
    public int nrmeasures;
    public double box_minx;
    public double box_miny;
    public double box_maxx;
    public double box_maxy;
    public int[] part_starts;
    public ShapePoint[] point;
    public double mmin;
    public double mmax;
    public double[] measures;

    public ShapePolyLineM(byte[] byArray) {
        super(23);
        int n;
        int n2;
        this.box_minx = Converter.getDoubleLittle(byArray, 4);
        this.box_miny = Converter.getDoubleLittle(byArray, 12);
        this.box_maxx = Converter.getDoubleLittle(byArray, 20);
        this.box_maxy = Converter.getDoubleLittle(byArray, 28);
        this.nrparts = Converter.getIntegerLittle(byArray, 36);
        this.nrpoints = Converter.getIntegerLittle(byArray, 40);
        int n3 = 44;
        int n4 = n3 + this.nrparts * 4;
        int n5 = n4 + 16 * this.nrpoints;
        int n6 = n5 + 8;
        int n7 = n6 + 16;
        int n8 = n7 + 8 * this.nrpoints;
        this.part_starts = new int[this.nrparts];
        this.point = new ShapePoint[this.nrpoints];
        this.measures = null;
        for (n2 = 0; n2 < this.nrparts; ++n2) {
            n = 44 + n2 * 4;
            this.part_starts[n2] = Converter.getIntegerLittle(byArray, n);
        }
        for (n2 = 0; n2 < this.nrpoints; ++n2) {
            n = 44 + this.nrparts * 4 + 16 * n2;
            double d = Converter.getDoubleLittle(byArray, n);
            double d2 = Converter.getDoubleLittle(byArray, n + 8);
            this.point[n2] = new ShapePoint(d, d2);
        }
        if (n8 == byArray.length + 8) {
            n = 44 + this.nrparts * 4 + 16 * this.nrpoints;
            this.mmin = Converter.getDoubleLittle(byArray, n);
            this.mmax = Converter.getDoubleLittle(byArray, n + 8);
            this.measures = new double[this.nrpoints < 0 ? 0 : this.nrpoints];
            for (n2 = 0; n2 < this.nrpoints; ++n2) {
                this.measures[n2] = Converter.getDoubleLittle(byArray, n + 16 + n2 * 8);
            }
        }
    }

    public boolean contains(ShapePoint shapePoint) {
        for (int i = 0; i < this.nrpoints; ++i) {
            if (!shapePoint.equals(this.point[i])) continue;
            return true;
        }
        return false;
    }
}

