/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngine;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInfoXCommand;
import org.apache.oozie.command.coord.CoordActionsKillXCommand;
import org.apache.oozie.command.coord.CoordChangeXCommand;
import org.apache.oozie.command.coord.CoordJobXCommand;
import org.apache.oozie.command.coord.CoordJobsXCommand;
import org.apache.oozie.command.coord.CoordKillXCommand;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.command.coord.CoordUpdateXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogStreamingService;
import org.apache.oozie.util.CoordActionsInDateRange;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogUserFilterParam;

public class CoordinatorEngine
extends BaseEngine {
    private static XLog LOG = XLog.getLog(CoordinatorEngine.class);
    public static final String COORD_ACTIONS_LOG_MAX_COUNT = "oozie.coord.actions.log.max.count";
    private static final int COORD_ACTIONS_LOG_MAX_COUNT_DEFAULT = 50;
    private int maxNumActionsForLog;
    public static final String POSITIVE_FILTER = "positive";
    public static final String NEGATIVE_FILTER = "negative";
    private static final Set<String> FILTER_NAMES = new HashSet<String>();

    public CoordinatorEngine() {
        if (!Services.get().getConf().getBoolean("oozie.useXCommand", true)) {
            LOG.debug("Oozie CoordinatorEngine is not using XCommands.");
        } else {
            LOG.debug("Oozie CoordinatorEngine is using XCommands.");
        }
        this.maxNumActionsForLog = Services.get().getConf().getInt(COORD_ACTIONS_LOG_MAX_COUNT, 50);
    }

    public CoordinatorEngine(String user) {
        this();
        this.user = ParamChecker.notEmpty(user, "user");
    }

    @Override
    public String getDefinition(String jobId) throws BaseEngineException {
        CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
        return job.getOrigJobXml();
    }

    private CoordinatorJobBean getCoordJobWithNoActionInfo(String jobId) throws BaseEngineException {
        try {
            return (CoordinatorJobBean)new CoordJobXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    public CoordinatorActionBean getCoordAction(String actionId) throws BaseEngineException {
        try {
            return (CoordinatorActionBean)new CoordActionInfoXCommand(actionId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public CoordinatorJobBean getCoordJob(String jobId) throws BaseEngineException {
        try {
            return (CoordinatorJobBean)new CoordJobXCommand(jobId).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public CoordinatorJobBean getCoordJob(String jobId, String filter, int offset, int length, boolean desc) throws BaseEngineException {
        Map<String, List<String>> filterMap = this.parseStatusFilter(filter);
        try {
            return (CoordinatorJobBean)new CoordJobXCommand(jobId, filterMap, offset, length, desc).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public String getJobIdForExternalId(String externalId) throws CoordinatorEngineException {
        return null;
    }

    @Override
    public void kill(String jobId) throws CoordinatorEngineException {
        try {
            new CoordKillXCommand(jobId).call();
            LOG.info("User " + this.user + " killed the Coordinator job " + jobId);
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    public CoordinatorActionInfo killActions(String jobId, String rangeType, String scope) throws CoordinatorEngineException {
        try {
            return (CoordinatorActionInfo)new CoordActionsKillXCommand(jobId, rangeType, scope).call();
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    public void change(String jobId, String changeValue) throws CoordinatorEngineException {
        try {
            new CoordChangeXCommand(jobId, changeValue).call();
            LOG.info("User " + this.user + " changed the Coordinator job " + jobId + " to " + changeValue);
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    @Deprecated
    public void reRun(String jobId, Configuration conf) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "invalid use of rerun"));
    }

    public CoordinatorActionInfo reRun(String jobId, String rerunType, String scope, boolean refresh, boolean noCleanup) throws BaseEngineException {
        try {
            return (CoordinatorActionInfo)new CoordRerunXCommand(jobId, rerunType, scope, refresh, noCleanup).call();
        }
        catch (CommandException ex) {
            throw new BaseEngineException(ex);
        }
    }

    @Override
    public void resume(String jobId) throws CoordinatorEngineException {
        try {
            new CoordResumeXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    @Deprecated
    public void start(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "invalid use of start"));
    }

    @Override
    public void streamLog(String jobId, Writer writer, Map<String, String[]> params) throws IOException, BaseEngineException {
        try {
            XLogFilter filter = new XLogFilter(new XLogUserFilterParam(params));
            filter.setParameter("JOB", jobId);
            Date lastTime = null;
            CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
            if (job.isTerminalStatus()) {
                lastTime = job.getLastModifiedTime();
            }
            if (lastTime == null) {
                lastTime = new Date();
            }
            Services.get().get(XLogStreamingService.class).streamLog(filter, job.getCreatedTime(), lastTime, writer, params);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void streamLog(String jobId, String logRetrievalScope, String logRetrievalType, Writer writer, Map<String, String[]> params) throws IOException, BaseEngineException, CommandException {
        Date startTime = null;
        Date endTime = null;
        XLogFilter filter = new XLogFilter(new XLogUserFilterParam(params));
        filter.setParameter("JOB", jobId);
        if (logRetrievalScope != null && logRetrievalType != null) {
            if (logRetrievalType.equals("action")) {
                String[] list;
                LinkedHashSet<String> actionSet = new LinkedHashSet<String>();
                for (String s : list = logRetrievalScope.split(",")) {
                    if ((s = s.trim()).contains("-")) {
                        int end;
                        int start;
                        String[] range = s.split("-");
                        if (range.length != 2) {
                            throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                        }
                        try {
                            start = Integer.parseInt(range[0].trim());
                        }
                        catch (NumberFormatException ne) {
                            throw new CommandException(ErrorCode.E0302, "could not parse " + range[0].trim() + "into an integer", ne);
                        }
                        try {
                            end = Integer.parseInt(range[1].trim());
                        }
                        catch (NumberFormatException ne) {
                            throw new CommandException(ErrorCode.E0302, "could not parse " + range[1].trim() + "into an integer", ne);
                        }
                        if (start > end) {
                            throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "'");
                        }
                        for (int i = start; i <= end; ++i) {
                            actionSet.add(jobId + "@" + i);
                        }
                        continue;
                    }
                    try {
                        Integer.parseInt(s);
                    }
                    catch (NumberFormatException ne) {
                        throw new CommandException(ErrorCode.E0302, "format is wrong for action id'" + s + "'. Integer only.");
                    }
                    actionSet.add(jobId + "@" + s);
                }
                if (actionSet.size() >= this.maxNumActionsForLog) {
                    throw new CommandException(ErrorCode.E0302, "Retrieving log of too many coordinator actions. Max count is " + this.maxNumActionsForLog + " actions");
                }
                Iterator actionsIterator = actionSet.iterator();
                StringBuilder orSeparatedActions = new StringBuilder("");
                boolean orRequired = false;
                while (actionsIterator.hasNext()) {
                    if (orRequired) {
                        orSeparatedActions.append("|");
                    }
                    orSeparatedActions.append(((String)actionsIterator.next()).toString());
                    orRequired = true;
                }
                if (actionSet.size() > 1 && orRequired) {
                    orSeparatedActions.insert(0, "(");
                    orSeparatedActions.append(")");
                }
                filter.setParameter("ACTION", orSeparatedActions.toString());
                if (actionSet != null && actionSet.size() == 1) {
                    CoordinatorActionBean actionBean = this.getCoordAction((String)actionSet.iterator().next());
                    startTime = actionBean.getCreatedTime();
                    endTime = actionBean.getStatus().equals((Object)CoordinatorAction.Status.RUNNING) ? new Date() : actionBean.getLastModifiedTime();
                    filter.setActionList(true);
                } else if (actionSet != null && actionSet.size() > 0) {
                    ArrayList tempList = new ArrayList(actionSet);
                    Collections.sort(tempList, new Comparator<String>(){

                        @Override
                        public int compare(String a, String b) {
                            return Integer.valueOf(a.substring(a.lastIndexOf("@") + 1)).compareTo(Integer.valueOf(b.substring(b.lastIndexOf("@") + 1)));
                        }
                    });
                    startTime = this.getCoordAction((String)tempList.get(0)).getCreatedTime();
                    endTime = CoordActionsInDateRange.getCoordActionsLastModifiedDate(jobId, (String)tempList.get(0), (String)tempList.get(tempList.size() - 1));
                    filter.setActionList(true);
                }
            }
            if (logRetrievalType.equalsIgnoreCase("date")) {
                List<String> coordActionIdList = null;
                try {
                    coordActionIdList = CoordActionsInDateRange.getCoordActionIdsFromDates(jobId, logRetrievalScope);
                }
                catch (XException xe) {
                    throw new CommandException(ErrorCode.E0302, "Error in date range for coordinator actions", xe);
                }
                if (coordActionIdList.size() >= this.maxNumActionsForLog) {
                    throw new CommandException(ErrorCode.E0302, "Retrieving log of too many coordinator actions. Max count is " + this.maxNumActionsForLog + " actions");
                }
                StringBuilder orSeparatedActions = new StringBuilder("");
                boolean orRequired = false;
                for (String coordActionId : coordActionIdList) {
                    if (orRequired) {
                        orSeparatedActions.append("|");
                    }
                    orSeparatedActions.append(coordActionId);
                    orRequired = true;
                }
                if (coordActionIdList.size() > 1 && orRequired) {
                    orSeparatedActions.insert(0, "(");
                    orSeparatedActions.append(")");
                }
                filter.setParameter("ACTION", orSeparatedActions.toString());
                if (coordActionIdList != null && coordActionIdList.size() == 1) {
                    CoordinatorActionBean actionBean = this.getCoordAction(coordActionIdList.get(0));
                    startTime = actionBean.getCreatedTime();
                    endTime = actionBean.getStatus().equals((Object)CoordinatorAction.Status.RUNNING) ? new Date() : actionBean.getLastModifiedTime();
                    filter.setActionList(true);
                } else if (coordActionIdList != null && coordActionIdList.size() > 0) {
                    Collections.sort(coordActionIdList, new Comparator<String>(){

                        @Override
                        public int compare(String a, String b) {
                            return Integer.valueOf(a.substring(a.lastIndexOf("@") + 1)).compareTo(Integer.valueOf(b.substring(b.lastIndexOf("@") + 1)));
                        }
                    });
                    startTime = this.getCoordAction(coordActionIdList.get(0)).getCreatedTime();
                    endTime = CoordActionsInDateRange.getCoordActionsLastModifiedDate(jobId, coordActionIdList.get(0), coordActionIdList.get(coordActionIdList.size() - 1));
                    filter.setActionList(true);
                }
            }
        }
        if (startTime == null || endTime == null) {
            CoordinatorJobBean job = this.getCoordJobWithNoActionInfo(jobId);
            if (startTime == null) {
                startTime = job.getCreatedTime();
            }
            if (endTime == null) {
                if (job.isTerminalStatus()) {
                    endTime = job.getLastModifiedTime();
                }
                if (endTime == null) {
                    endTime = new Date();
                }
            }
        }
        Services.get().get(XLogStreamingService.class).streamLog(filter, startTime, endTime, writer, params);
    }

    @Override
    public String submitJob(Configuration conf, boolean startJob) throws CoordinatorEngineException {
        try {
            CoordSubmitXCommand submit = new CoordSubmitXCommand(conf);
            return (String)submit.call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    @Override
    public String dryRunSubmit(Configuration conf) throws CoordinatorEngineException {
        try {
            CoordSubmitXCommand submit = new CoordSubmitXCommand(true, conf);
            return (String)submit.call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    @Override
    public void suspend(String jobId) throws CoordinatorEngineException {
        try {
            new CoordSuspendXCommand(jobId).call();
        }
        catch (CommandException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    @Override
    public WorkflowJob getJob(String jobId) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "cannot get a workflow job from CoordinatorEngine"));
    }

    @Override
    public WorkflowJob getJob(String jobId, int start, int length) throws BaseEngineException {
        throw new BaseEngineException(new XException(ErrorCode.E0301, "cannot get a workflow job from CoordinatorEngine"));
    }

    public CoordinatorJobInfo getCoordJobs(String filter, int start, int len) throws CoordinatorEngineException {
        Map<String, List<String>> filterList = this.parseFilter(filter);
        try {
            return (CoordinatorJobInfo)new CoordJobsXCommand(filterList, start, len).call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    private Map<String, List<String>> parseStatusFilter(String filter) throws CoordinatorEngineException {
        HashMap<String, List<String>> filterMap = new HashMap<String, List<String>>();
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    boolean negative = false;
                    String[] pair = null;
                    if (token.contains("!=")) {
                        negative = true;
                        pair = token.split("!=");
                    } else {
                        pair = token.split("=");
                    }
                    if (pair.length != 2) {
                        throw new CoordinatorEngineException(ErrorCode.E0421, token, "elements must be name=value or name!=value pairs");
                    }
                    if (pair[0].equalsIgnoreCase("status")) {
                        List oFilterList;
                        String statusValue = pair[1];
                        try {
                            CoordinatorAction.Status.valueOf((String)statusValue);
                        }
                        catch (IllegalArgumentException ex) {
                            StringBuilder validStatusList = new StringBuilder();
                            for (CoordinatorAction.Status status : CoordinatorAction.Status.values()) {
                                validStatusList.append(status.toString() + " ");
                            }
                            throw new CoordinatorEngineException(ErrorCode.E0421, filter, XLog.format("invalid status value [{0}]. Valid status values are: [{1}]", statusValue, validStatusList));
                        }
                        String filterType = negative ? NEGATIVE_FILTER : POSITIVE_FILTER;
                        String oppositeFilterType = negative ? POSITIVE_FILTER : NEGATIVE_FILTER;
                        ArrayList<String> filterList = (ArrayList<String>)filterMap.get(filterType);
                        if (filterList == null) {
                            filterList = new ArrayList<String>();
                            filterMap.put(filterType, filterList);
                        }
                        if ((oFilterList = (List)filterMap.get(oppositeFilterType)) != null && oFilterList.contains(statusValue)) {
                            throw new CoordinatorEngineException(ErrorCode.E0421, filter, XLog.format("the status [{0}] specified in both positive and negative filters", statusValue));
                        }
                        filterList.add(statusValue);
                        continue;
                    }
                    throw new CoordinatorEngineException(ErrorCode.E0421, filter, XLog.format("invalid filter [{0}]. The only valid filter is \"status\"", pair[0]));
                }
                throw new CoordinatorEngineException(ErrorCode.E0421, token, "elements must be name=value or name!=value pairs");
            }
        }
        return filterMap;
    }

    @VisibleForTesting
    Map<String, List<String>> parseFilter(String filter) throws CoordinatorEngineException {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        boolean isTimeUnitSpecified = false;
        String timeUnit = "MINUTE";
        boolean isFrequencySpecified = false;
        String frequency = "";
        if (filter != null) {
            StringTokenizer st = new StringTokenizer(filter, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.contains("=")) {
                    ArrayList<String> list;
                    String[] pair = token.split("=");
                    if (pair.length != 2) {
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
                    }
                    if (!FILTER_NAMES.contains(pair[0].toLowerCase())) {
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid name [{0}]", pair[0]));
                    }
                    if (pair[0].equalsIgnoreCase("frequency")) {
                        isFrequencySpecified = true;
                        try {
                            frequency = (int)Float.parseFloat(pair[1]) + "";
                            continue;
                        }
                        catch (NumberFormatException NANException) {
                            throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid value [{0}] for frequency. A numerical value is expected", pair[1]));
                        }
                    }
                    if (pair[0].equalsIgnoreCase("unit")) {
                        isTimeUnitSpecified = true;
                        timeUnit = pair[1];
                        if (timeUnit.equalsIgnoreCase("months") || timeUnit.equalsIgnoreCase("days") || timeUnit.equalsIgnoreCase("hours") || timeUnit.equalsIgnoreCase("minutes")) continue;
                        throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid value [{0}] for time unit. Valid value is one of months, days, hours or minutes", pair[1]));
                    }
                    if (pair[0].equals("status")) {
                        try {
                            Job.Status.valueOf((String)pair[1]);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new CoordinatorEngineException(ErrorCode.E0420, filter, XLog.format("invalid status [{0}]", pair[1]));
                        }
                    }
                    if ((list = (ArrayList<String>)map.get(pair[0])) == null) {
                        list = new ArrayList<String>();
                        map.put(pair[0], list);
                    }
                    list.add(pair[1]);
                    continue;
                }
                throw new CoordinatorEngineException(ErrorCode.E0420, filter, "elements must be name=value pairs");
            }
            if (!isFrequencySpecified && isTimeUnitSpecified) {
                throw new CoordinatorEngineException(ErrorCode.E0420, filter, "time unit should be added only when frequency is specified. Either specify frequency also or else remove the time unit");
            }
            if (isFrequencySpecified) {
                if (isTimeUnitSpecified) {
                    if (timeUnit.equalsIgnoreCase("months")) {
                        timeUnit = "MONTH";
                    } else if (timeUnit.equalsIgnoreCase("days")) {
                        timeUnit = "DAY";
                    } else if (timeUnit.equalsIgnoreCase("hours")) {
                        frequency = Integer.parseInt(frequency) * 60 + "";
                        timeUnit = "MINUTE";
                    } else if (timeUnit.equalsIgnoreCase("minutes")) {
                        timeUnit = "MINUTE";
                    }
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(timeUnit);
                map.put("unit", list);
                list = new ArrayList();
                list.add(frequency);
                map.put("frequency", list);
            }
        }
        return map;
    }

    public List<WorkflowJobBean> getReruns(String coordActionId) throws CoordinatorEngineException {
        List<WorkflowJobBean> wfBeans;
        try {
            wfBeans = WorkflowJobQueryExecutor.getInstance().getList(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOWS_PARENT_COORD_RERUN, coordActionId);
        }
        catch (JPAExecutorException e) {
            throw new CoordinatorEngineException(e);
        }
        return wfBeans;
    }

    public String updateJob(Configuration conf, String jobId, boolean dryrun, boolean showDiff) throws CoordinatorEngineException {
        try {
            CoordUpdateXCommand update = new CoordUpdateXCommand(dryrun, conf, jobId, showDiff);
            return (String)update.call();
        }
        catch (CommandException ex) {
            throw new CoordinatorEngineException(ex);
        }
    }

    @Override
    public String getJobStatus(String jobId) throws CoordinatorEngineException {
        try {
            CoordinatorJobBean coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_STATUS, jobId);
            return coordJob.getStatusStr();
        }
        catch (JPAExecutorException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    public String getActionStatus(String actionId) throws CoordinatorEngineException {
        try {
            CoordinatorActionBean coordAction = CoordActionQueryExecutor.getInstance().get(CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION_STATUS, actionId);
            return coordAction.getStatusStr();
        }
        catch (JPAExecutorException e) {
            throw new CoordinatorEngineException(e);
        }
    }

    static {
        FILTER_NAMES.add("user");
        FILTER_NAMES.add("name");
        FILTER_NAMES.add("group");
        FILTER_NAMES.add("status");
        FILTER_NAMES.add("id");
        FILTER_NAMES.add("frequency");
        FILTER_NAMES.add("unit");
    }
}

