/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.email;

import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class EmailActionExecutor
extends ActionExecutor {
    public static final String CONF_PREFIX = "oozie.email.";
    public static final String EMAIL_SMTP_HOST = "oozie.email.smtp.host";
    public static final String EMAIL_SMTP_PORT = "oozie.email.smtp.port";
    public static final String EMAIL_SMTP_AUTH = "oozie.email.smtp.auth";
    public static final String EMAIL_SMTP_USER = "oozie.email.smtp.username";
    public static final String EMAIL_SMTP_PASS = "oozie.email.smtp.password";
    public static final String EMAIL_SMTP_FROM = "oozie.email.from.address";
    private static final String TO = "to";
    private static final String CC = "cc";
    private static final String SUB = "subject";
    private static final String BOD = "body";
    private static final String COMMA = ",";
    private static final String CONTENT_TYPE = "content_type";
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";

    public EmailActionExecutor() {
        super("email");
    }

    @Override
    public void initActionType() {
        super.initActionType();
    }

    @Override
    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        try {
            context.setStartData("-", "-", "-");
            Element actionXml = XmlUtils.parseXml(action.getConf());
            this.validateAndMail(context, actionXml);
            context.setExecutionData("OK", null);
        }
        catch (Exception ex) {
            throw this.convertException(ex);
        }
    }

    protected void validateAndMail(ActionExecutor.Context context, Element element) throws ActionExecutorException {
        Namespace ns = element.getNamespace();
        String[] tos = new String[]{};
        String[] ccs = new String[]{};
        String subject = "";
        String body = "";
        Object child = null;
        String text = element.getChildTextTrim(TO, ns);
        if (text.isEmpty()) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM001", "No receipents were specified in the to-address field.");
        }
        tos = text.split(COMMA);
        try {
            ccs = element.getChildTextTrim(CC, ns).split(COMMA);
        }
        catch (Exception e) {
            ccs = new String[]{};
        }
        subject = element.getChildTextTrim(SUB, ns);
        body = element.getChildTextTrim(BOD, ns);
        String contentType = element.getChildTextTrim(CONTENT_TYPE, ns);
        if (contentType == null || contentType.isEmpty()) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        this.email(context, tos, ccs, subject, body, contentType);
    }

    protected void email(ActionExecutor.Context context, String[] to, String[] cc, String subject, String body, String contentType) throws ActionExecutorException {
        String smtpHost = this.getOozieConf().get(EMAIL_SMTP_HOST, "localhost");
        String smtpPort = this.getOozieConf().get(EMAIL_SMTP_PORT, "25");
        Boolean smtpAuth = this.getOozieConf().getBoolean(EMAIL_SMTP_AUTH, false);
        String smtpUser = this.getOozieConf().get(EMAIL_SMTP_USER, "");
        String smtpPassword = this.getOozieConf().get(EMAIL_SMTP_PASS, "");
        String fromAddr = this.getOozieConf().get(EMAIL_SMTP_FROM, "oozie@localhost");
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", smtpHost);
        properties.setProperty("mail.smtp.port", smtpPort);
        properties.setProperty("mail.smtp.auth", smtpAuth.toString());
        Session session = smtpAuth == false ? Session.getInstance((Properties)properties) : Session.getInstance((Properties)properties, (Authenticator)new JavaMailAuthenticator(smtpUser, smtpPassword));
        MimeMessage message = new MimeMessage(session);
        ArrayList<InternetAddress> toAddrs = new ArrayList<InternetAddress>(to.length);
        ArrayList<InternetAddress> ccAddrs = new ArrayList<InternetAddress>(cc.length);
        try {
            InternetAddress from = new InternetAddress(fromAddr);
            message.setFrom((Address)from);
        }
        catch (AddressException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM002", "Bad from address specified in ${oozie.email.from.address}.", new Object[]{e});
        }
        catch (MessagingException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM003", "Error setting a from address in the message.", new Object[]{e});
        }
        try {
            for (String toStr : to) {
                toAddrs.add(new InternetAddress(toStr.trim()));
            }
            message.addRecipients(Message.RecipientType.TO, (Address[])toAddrs.toArray(new InternetAddress[0]));
            for (String ccStr : cc) {
                ccAddrs.add(new InternetAddress(ccStr.trim()));
            }
            message.addRecipients(Message.RecipientType.CC, (Address[])ccAddrs.toArray(new InternetAddress[0]));
            message.setSubject(subject);
            message.setContent((Object)body, contentType);
        }
        catch (AddressException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM004", "Bad address format in <to> or <cc>.", new Object[]{e});
        }
        catch (MessagingException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM005", "An error occured while adding recipients.", new Object[]{e});
        }
        try {
            Transport.send((Message)message);
        }
        catch (NoSuchProviderException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM006", "Could not find an SMTP transport provider to email.", new Object[]{e});
        }
        catch (MessagingException e) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "EM007", "Encountered an error while sending the email message over SMTP.", new Object[]{e});
        }
    }

    @Override
    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        String externalStatus = action.getExternalStatus();
        WorkflowAction.Status status = externalStatus.equals("OK") ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
        context.setEndData(status, this.getActionSignal(status));
    }

    @Override
    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    @Override
    public boolean isCompleted(String externalStatus) {
        return true;
    }

    public static class JavaMailAuthenticator
    extends Authenticator {
        String user;
        String password;

        public JavaMailAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

