/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.coord.CoordinatorXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionByActionNumberJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;

public class CoordChangeXCommand
extends CoordinatorXCommand<Void> {
    private final String jobId;
    private Date newEndTime = null;
    private Integer newConcurrency = null;
    private Date newPauseTime = null;
    private Date oldPauseTime = null;
    private boolean resetPauseTime = false;
    private Job.Status jobStatus = null;
    private CoordinatorJobBean coordJob;
    private JPAService jpaService = null;
    private Job.Status prevStatus;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private List<JsonBean> deleteList = new ArrayList<JsonBean>();
    private static final Set<String> ALLOWED_CHANGE_OPTIONS = new HashSet<String>();

    public CoordChangeXCommand(String id, String changeValue) throws CommandException {
        super("coord_change", "coord_change", 0);
        this.jobId = ParamChecker.notEmpty(id, "id");
        ParamChecker.notEmpty(changeValue, "value");
        this.validateChangeValue(changeValue);
    }

    private void validateChangeValue(String changeValue) throws CommandException {
        String value;
        Map<String, String> map = JobUtils.parseChangeValue(changeValue);
        if (map.size() > ALLOWED_CHANGE_OPTIONS.size()) {
            throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime|status");
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if (!ALLOWED_CHANGE_OPTIONS.contains(key)) {
                throw new CommandException(ErrorCode.E1015, changeValue, "must change endtime|concurrency|pausetime|status");
            }
            if (key.equals("pausetime") || !value2.equalsIgnoreCase("")) continue;
            throw new CommandException(ErrorCode.E1015, changeValue, "value on " + key + " can not be empty");
        }
        if (map.containsKey("endtime")) {
            value = map.get("endtime");
            try {
                this.newEndTime = DateUtils.parseDateOozieTZ(value);
            }
            catch (Exception ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
            }
        }
        if (map.containsKey("concurrency")) {
            value = map.get("concurrency");
            try {
                this.newConcurrency = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new CommandException(ErrorCode.E1015, value, "must be a valid integer");
            }
        }
        if (map.containsKey("pausetime")) {
            value = map.get("pausetime");
            if (value.equals("")) {
                this.resetPauseTime = true;
            } else {
                try {
                    this.newPauseTime = DateUtils.parseDateOozieTZ(value);
                }
                catch (Exception ex) {
                    throw new CommandException(ErrorCode.E1015, value, "must be a valid date");
                }
            }
        }
        if (map.containsKey("status") && !StringUtils.isEmpty((String)(value = map.get("status")))) {
            this.jobStatus = Job.Status.valueOf((String)value);
        }
    }

    private void checkEndTime(CoordinatorJobBean coordJob, Date newEndTime) throws CommandException {
    }

    private void checkPauseTime(CoordinatorJobBean coordJob, Date newPauseTime) throws CommandException {
    }

    private void checkStatusChange(CoordinatorJobBean coordJob, Job.Status jobStatus) throws CommandException {
        if (!jobStatus.equals((Object)Job.Status.RUNNING)) {
            throw new CommandException(ErrorCode.E1015, jobStatus, " must be RUNNING");
        }
        if (!coordJob.getStatus().equals((Object)Job.Status.FAILED) && !coordJob.getStatus().equals((Object)Job.Status.KILLED)) {
            throw new CommandException(ErrorCode.E1015, jobStatus, " Only FAILED or KILLED job can be changed to RUNNING. Current job status is " + coordJob.getStatus());
        }
    }

    private void processLookaheadActions(CoordinatorJobBean coordJob, Date newTime) throws CommandException, JPAExecutorException {
        int lastActionNumber = coordJob.getLastActionNumber();
        Date lastActionTime = null;
        Date tempDate = null;
        while ((tempDate = this.deleteAction(lastActionNumber, newTime)) != null) {
            --lastActionNumber;
            lastActionTime = tempDate;
        }
        if (lastActionTime != null) {
            this.LOG.debug("New pause/end date is : " + newTime + " and last action number is : " + lastActionNumber);
            coordJob.setLastActionNumber(lastActionNumber);
            coordJob.setLastActionTime(lastActionTime);
            coordJob.setNextMaterializedTime(lastActionTime);
            coordJob.resetDoneMaterialization();
        }
    }

    private Date deleteAction(int actionNum, Date afterDate) throws CommandException {
        try {
            if (actionNum <= 0) {
                return null;
            }
            String actionId = this.jpaService.execute(new CoordJobGetActionByActionNumberJPAExecutor(this.jobId, actionNum));
            CoordinatorActionBean bean = this.jpaService.execute(new CoordActionGetJPAExecutor(actionId));
            if (afterDate.compareTo(bean.getNominalTime()) <= 0) {
                SLASummaryBean slaSummaryBean;
                SLARegistrationBean slaReg;
                if (SLAService.isEnabled()) {
                    Services.get().get(SLAService.class).removeRegistration(actionId);
                }
                if ((slaReg = SLARegistrationQueryExecutor.getInstance().get(SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, actionId)) != null) {
                    this.LOG.debug("Deleting registration bean corresponding to action " + slaReg.getId());
                    this.deleteList.add(slaReg);
                }
                if ((slaSummaryBean = SLASummaryQueryExecutor.getInstance().get(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, actionId)) != null) {
                    this.LOG.debug("Deleting summary bean corresponding to action " + slaSummaryBean.getId());
                    this.deleteList.add(slaSummaryBean);
                }
                if (bean.getStatus() != CoordinatorAction.Status.WAITING && bean.getStatus() != CoordinatorAction.Status.READY) {
                    throw new CommandException(ErrorCode.E1022, bean.getId());
                }
                this.deleteList.add(bean);
                return bean.getNominalTime();
            }
            return null;
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
    }

    private void check(CoordinatorJobBean coordJob, Date newEndTime, Integer newConcurrency, Date newPauseTime, Job.Status jobStatus) throws CommandException {
        if (coordJob.getStatus() == Job.Status.KILLED && (jobStatus == null || newEndTime != null || newConcurrency != null || newPauseTime != null)) {
            throw new CommandException(ErrorCode.E1016, new Object[0]);
        }
        if (newEndTime != null) {
            this.checkEndTime(coordJob, newEndTime);
        }
        if (newPauseTime != null) {
            this.checkPauseTime(coordJob, newPauseTime);
        }
        if (jobStatus != null) {
            this.checkStatusChange(coordJob, jobStatus);
        }
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.info("STARTED CoordChangeXCommand for jobId=" + this.jobId);
        try {
            if (this.newEndTime != null) {
                boolean dontChange;
                boolean bl = dontChange = this.coordJob.getEndTime().before(this.newEndTime) && this.coordJob.getNextMaterializedTime() != null && this.coordJob.getNextMaterializedTime().after(this.newEndTime);
                if (!dontChange) {
                    this.coordJob.setEndTime(this.newEndTime);
                    if (this.coordJob.getStartTime().compareTo(this.newEndTime) >= 0) {
                        if (this.coordJob.getStatus() != Job.Status.PREP) {
                            this.processLookaheadActions(this.coordJob, this.newEndTime);
                        }
                        if (this.coordJob.getStatus() == Job.Status.PREP || this.coordJob.getStatus() == Job.Status.RUNNING) {
                            this.LOG.info("Changing coord status to SUCCEEDED, because it's in " + this.coordJob.getStatus() + " and new end time is before start time. Startime is " + this.coordJob.getStartTime() + " and new end time is " + this.newEndTime);
                            this.coordJob.setStatus(Job.Status.SUCCEEDED);
                            this.coordJob.resetPending();
                        }
                        this.coordJob.setDoneMaterialization();
                    } else {
                        if (this.coordJob.getStatus() == Job.Status.SUCCEEDED) {
                            this.coordJob.setStatus(Job.Status.RUNNING);
                        }
                        if (this.coordJob.getStatus() == Job.Status.DONEWITHERROR || this.coordJob.getStatus() == Job.Status.FAILED) {
                            this.coordJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(Job.Status.RUNNINGWITHERROR));
                        }
                        this.coordJob.setPending();
                        this.coordJob.resetDoneMaterialization();
                        this.processLookaheadActions(this.coordJob, this.newEndTime);
                    }
                } else {
                    this.LOG.info("Didn't change endtime. Endtime is in between coord end time and next materialization time.Coord endTime = " + DateUtils.formatDateOozieTZ(this.newEndTime) + " next materialization time =" + DateUtils.formatDateOozieTZ(this.coordJob.getNextMaterializedTime()));
                }
            }
            if (this.newConcurrency != null) {
                this.coordJob.setConcurrency(this.newConcurrency);
            }
            if (this.newPauseTime != null || this.resetPauseTime) {
                this.coordJob.setPauseTime(this.newPauseTime);
                if (this.oldPauseTime != null && this.newPauseTime != null) {
                    if (this.oldPauseTime.before(this.newPauseTime)) {
                        if (this.coordJob.getStatus() == Job.Status.PAUSED) {
                            this.coordJob.setStatus(Job.Status.RUNNING);
                        } else if (this.coordJob.getStatus() == Job.Status.PAUSEDWITHERROR) {
                            this.coordJob.setStatus(Job.Status.RUNNINGWITHERROR);
                        }
                    }
                } else if (this.oldPauseTime != null && this.newPauseTime == null) {
                    if (this.coordJob.getStatus() == Job.Status.PAUSED) {
                        this.coordJob.setStatus(Job.Status.RUNNING);
                    } else if (this.coordJob.getStatus() == Job.Status.PAUSEDWITHERROR) {
                        this.coordJob.setStatus(Job.Status.RUNNINGWITHERROR);
                    }
                }
                if (!this.resetPauseTime) {
                    this.processLookaheadActions(this.coordJob, this.newPauseTime);
                }
            }
            if (this.jobStatus != null) {
                this.coordJob.setStatus(this.jobStatus);
                this.LOG.info("Coord status is changed to RUNNING from " + this.prevStatus);
                this.coordJob.setPending();
                if (this.jobStatus.equals((Object)Job.Status.RUNNING) && this.coordJob.getNextMaterializedTime() != null && this.coordJob.getEndTime().after(this.coordJob.getNextMaterializedTime())) {
                    this.coordJob.resetDoneMaterialization();
                }
            }
            if (this.coordJob.getNextMaterializedTime() != null && this.coordJob.getEndTime().compareTo(this.coordJob.getNextMaterializedTime()) <= 0) {
                this.LOG.info("[" + this.coordJob.getId() + "]: all actions have been materialized, job status = " + this.coordJob.getStatus() + ", set pending to true");
                this.coordJob.setDoneMaterialization();
            }
            this.coordJob.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_CHANGE, this.coordJob));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, this.deleteList);
            Void dontChange = null;
            return dontChange;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
        finally {
            this.LOG.info("ENDED CoordChangeXCommand for jobId=" + this.jobId);
            if (this.coordJob.getBundleId() != null) {
                BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus, true);
                bundleStatusUpdate.call();
            }
        }
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        try {
            this.coordJob = this.jpaService.execute(new CoordJobGetJPAExecutor(this.jobId));
            this.oldPauseTime = this.coordJob.getPauseTime();
            this.prevStatus = this.coordJob.getStatus();
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.coordJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.check(this.coordJob, this.newEndTime, this.newConcurrency, this.newPauseTime, this.jobStatus);
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    static {
        ALLOWED_CHANGE_OPTIONS.add("endtime");
        ALLOWED_CHANGE_OPTIONS.add("concurrency");
        ALLOWED_CHANGE_OPTIONS.add("pausetime");
        ALLOWED_CHANGE_OPTIONS.add("status");
    }
}

