/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.SuspendTransitionXCommand;
import org.apache.oozie.command.bundle.BundleStatusUpdateXCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionsRunningJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;

public class CoordSuspendXCommand
extends SuspendTransitionXCommand {
    private final String jobId;
    private CoordinatorJobBean coordJob;
    private JPAService jpaService;
    private boolean exceptionOccured = false;
    private Job.Status prevStatus = null;

    public CoordSuspendXCommand(String id) {
        super("coord_suspend", "coord_suspend", 1);
        this.jobId = ParamChecker.notEmpty(id, "id");
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        super.eagerLoadState();
        try {
            this.jpaService = Services.get().get(JPAService.class);
            if (this.jpaService == null) {
                throw new CommandException(ErrorCode.E0610, new Object[0]);
            }
            this.coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB_SUSPEND_KILL, this.jobId);
            this.prevStatus = this.coordJob.getStatus();
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
        LogUtils.setLogInfo(this.coordJob, this.logInfo);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        super.eagerVerifyPrecondition();
        if (this.coordJob.getStatus() == Job.Status.SUCCEEDED || this.coordJob.getStatus() == Job.Status.FAILED || this.coordJob.getStatus() == Job.Status.KILLED) {
            this.LOG.info("CoordSuspendXCommand is not going to execute because job finished or failed or killed, id = " + this.jobId + ", status = " + this.coordJob.getStatus());
            throw new PreconditionException(ErrorCode.E0728, this.jobId, this.coordJob.getStatus().toString());
        }
    }

    @Override
    public void suspendChildren() throws CommandException {
        try {
            List<CoordinatorActionBean> actionList = this.jpaService.execute(new CoordJobGetActionsRunningJPAExecutor(this.jobId));
            for (CoordinatorActionBean action : actionList) {
                if (action.getExternalId() != null) {
                    this.queue(new SuspendXCommand(action.getExternalId()));
                    this.updateCoordAction(action);
                    this.LOG.debug("Suspend coord action = [{0}], new status = [{1}], pending = [{2}] and queue SuspendXCommand for [{3}]", action.getId(), action.getStatus(), action.getPending(), action.getExternalId());
                    continue;
                }
                this.updateCoordAction(action);
                this.LOG.debug("Suspend coord action = [{0}], new status = [{1}], pending = [{2}] and external id is null", action.getId(), action.getStatus(), action.getPending());
            }
            this.LOG.debug("Suspended coordinator actions for the coordinator=[{0}]", this.jobId);
        }
        catch (XException ex) {
            this.exceptionOccured = true;
            throw new CommandException(ex);
        }
        finally {
            if (this.exceptionOccured) {
                this.coordJob.setStatus(Job.Status.FAILED);
                this.coordJob.resetPending();
                this.LOG.debug("Exception happened, fail coordinator job id = " + this.jobId + ", status = " + this.coordJob.getStatus());
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING_TIME, this.coordJob));
            }
        }
    }

    @Override
    public void notifyParent() throws CommandException {
        if (this.coordJob.getBundleId() != null) {
            BundleStatusUpdateXCommand bundleStatusUpdate = new BundleStatusUpdateXCommand(this.coordJob, this.prevStatus);
            bundleStatusUpdate.call();
        }
    }

    @Override
    public void updateJob() {
        InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
        this.coordJob.setLastModifiedTime(new Date());
        this.coordJob.setSuspendedTime(new Date());
        this.LOG.debug("Suspend coordinator job id = " + this.jobId + ", status = " + this.coordJob.getStatus() + ", pending = " + this.coordJob.isPending());
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS_PENDING_TIME, this.coordJob));
    }

    @Override
    public void performWrites() throws CommandException {
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
        }
        catch (JPAExecutorException jex) {
            throw new CommandException(jex);
        }
    }

    private void updateCoordAction(CoordinatorActionBean action) {
        action.setStatus(CoordinatorAction.Status.SUSPENDED);
        action.incrementAndGetPending();
        action.setLastModifiedTime(new Date());
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordActionQueryExecutor.CoordActionQuery>(CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, action));
    }

    @Override
    public Job getJob() {
        return this.coordJob;
    }

    @Override
    public void transitToNext() {
        if (this.coordJob == null) {
            this.coordJob = (CoordinatorJobBean)this.getJob();
        }
        if (this.coordJob.getStatus() == Job.Status.PREP) {
            this.coordJob.setStatus(Job.Status.PREPSUSPENDED);
            this.coordJob.setStatus(StatusUtils.getStatus(this.coordJob));
        } else if (this.coordJob.getStatus() == Job.Status.RUNNING) {
            this.coordJob.setStatus(Job.Status.SUSPENDED);
        } else if (this.coordJob.getStatus() == Job.Status.RUNNINGWITHERROR || this.coordJob.getStatus() == Job.Status.PAUSEDWITHERROR) {
            this.coordJob.setStatus(Job.Status.SUSPENDEDWITHERROR);
        } else if (this.coordJob.getStatus() == Job.Status.PAUSED) {
            this.coordJob.setStatus(Job.Status.SUSPENDED);
        } else if (this.coordJob.getStatus() == Job.Status.PREPPAUSED) {
            this.coordJob.setStatus(Job.Status.PREPSUSPENDED);
        }
        this.coordJob.setPending();
    }
}

