/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.HistogramDiff;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.jdom.Element;

public class CoordUpdateXCommand
extends CoordSubmitXCommand {
    private final String jobId;
    private boolean showDiff = true;
    private boolean isConfChange = false;
    StringBuffer diff = new StringBuffer();
    CoordinatorJobBean oldCoordJob = null;

    public CoordUpdateXCommand(boolean dryrun, Configuration conf, String jobId) {
        super(dryrun, conf);
        this.jobId = jobId;
        this.isConfChange = conf.size() != 0;
    }

    public CoordUpdateXCommand(boolean dryrun, Configuration conf, String jobId, boolean showDiff) {
        super(dryrun, conf);
        this.jobId = jobId;
        this.showDiff = showDiff;
        this.isConfChange = conf.size() != 0;
    }

    @Override
    protected String storeToDB(String xmlElement, Element eJob, CoordinatorJobBean coordJob) throws CommandException {
        this.check(this.oldCoordJob, coordJob);
        this.computeDiff(eJob);
        this.oldCoordJob.setAppPath(this.conf.get("oozie.coord.application.path"));
        if (this.isConfChange) {
            this.oldCoordJob.setConf(XmlUtils.prettyPrint(this.conf).toString());
        }
        this.oldCoordJob.setMatThrottling(coordJob.getMatThrottling());
        this.oldCoordJob.setOrigJobXml(xmlElement);
        this.oldCoordJob.setConcurrency(coordJob.getConcurrency());
        this.oldCoordJob.setExecution(coordJob.getExecution());
        this.oldCoordJob.setTimeout(coordJob.getTimeout());
        this.oldCoordJob.setJobXml(XmlUtils.prettyPrint(eJob).toString());
        if (!this.dryrun) {
            this.oldCoordJob.setLastModifiedTime(new Date());
            this.LOG.info("Coord update changes : " + this.diff.toString());
            try {
                CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, this.oldCoordJob);
            }
            catch (JPAExecutorException jpaee) {
                throw new CommandException(jpaee);
            }
        }
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        super.loadState();
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
        this.coordJob = new CoordinatorJobBean();
        try {
            this.oldCoordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, this.jobId);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.oldCoordJob, this.logInfo);
        if (!this.isConfChange) {
            try {
                this.conf = new XConfiguration(new StringReader(this.coordJob.getConf()));
            }
            catch (Exception e) {
                throw new CommandException(ErrorCode.E1023, e.getMessage(), e);
            }
        }
        this.coordJob.setConf(XmlUtils.prettyPrint(this.conf).toString());
        this.setJob((Job)this.coordJob);
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
        if (this.coordJob.getStatus() == Job.Status.SUCCEEDED || this.coordJob.getStatus() == Job.Status.DONEWITHERROR) {
            this.LOG.info("Can't update coord job. Job has finished processing");
            throw new CommandException(ErrorCode.E1023, "Can't update coord job. Job has finished processing");
        }
    }

    private void computeDiff(Element eJob) {
        try {
            this.diff.append("**********Job definition changes**********").append(System.getProperty("line.separator"));
            this.diff.append(this.getDiffinGitFormat(this.oldCoordJob.getJobXml(), XmlUtils.prettyPrint(eJob).toString()));
            this.diff.append("******************************************").append(System.getProperty("line.separator"));
            this.diff.append("**********Job conf changes****************").append(System.getProperty("line.separator"));
            if (this.isConfChange) {
                this.diff.append(this.getDiffinGitFormat(this.oldCoordJob.getConf(), XmlUtils.prettyPrint(this.conf).toString()));
            } else {
                this.diff.append("No conf update requested").append(System.getProperty("line.separator"));
            }
            this.diff.append("******************************************").append(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            this.diff.append("Error computing diff. Error " + e.getMessage());
            this.LOG.warn((Object)"Error computing diff.", e);
        }
    }

    private String getDiffinGitFormat(String string1, String string2) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        RawText rt1 = new RawText(string1.getBytes());
        RawText rt2 = new RawText(string2.getBytes());
        EditList diffList = new EditList();
        diffList.addAll((Collection)new HistogramDiff().diff((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)rt1, (Sequence)rt2));
        new DiffFormatter((OutputStream)out).format(diffList, rt1, rt2);
        return out.toString();
    }

    @Override
    protected String submit() throws CommandException {
        this.LOG.info("STARTED Coordinator update");
        this.submitJob();
        this.LOG.info("ENDED Coordinator update");
        if (this.showDiff) {
            return this.diff.toString();
        }
        return "";
    }

    public void check(CoordinatorJobBean oldCoord, CoordinatorJobBean newCoord) throws CommandException {
        if (!oldCoord.getFrequency().equals(newCoord.getFrequency())) {
            throw new CommandException(ErrorCode.E1023, "Frequency can't be changed. Old frequency = " + oldCoord.getFrequency() + " new frequency = " + newCoord.getFrequency());
        }
        if (!oldCoord.getEndTime().equals(newCoord.getEndTime())) {
            throw new CommandException(ErrorCode.E1023, "End time can't be changed. Old end time = " + oldCoord.getEndTime() + " new end time = " + newCoord.getEndTime());
        }
        if (!oldCoord.getStartTime().equals(newCoord.getStartTime())) {
            throw new CommandException(ErrorCode.E1023, "Start time can't be changed. Old start time = " + oldCoord.getStartTime() + " new start time = " + newCoord.getStartTime());
        }
        if (!oldCoord.getAppName().equals(newCoord.getAppName())) {
            throw new CommandException(ErrorCode.E1023, "Coord name can't be changed. Old name = " + oldCoord.getAppName() + " new name = " + newCoord.getAppName());
        }
        if (!oldCoord.getTimeUnitStr().equals(newCoord.getTimeUnitStr())) {
            throw new CommandException(ErrorCode.E1023, "Timeunit can't be changed. Old Timeunit = " + oldCoord.getTimeUnitStr() + " new Timeunit = " + newCoord.getTimeUnitStr());
        }
        if (!oldCoord.getTimeZone().equals(newCoord.getTimeZone())) {
            throw new CommandException(ErrorCode.E1023, "TimeZone can't be changed. Old timeZone = " + oldCoord.getTimeZone() + " new timeZone = " + newCoord.getTimeZone());
        }
    }

    @Override
    protected void queueMaterializeTransitionXCommand(String jobId) {
    }

    @Override
    public void notifyParent() throws CommandException {
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    public void transitToNext() {
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.jobId;
    }

    @Override
    public String getDryRun(CoordinatorJobBean job) throws Exception {
        return super.getDryRun(this.oldCoordJob);
    }
}

