/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.command.wf.ActionStartXCommand;
import org.apache.oozie.command.wf.KillXCommand;
import org.apache.oozie.command.wf.NotificationXCommand;
import org.apache.oozie.command.wf.SuspendXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public abstract class ActionXCommand<T>
extends WorkflowXCommand<Void> {
    private static final String INSTRUMENTATION_GROUP = "action.executors";
    protected static final String RECOVERY_ID_SEPARATOR = "@";

    public ActionXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    protected boolean handleTransient(ActionExecutor.Context context, ActionExecutor executor, WorkflowAction.Status status) throws CommandException {
        this.LOG.debug("Attempting to retry");
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        this.incrActionErrorCounter(action.getType(), "transient", 1);
        int actionRetryCount = action.getRetries();
        if (actionRetryCount >= executor.getMaxRetries()) {
            this.LOG.warn("Exceeded max retry count [{0}]. Suspending Job", executor.getMaxRetries());
            return false;
        }
        action.setStatus(status);
        action.setPending();
        action.incRetries();
        long retryDelayMillis = executor.getRetryInterval() * 1000L;
        action.setPendingAge(new Date(System.currentTimeMillis() + retryDelayMillis));
        this.LOG.info("Next Retry, Attempt Number [{0}] in [{1}] milliseconds", actionRetryCount + 1, retryDelayMillis);
        this.resetUsed();
        this.queue(this, retryDelayMillis);
        return true;
    }

    protected void handleNonTransient(ActionExecutor.Context context, ActionExecutor executor, WorkflowAction.Status status) throws CommandException {
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        this.incrActionErrorCounter(action.getType(), "nontransient", 1);
        WorkflowJobBean workflow = (WorkflowJobBean)context.getWorkflow();
        String id = workflow.getId();
        action.setStatus(status);
        action.resetPendingOnly();
        this.LOG.warn("Suspending Workflow Job id=" + id);
        try {
            SuspendXCommand.suspendJob(Services.get().get(JPAService.class), workflow, id, action.getId(), null);
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E0727, id, e.getMessage());
        }
        finally {
            this.updateParentIfNecessary(workflow, 3);
        }
    }

    protected void handleError(ActionExecutor.Context context, ActionExecutor executor, String message, boolean isStart, WorkflowAction.Status status) throws CommandException {
        this.LOG.warn("Setting Action Status to [{0}]", status);
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        if (!this.handleUserRetry(action)) {
            this.incrActionErrorCounter(action.getType(), "error", 1);
            action.setPending();
            if (isStart) {
                action.setExecutionData(message, null);
                this.queue(new ActionEndXCommand(action.getId(), action.getType()));
            } else {
                action.setEndData(status, WorkflowAction.Status.ERROR.toString());
            }
        }
    }

    public void failJob(ActionExecutor.Context context) throws CommandException {
        ActionExecutorContext aContext = (ActionExecutorContext)context;
        WorkflowActionBean action = (WorkflowActionBean)aContext.getAction();
        this.failJob(context, action);
    }

    public void failJob(ActionExecutor.Context context, WorkflowActionBean action) throws CommandException {
        WorkflowJobBean workflow = (WorkflowJobBean)context.getWorkflow();
        if (!this.handleUserRetry(action)) {
            this.incrActionErrorCounter(action.getType(), "failed", 1);
            this.LOG.warn("Failing Job due to failed action [{0}]", action.getName());
            try {
                workflow.getWorkflowInstance().fail(action.getName());
                WorkflowInstance wfInstance = workflow.getWorkflowInstance();
                ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.FAILED);
                workflow.setWorkflowInstance(wfInstance);
                workflow.setStatus(WorkflowJob.Status.FAILED);
                action.setStatus(WorkflowAction.Status.FAILED);
                action.resetPending();
                this.queue(new NotificationXCommand(workflow, action));
                this.queue(new KillXCommand(workflow.getId()));
                InstrumentUtils.incrJobCounter("failed", 1, this.getInstrumentation());
            }
            catch (WorkflowException ex) {
                throw new CommandException(ex);
            }
        }
    }

    public boolean handleUserRetry(WorkflowActionBean action) throws CommandException {
        String errorCode = action.getErrorCode();
        Set<String> allowedRetryCode = LiteWorkflowStoreService.getUserRetryErrorCode();
        if ((allowedRetryCode.contains("ALL") || allowedRetryCode.contains(errorCode)) && action.getUserRetryCount() < action.getUserRetryMax()) {
            this.LOG.info("Preparing retry this action [{0}], errorCode [{1}], userRetryCount [{2}], userRetryMax [{3}], userRetryInterval [{4}]", action.getId(), errorCode, action.getUserRetryCount(), action.getUserRetryMax(), action.getUserRetryInterval());
            int interval = action.getUserRetryInterval() * 60 * 1000;
            action.setStatus(WorkflowAction.Status.USER_RETRY);
            action.incrmentUserRetryCount();
            action.setPending();
            this.queue(new ActionStartXCommand(action.getId(), action.getType()), interval);
            return true;
        }
        return false;
    }

    private void incrActionErrorCounter(String type, String error, int count) {
        this.getInstrumentation().incr(INSTRUMENTATION_GROUP, type + "#ex." + error, count);
    }

    protected void incrActionCounter(String type, int count) {
        this.getInstrumentation().incr(INSTRUMENTATION_GROUP, type + "#" + this.getName(), count);
    }

    protected void addActionCron(String type, Instrumentation.Cron cron) {
        this.getInstrumentation().addCron(INSTRUMENTATION_GROUP, type + "#" + this.getName(), cron);
    }

    public static class ActionExecutorContext
    implements ActionExecutor.Context {
        private final WorkflowJobBean workflow;
        private Configuration protoConf;
        private final WorkflowActionBean action;
        private final boolean isRetry;
        private final boolean isUserRetry;
        private boolean started;
        private boolean ended;
        private boolean executed;

        public ActionExecutorContext(WorkflowJobBean workflow, WorkflowActionBean action, boolean isRetry, boolean isUserRetry) {
            this.workflow = workflow;
            this.action = action;
            this.isRetry = isRetry;
            this.isUserRetry = isUserRetry;
            try {
                this.protoConf = new XConfiguration(new StringReader(workflow.getProtoActionConf()));
            }
            catch (IOException ex) {
                throw new RuntimeException("It should not happen", ex);
            }
        }

        @Override
        public String getCallbackUrl(String externalStatusVar) {
            return Services.get().get(CallbackService.class).createCallBackUrl(this.action.getId(), externalStatusVar);
        }

        @Override
        public Configuration getProtoActionConf() {
            return this.protoConf;
        }

        @Override
        public WorkflowJob getWorkflow() {
            return this.workflow;
        }

        public WorkflowAction getAction() {
            return this.action;
        }

        @Override
        public ELEvaluator getELEvaluator() {
            ELEvaluator evaluator = Services.get().get(ELService.class).createEvaluator("workflow");
            DagELFunctions.configureEvaluator(evaluator, this.workflow, this.action);
            return evaluator;
        }

        @Override
        public void setVar(String name, String value) {
            name = this.action.getName() + "#" + name;
            WorkflowInstance wfInstance = this.workflow.getWorkflowInstance();
            wfInstance.setVar(name, value);
            this.workflow.setWorkflowInstance(wfInstance);
        }

        @Override
        public String getVar(String name) {
            name = this.action.getName() + "#" + name;
            return this.workflow.getWorkflowInstance().getVar(name);
        }

        @Override
        public void setStartData(String externalId, String trackerUri, String consoleUrl) {
            this.action.setStartData(externalId, trackerUri, consoleUrl);
            this.started = true;
        }

        public void setStartTime() {
            Date now = new Date();
            this.action.setStartTime(now);
        }

        @Override
        public void setExecutionData(String externalStatus, Properties actionData) {
            this.action.setExecutionData(externalStatus, actionData);
            this.executed = true;
        }

        @Override
        public void setExecutionStats(String jsonStats) {
            this.action.setExecutionStats(jsonStats);
            this.executed = true;
        }

        @Override
        public void setExternalChildIDs(String externalChildIDs) {
            this.action.setExternalChildIDs(externalChildIDs);
            this.executed = true;
        }

        @Override
        public void setEndData(WorkflowAction.Status status, String signalValue) {
            this.action.setEndData(status, signalValue);
            this.ended = true;
        }

        @Override
        public boolean isRetry() {
            return this.isRetry;
        }

        public boolean isUserRetry() {
            return this.isUserRetry;
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public boolean isEnded() {
            return this.ended;
        }

        @Override
        public void setExternalStatus(String externalStatus) {
            this.action.setExternalStatus(externalStatus);
        }

        @Override
        public String getRecoveryId() {
            return this.action.getId() + ActionXCommand.RECOVERY_ID_SEPARATOR + this.workflow.getRun();
        }

        @Override
        public Path getActionDir() throws HadoopAccessorException, IOException, URISyntaxException {
            String name = this.getWorkflow().getId() + "/" + this.action.getName() + "--" + this.action.getType();
            FileSystem fs = this.getAppFileSystem();
            String actionDirPath = Services.get().getSystemId() + "/" + name;
            Path fqActionDir = new Path(fs.getHomeDirectory(), actionDirPath);
            return fqActionDir;
        }

        @Override
        public FileSystem getAppFileSystem() throws HadoopAccessorException, IOException, URISyntaxException {
            WorkflowJob workflow = this.getWorkflow();
            URI uri = new URI(this.getWorkflow().getAppPath());
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            return has.createFileSystem(workflow.getUser(), uri, (Configuration)fsConf);
        }

        @Override
        public void setErrorInfo(String str, String exMsg) {
            this.action.setErrorInfo(str, exMsg);
        }
    }
}

