/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.AppType;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class SubmitXCommand
extends WorkflowXCommand<String> {
    public static final String CONFIG_DEFAULT = "config-default.xml";
    private Configuration conf;
    private List<JsonBean> insertList = new ArrayList<JsonBean>();
    private String parentId;
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();
    private static final Set<String> DISALLOWED_USER_PROPERTIES = new HashSet<String>();

    public SubmitXCommand(Configuration conf) {
        super("submit", "submit", 1);
        this.conf = ParamChecker.notNull(conf, "conf");
    }

    public SubmitXCommand(Configuration conf, String parentId) {
        this(conf);
        this.parentId = parentId;
    }

    public SubmitXCommand(boolean dryrun, Configuration conf) {
        this(conf);
        this.dryrun = dryrun;
    }

    @Override
    protected String execute() throws CommandException {
        InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
        WorkflowAppService wps = Services.get().get(WorkflowAppService.class);
        try {
            WorkflowInstance wfInstance;
            XLog.Info.get().setParameter("TOKEN", this.conf.get("oozie.wf.log.token"));
            String user = this.conf.get("user.name");
            URI uri = new URI(this.conf.get("oozie.wf.application.path"));
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = has.createFileSystem(user, uri, (Configuration)fsConf);
            Path configDefault = null;
            XConfiguration defaultConf = null;
            Path path = new Path(uri.getPath());
            configDefault = !fs.isFile(path) ? new Path(path, CONFIG_DEFAULT) : new Path(path.getParent(), CONFIG_DEFAULT);
            if (fs.exists(configDefault)) {
                try {
                    defaultConf = new XConfiguration((InputStream)fs.open(configDefault));
                    PropertiesUtils.checkDisallowedProperties(defaultConf, DISALLOWED_DEFAULT_PROPERTIES);
                    XConfiguration.injectDefaults(defaultConf, this.conf);
                }
                catch (IOException ex) {
                    throw new IOException("default configuration file, " + ex.getMessage(), ex);
                }
            }
            WorkflowApp app = wps.parseDef(this.conf, defaultConf);
            XConfiguration protoActionConf = wps.createProtoActionConf(this.conf, true);
            WorkflowLib workflowLib = Services.get().get(WorkflowStoreService.class).getWorkflowLibWithNoDB();
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
            XConfiguration resolvedVarsConf = new XConfiguration();
            for (Map.Entry entry : this.conf) {
                resolvedVarsConf.set((String)entry.getKey(), this.conf.get((String)entry.getKey()));
            }
            this.conf = resolvedVarsConf;
            try {
                wfInstance = workflowLib.createInstance(app, this.conf);
            }
            catch (WorkflowException e) {
                throw new StoreException(e);
            }
            Configuration conf = wfInstance.getConf();
            WorkflowJobBean workflow = new WorkflowJobBean();
            workflow.setId(wfInstance.getId());
            workflow.setAppName(ELUtils.resolveAppName(app.getName(), conf));
            workflow.setAppPath(conf.get("oozie.wf.application.path"));
            workflow.setConf(XmlUtils.prettyPrint(conf).toString());
            workflow.setProtoActionConf(protoActionConf.toXmlString());
            workflow.setCreatedTime(new Date());
            workflow.setLastModifiedTime(new Date());
            workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
            workflow.setStatus(WorkflowJob.Status.PREP);
            workflow.setRun(0);
            workflow.setUser(conf.get("user.name"));
            workflow.setGroup(conf.get("group.name"));
            workflow.setWorkflowInstance(wfInstance);
            workflow.setExternalId(conf.get("oozie.wf.external.id"));
            if (workflow.getParentId() == null) {
                workflow.setParentId(conf.get("oozie.wf.parent.id"));
            }
            if (workflow.getParentId() == null) {
                workflow.setParentId(this.parentId);
            }
            LogUtils.setLogInfo(workflow, this.logInfo);
            this.LOG = XLog.resetPrefix(this.LOG);
            this.LOG.debug("Workflow record created, Status [{0}]", workflow.getStatus());
            Element wfElem = XmlUtils.parseXml(app.getDefinition());
            ELEvaluator evalSla = SubmitXCommand.createELEvaluatorForGroup(conf, "wf-sla-submit");
            String jobSlaXml = this.verifySlaElements(wfElem, evalSla);
            if (!this.dryrun) {
                this.writeSLARegistration(wfElem, jobSlaXml, workflow.getId(), workflow.getParentId(), workflow.getUser(), workflow.getGroup(), workflow.getAppName(), this.LOG, evalSla);
                workflow.setSlaXml(jobSlaXml);
                this.insertList.add(workflow);
                JPAService jpaService = Services.get().get(JPAService.class);
                if (jpaService != null) {
                    try {
                        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, null, null);
                    }
                    catch (JPAExecutorException je) {
                        throw new CommandException(je);
                    }
                } else {
                    this.LOG.error((Object)ErrorCode.E0610);
                    return null;
                }
                return workflow.getId();
            }
            ActionXCommand.ActionExecutorContext context = new ActionXCommand.ActionExecutorContext(workflow, null, false, false);
            Element workflowXml = XmlUtils.parseXml(app.getDefinition());
            this.removeSlaElements(workflowXml);
            String workflowXmlString = XmlUtils.removeComments(XmlUtils.prettyPrint(workflowXml).toString());
            workflowXmlString = context.getELEvaluator().evaluate(workflowXmlString, String.class);
            workflowXml = XmlUtils.parseXml(workflowXmlString);
            Iterator it = workflowXml.getDescendants((Filter)new ElementFilter("job-xml"));
            while (it.hasNext()) {
                Element e = (Element)it.next();
                String jobXml = e.getTextTrim();
                Path xmlPath = new Path(workflow.getAppPath(), jobXml);
                XConfiguration jobXmlConf = new XConfiguration((InputStream)fs.open(xmlPath));
                String jobXmlConfString = XmlUtils.prettyPrint(jobXmlConf).toString();
                jobXmlConfString = XmlUtils.removeComments(jobXmlConfString);
                context.getELEvaluator().evaluate(jobXmlConfString, String.class);
            }
            return "OK";
        }
        catch (WorkflowException ex) {
            throw new CommandException(ex);
        }
        catch (HadoopAccessorException ex) {
            throw new CommandException(ex);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0803, ex.getMessage(), ex);
        }
    }

    private void removeSlaElements(Element eWfJob) {
        Element sla = XmlUtils.getSLAElement(eWfJob);
        if (sla != null) {
            eWfJob.removeChildren(sla.getName(), sla.getNamespace());
        }
        for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
            sla = XmlUtils.getSLAElement(action);
            if (sla == null) continue;
            action.removeChildren(sla.getName(), sla.getNamespace());
        }
    }

    private String verifySlaElements(Element eWfJob, ELEvaluator evalSla) throws CommandException {
        String jobSlaXml = "";
        Element eSla = XmlUtils.getSLAElement(eWfJob);
        if (eSla != null) {
            jobSlaXml = SubmitXCommand.resolveSla(eSla, evalSla);
        }
        for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
            eSla = XmlUtils.getSLAElement(action);
            if (eSla == null) continue;
            SubmitXCommand.resolveSla(eSla, evalSla);
        }
        return jobSlaXml;
    }

    private void writeSLARegistration(Element eWfJob, String slaXml, String jobId, String parentId, String user, String group, String appName, XLog log, ELEvaluator evalSla) throws CommandException {
        try {
            if (slaXml != null && slaXml.length() > 0) {
                Element eSla = XmlUtils.parseXml(slaXml);
                SLAEventBean slaEvent = SLADbOperations.createSlaRegistrationEvent(eSla, jobId, SLAEvent.SlaAppType.WORKFLOW_JOB, user, group, log);
                if (slaEvent != null) {
                    this.insertList.add(slaEvent);
                }
                SLAOperations.createSlaRegistrationEvent(eSla, jobId, parentId, AppType.WORKFLOW_JOB, user, appName, log, false);
            }
            for (Element action : eWfJob.getChildren("action", eWfJob.getNamespace())) {
                Element actionSla = XmlUtils.getSLAElement(action);
                if (actionSla == null) continue;
                String actionSlaXml = SubmitXCommand.resolveSla(actionSla, evalSla);
                actionSla = XmlUtils.parseXml(actionSlaXml);
                String actionId = Services.get().get(UUIDService.class).generateChildId(jobId, action.getAttributeValue("name") + "");
                SLAOperations.createSlaRegistrationEvent(actionSla, actionId, jobId, AppType.WORKFLOW_ACTION, user, appName, log, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException(ErrorCode.E1007, "workflow " + jobId, e.getMessage(), e);
        }
    }

    public static String resolveSla(Element eSla, ELEvaluator evalSla) throws CommandException {
        String slaXml = XmlUtils.prettyPrint(eSla).toString();
        try {
            slaXml = XmlUtils.removeComments(slaXml);
            slaXml = evalSla.evaluate(slaXml, String.class);
            XmlUtils.validateData(slaXml, SchemaService.SchemaName.SLA_ORIGINAL);
            return slaXml;
        }
        catch (Exception e) {
            throw new CommandException(ErrorCode.E1004, "Validation error :" + e.getMessage(), e);
        }
    }

    public static ELEvaluator createELEvaluatorForGroup(Configuration conf, String group) {
        ELEvaluator eval = Services.get().get(ELService.class).createEvaluator(group);
        for (Map.Entry entry : conf) {
            eval.setVariable((String)entry.getKey(), entry.getValue());
        }
        return eval;
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() {
    }

    @Override
    protected void verifyPrecondition() throws CommandException {
    }

    static {
        String[] badUserProps = new String[]{"DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

