/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.framework.recipes.locks.ChildReaper;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.curator.utils.ThreadUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.ZKUtils;

public class ZKLocksService
extends MemoryLocksService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private static XLog LOG = XLog.getLog(ZKLocksService.class);
    public static final String LOCKS_NODE = "/locks";
    private final AtomicLong lockCount = new AtomicLong();
    private static final String REAPING_LEADER_PATH = "/services/locksChildReaperLeaderPath";
    public static final int DEFAULT_REAPING_THRESHOLD = 300;
    public static final String REAPING_THRESHOLD = "oozie.service.ZKLocksService.locks.reaper.threshold";
    public static final String REAPING_THREADS = "oozie.service.ZKLocksService.locks.reaper.threads";
    private ChildReaper reaper = null;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
            this.reaper = new ChildReaper(this.zk.getClient(), LOCKS_NODE, Reaper.Mode.REAP_INDEFINITELY, ZKLocksService.getExecutorService(), services.getConf().getInt(REAPING_THRESHOLD, 300) * 1000, REAPING_LEADER_PATH);
            this.reaper.start();
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
        this.lockCount.set(0L);
    }

    @Override
    public void destroy() {
        if (this.reaper != null) {
            try {
                this.reaper.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing childReaper", e);
            }
        }
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("locks", "locks", new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return ZKLocksService.this.lockCount.get();
            }
        });
    }

    @Override
    public LockToken getReadLock(String resource, long wait) throws InterruptedException {
        InterProcessReadWriteLock lock = new InterProcessReadWriteLock(this.zk.getClient(), "/locks/" + resource);
        InterProcessMutex readLock = lock.readLock();
        return this.acquireLock(wait, readLock);
    }

    @Override
    public LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        InterProcessReadWriteLock lock = new InterProcessReadWriteLock(this.zk.getClient(), "/locks/" + resource);
        InterProcessMutex writeLock = lock.writeLock();
        return this.acquireLock(wait, writeLock);
    }

    private LockToken acquireLock(long wait, InterProcessMutex lock) {
        ZKLockToken token = null;
        try {
            if (wait == -1L) {
                lock.acquire();
                token = new ZKLockToken(lock);
            } else if (lock.acquire(wait, TimeUnit.MILLISECONDS)) {
                token = new ZKLockToken(lock);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return token;
    }

    private static ScheduledExecutorService getExecutorService() {
        return ThreadUtils.newFixedThreadScheduledPool((int)Services.get().getConf().getInt(REAPING_THREADS, 2), (String)"ZKLocksChildReaper");
    }

    class ZKLockToken
    implements LockToken {
        private final InterProcessMutex lock;

        private ZKLockToken(InterProcessMutex lock) {
            this.lock = lock;
            ZKLocksService.this.lockCount.incrementAndGet();
        }

        @Override
        public void release() {
            try {
                this.lock.release();
                ZKLocksService.this.lockCount.decrementAndGet();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not release lock: " + ex.getMessage()), ex);
            }
        }
    }
}

