/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ZKUtils;

public class AuthFilter
extends AuthenticationFilter {
    private static final String OOZIE_PREFIX = "oozie.authentication.";
    private HttpServlet optionsServlet;
    private ZKUtils zkUtils = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (Services.get().get(JobsConcurrencyService.class).isHighlyAvailableMode()) {
            try {
                this.zkUtils = ZKUtils.register((Object)this);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            filterConfig.getServletContext().setAttribute("signer.secret.provider.zookeeper.curator.client", (Object)this.zkUtils.getClient());
        }
        super.init(filterConfig);
        this.optionsServlet = new HttpServlet(){};
        this.optionsServlet.init();
    }

    public void destroy() {
        this.optionsServlet.destroy();
        if (this.zkUtils != null) {
            this.zkUtils.unregister((Object)this);
        }
        super.destroy();
    }

    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) {
        Properties props = new Properties();
        Configuration conf = Services.get().getConf();
        props.setProperty("cookie.path", "/");
        for (Map.Entry entry : conf) {
            String name = (String)entry.getKey();
            if (!name.startsWith(OOZIE_PREFIX)) continue;
            String value = conf.get(name);
            name = name.substring(OOZIE_PREFIX.length());
            props.setProperty(name, value);
        }
        if (Services.get().get(JobsConcurrencyService.class).isHighlyAvailableMode()) {
            if (!props.containsKey("signer.secret.provider")) {
                props.setProperty("signer.secret.provider", "zookeeper");
            }
            if (!props.containsKey("signer.secret.provider.zookeeper.path")) {
                props.setProperty("signer.secret.provider.zookeeper.path", "/services/signersecrets");
            }
            props.setProperty("signer.secret.provider.zookeeper.disconnect.on.shutdown", "false");
        }
        return props;
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain filterChain) throws IOException, ServletException {
        FilterChain filterChainWrapper = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
                if (httpRequest.getMethod().equals("OPTIONS")) {
                    AuthFilter.this.optionsServlet.service(request, response);
                } else {
                    httpRequest.setAttribute("oozie.user.name", (Object)httpRequest.getRemoteUser());
                    filterChain.doFilter(servletRequest, servletResponse);
                }
            }
        };
        super.doFilter(request, response, filterChainWrapper);
    }
}

