/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ContentNotRecognizedException;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.ParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.ResourceManagerBackend;
import org.pentaho.reporting.libraries.resourceloader.UnrecognizedLoaderException;

public class DefaultResourceManagerBackend
implements ResourceManagerBackend {
    private static final Log logger = LogFactory.getLog(DefaultResourceManagerBackend.class);
    private ArrayList<ResourceLoader> resourceLoaders = new ArrayList();
    private ArrayList<ResourceBundleLoader> resourceBundleLoaders = new ArrayList();
    private ArrayList<ResourceFactory> resourceFactories = new ArrayList();
    private boolean registeredFactories;
    private boolean registeredLoaders;

    public synchronized ResourceKey createKey(Object data, Map<? extends ParameterKey, ?> parameters) throws ResourceKeyCreationException {
        if (data == null) {
            throw new NullPointerException("Key data must not be null.");
        }
        for (ResourceLoader loader : this.resourceLoaders) {
            try {
                ResourceKey key = loader.createKey(data, parameters);
                if (key == null) continue;
                return key;
            }
            catch (ResourceKeyCreationException rkce) {
            }
        }
        throw new ResourceKeyCreationException("Unable to create key: No loader was able to handle the given key data: " + data);
    }

    public synchronized ResourceKey deriveKey(ResourceKey parent, String path, Map<? extends ParameterKey, ?> parameters) throws ResourceKeyCreationException {
        ResourceKey secondParent;
        ResourceLoader loader;
        ResourceKey key;
        int i;
        if (parent == null) {
            if (path == null) {
                throw new NullPointerException();
            }
            return this.createKey((Object)path, parameters);
        }
        ResourceKeyCreationException rce = null;
        for (i = 0; i < this.resourceBundleLoaders.size(); ++i) {
            ResourceBundleLoader bundleLoader = this.resourceBundleLoaders.get(i);
            if (!bundleLoader.isSupportedKey(parent)) continue;
            try {
                key = bundleLoader.deriveKey(parent, path, parameters);
                if (key == null) continue;
                return key;
            }
            catch (ResourceKeyCreationException rcke) {
                rce = rcke;
            }
        }
        for (i = 0; i < this.resourceLoaders.size(); ++i) {
            loader = this.resourceLoaders.get(i);
            if (!loader.isSupportedKey(parent)) continue;
            try {
                key = loader.deriveKey(parent, path, parameters);
                if (key == null) continue;
                return key;
            }
            catch (ResourceKeyCreationException rcke) {
                rce = rcke;
            }
        }
        if (path != null) {
            for (i = 0; i < this.resourceLoaders.size(); ++i) {
                loader = this.resourceLoaders.get(i);
                key = loader.createKey(path, parameters);
                if (key == null) continue;
                return key;
            }
        }
        if ((secondParent = parent.getParent()) != null) {
            for (int i2 = 0; i2 < this.resourceLoaders.size(); ++i2) {
                ResourceLoader loader2 = this.resourceLoaders.get(i2);
                if (!loader2.isSupportedKey(secondParent)) continue;
                try {
                    ResourceKey key2 = loader2.deriveKey(secondParent, path, parameters);
                    if (key2 != null) {
                        return key2;
                    }
                    continue;
                }
                catch (ResourceKeyCreationException rcke) {
                    rce = rcke;
                }
            }
        }
        if (rce != null) {
            throw rce;
        }
        throw new ResourceKeyCreationException("Unable to create key: No such schema or the key was not recognized.");
    }

    private ResourceLoader findBySchema(ResourceKey key) {
        for (int i = 0; i < this.resourceLoaders.size(); ++i) {
            ResourceLoader loader = this.resourceLoaders.get(i);
            if (!loader.isSupportedKey(key)) continue;
            return loader;
        }
        return null;
    }

    @Override
    public synchronized URL toURL(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        ResourceLoader loader = this.findBySchema(key);
        if (loader == null) {
            return null;
        }
        return loader.toURL(key);
    }

    @Override
    public synchronized Resource create(ResourceManager frontEnd, ResourceData data, ResourceKey context, Class[] target) throws ResourceLoadingException, ResourceCreationException {
        if (frontEnd == null) {
            throw new NullPointerException();
        }
        if (data == null) {
            throw new NullPointerException("Data must not be null.");
        }
        if (target == null) {
            return this.autoCreateResource(frontEnd, data, context);
        }
        ResourceCreationException exception = null;
        int factoryCount = this.resourceFactories.size();
        ResourceFactory[] factories = this.resourceFactories.toArray(new ResourceFactory[factoryCount]);
        for (int targetIdx = 0; targetIdx < target.length; ++targetIdx) {
            Class targetClass = target[targetIdx];
            for (int i = 0; i < factoryCount; ++i) {
                ResourceFactory fact = factories[i];
                if (!this.isSupportedTarget(targetClass, fact)) continue;
                try {
                    return fact.create(frontEnd, data, context);
                }
                catch (ContentNotRecognizedException ce) {
                    continue;
                }
                catch (ResourceCreationException rex) {
                    exception = rex;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Failed at " + fact.getClass() + ": "), (Throwable)rex);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        throw new ContentNotRecognizedException("None of the selected factories was able to handle the given data: " + data.getKey());
    }

    private boolean isSupportedTarget(Class target, ResourceFactory fact) {
        Class factoryType = fact.getFactoryType();
        return target != null && factoryType != null && factoryType.equals(target);
    }

    private Resource autoCreateResource(ResourceManager frontEnd, ResourceData data, ResourceKey context) throws ResourceLoadingException, ResourceCreationException {
        for (ResourceFactory fact : this.resourceFactories) {
            try {
                Resource res = fact.create(frontEnd, data, context);
                if (res == null) continue;
                return res;
            }
            catch (ResourceCreationException rex) {
            }
        }
        throw new ResourceCreationException("No known factory was able to handle the given data.");
    }

    @Override
    public boolean isResourceUnchanged(ResourceManager frontEnd, Resource resource) throws ResourceLoadingException {
        if (frontEnd == null) {
            throw new NullPointerException();
        }
        if (resource == null) {
            throw new NullPointerException();
        }
        ResourceKey[] deps = resource.getDependencies();
        for (int i = 0; i < deps.length; ++i) {
            ResourceData data;
            ResourceKey dep = deps[i];
            long version = resource.getVersion(dep);
            if (version == -1L || (data = frontEnd.load(dep)).getVersion(frontEnd) == version) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized ResourceBundleData loadResourceBundle(ResourceManager frontEnd, ResourceKey key) throws ResourceLoadingException {
        if (frontEnd == null) {
            throw new NullPointerException();
        }
        if (key == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.resourceBundleLoaders.size(); ++i) {
            ResourceBundleLoader loader = this.resourceBundleLoaders.get(i);
            ResourceBundleData resourceBundle = loader.loadBundle(frontEnd, key);
            if (resourceBundle == null) continue;
            return resourceBundle;
        }
        return null;
    }

    @Override
    public ResourceData loadRawData(ResourceManager frontEnd, ResourceKey key) throws UnrecognizedLoaderException, ResourceLoadingException {
        if (frontEnd == null) {
            throw new NullPointerException();
        }
        if (key == null) {
            throw new NullPointerException();
        }
        ResourceLoader loader = this.findBySchema(key);
        if (loader == null) {
            throw new UnrecognizedLoaderException("Invalid key: No resource-loader registered for schema: " + key.getSchema());
        }
        logger.debug((Object)("Loaded " + key));
        return loader.load(key);
    }

    @Override
    public void registerDefaultFactories() {
        if (this.registeredFactories) {
            return;
        }
        this.registeredFactories = true;
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator itType = config.findPropertyKeys("org.pentaho.reporting.libraries.resourceloader.factory.type.");
        while (itType.hasNext()) {
            String key = (String)itType.next();
            String factoryClass = config.getConfigProperty(key);
            ResourceFactory factory = (ResourceFactory)ObjectUtilities.loadAndInstantiate((String)factoryClass, ResourceManager.class, ResourceFactory.class);
            if (factory == null) continue;
            factory.initializeDefaults();
            this.registerFactory(factory);
        }
    }

    @Override
    public void registerDefaultLoaders() {
        if (this.registeredLoaders) {
            return;
        }
        this.registeredLoaders = true;
        Configuration config = LibLoaderBoot.getInstance().getGlobalConfig();
        Iterator it = config.findPropertyKeys("org.pentaho.reporting.libraries.resourceloader.loader.");
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = config.getConfigProperty(key);
            ResourceLoader loader = (ResourceLoader)ObjectUtilities.loadAndInstantiate((String)value, ResourceManager.class, ResourceLoader.class);
            if (loader == null) continue;
            this.registerLoader(loader);
        }
        Iterator bit = config.findPropertyKeys("org.pentaho.reporting.libraries.resourceloader.bundle.loader.");
        while (bit.hasNext()) {
            String key = (String)bit.next();
            String value = config.getConfigProperty(key);
            ResourceBundleLoader loader = (ResourceBundleLoader)ObjectUtilities.loadAndInstantiate((String)value, ResourceManager.class, ResourceBundleLoader.class);
            if (loader == null) continue;
            this.registerBundleLoader(loader);
        }
    }

    @Override
    public void registerBundleLoader(ResourceBundleLoader loader) {
        if (loader == null) {
            throw new NullPointerException("ResourceLoader must not be null.");
        }
        this.resourceBundleLoaders.add(loader);
    }

    @Override
    public void registerLoader(ResourceLoader loader) {
        if (loader == null) {
            throw new NullPointerException("ResourceLoader must not be null.");
        }
        this.resourceLoaders.add(loader);
    }

    @Override
    public void registerFactory(ResourceFactory factory) {
        if (factory == null) {
            throw new NullPointerException("ResourceFactory must not be null.");
        }
        this.resourceFactories.add(factory);
    }

    @Override
    public ResourceKey deserialize(ResourceKey bundleKey, String serializedKey) throws ResourceKeyCreationException {
        if (serializedKey == null) {
            throw new NullPointerException("Key data must not be null.");
        }
        for (ResourceLoader loader : this.resourceLoaders) {
            if (!loader.isSupportedDeserializer(serializedKey)) continue;
            ResourceKey key = loader.deserialize(bundleKey, serializedKey);
            return key;
        }
        throw new ResourceKeyCreationException("Unable to create key: No loader was able to handle the deserialization of the given key data: " + serializedKey);
    }

    @Override
    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new NullPointerException("Key data must not be null.");
        }
        for (ResourceLoader loader : this.resourceLoaders) {
            if (!loader.isSupportedKey(key)) continue;
            return loader.serialize(bundleKey, key);
        }
        throw new ResourceException("Unable to find resource loader for specified key: " + key);
    }
}

