/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ParameterKey;

public final class ResourceKey
implements Serializable {
    private static final Map<ParameterKey, Object> EMPTY_MAP = Collections.emptyMap();
    private static final long serialVersionUID = -7764107570068726772L;
    private Map<? extends ParameterKey, Object> factoryParameters;
    private Integer hashCode;
    private Object schema;
    private Object identifier;
    private ResourceKey parent;

    public ResourceKey(Object schema, Object identifier, Map<? extends ParameterKey, Object> factoryParameters) {
        if (schema == null) {
            throw new NullPointerException();
        }
        if (identifier == null) {
            throw new NullPointerException();
        }
        this.schema = schema;
        this.identifier = identifier;
        this.factoryParameters = factoryParameters != null ? Collections.unmodifiableMap(new HashMap<ParameterKey, Object>(factoryParameters)) : EMPTY_MAP;
    }

    public ResourceKey(ResourceKey parent, Object schema, Object identifier, Map<? extends ParameterKey, Object> factoryParameters) {
        this(schema, identifier, factoryParameters);
        this.parent = parent;
    }

    public static ResourceKey createAsDerived(ResourceKey parent, ResourceKey child) {
        if (child.parent != null) {
            throw new IllegalArgumentException();
        }
        return new ResourceKey(parent, child.schema, child.identifier, child.factoryParameters);
    }

    public ResourceKey getParent() {
        return this.parent;
    }

    public Map<ParameterKey, Object> getFactoryParameters() {
        return Collections.unmodifiableMap(this.factoryParameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceKey that = (ResourceKey)o;
        if (that.hashCode != null && this.hashCode != null && !that.hashCode.equals(this.hashCode)) {
            return false;
        }
        if (this.parent != that.parent && !ObjectUtilities.equal((Object)this.parent, (Object)that.parent)) {
            return false;
        }
        if (!this.schema.equals(that.schema)) {
            return false;
        }
        if (!this.factoryParameters.equals(that.factoryParameters)) {
            return false;
        }
        if (this.identifier instanceof URL) {
            if (!String.valueOf(this.identifier).equals(String.valueOf(that.identifier))) {
                return false;
            }
        } else if (this.identifier instanceof File && that.identifier instanceof File) {
            if (!ObjectUtilities.equals((File)((File)this.identifier), (File)((File)that.identifier))) {
                return false;
            }
        } else if (!this.identifier.equals(that.identifier)) {
            if (this.identifier instanceof byte[] && that.identifier instanceof byte[]) {
                byte[] me = (byte[])this.identifier;
                byte[] he = (byte[])that.identifier;
                if (!Arrays.equals(me, he)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int result = this.factoryParameters.hashCode();
            result = 29 * result + this.schema.hashCode();
            if (this.identifier instanceof URL) {
                URL url = (URL)this.identifier;
                result = 29 * result + url.toString().hashCode();
            } else {
                result = this.identifier instanceof byte[] ? 29 * result + Arrays.hashCode((byte[])this.identifier) : 29 * result + this.identifier.hashCode();
            }
            if (this.parent != null) {
                result = 29 * result + this.parent.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public String getIdentifierAsString() {
        if (this.identifier instanceof File) {
            File file = (File)this.identifier;
            return file.getPath();
        }
        if (this.identifier instanceof URL) {
            URL url = (URL)this.identifier;
            return url.toExternalForm();
        }
        if (this.identifier instanceof String) {
            return this.identifier.toString();
        }
        return null;
    }

    public Object getSchema() {
        return this.schema;
    }

    public String toString() {
        return "ResourceKey{schema=" + this.schema + ", identifier=" + this.identifier + ", factoryParameters=" + this.factoryParameters + ", parent=" + this.parent + '}';
    }
}

