/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.modules.factory.svg;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.AbstractSVGFactoryModule;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.HeadlessSVGUserAgent;
import org.pentaho.reporting.libraries.resourceloader.modules.factory.svg.SVGDrawable;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class SVGImageFactoryModule
extends AbstractSVGFactoryModule {
    @Override
    public Resource create(ResourceManager caller, ResourceData data, ResourceKey context) throws ResourceLoadingException {
        try {
            long version = data.getVersion(caller);
            HeadlessSVGUserAgent userAgent = new HeadlessSVGUserAgent();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            ResourceKey key = data.getKey();
            URL url = caller.toURL(key);
            if (url == null) {
                url = new File(".").toURI().toURL();
            }
            SVGDocument document = (SVGDocument)loader.loadDocument(url.toURI().toASCIIString(), data.getResourceAsStream(caller));
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent, loader);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode node = builder.build(ctx, (Document)document);
            Rectangle2D bounds = node.getBounds();
            SVGDrawable drawable = new SVGDrawable(node);
            BufferedImage bi = new BufferedImage((int)bounds.getWidth(), (int)bounds.getHeight(), 2);
            Graphics2D graphics = (Graphics2D)bi.getGraphics();
            drawable.draw(graphics, new Rectangle2D.Double(0.0, 0.0, bounds.getWidth(), bounds.getHeight()));
            graphics.dispose();
            return new SimpleResource(data.getKey(), bi, Image.class, version);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Failed to process SVG file", e);
        }
        catch (URISyntaxException e) {
            throw new ResourceLoadingException("Failed to process SVG file", e);
        }
    }
}

