/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.mapr401;

import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.fs.Path;
import org.pentaho.hadoop.shim.common.ShimUtils;

public class ConfigurationProxyV2
implements Configuration {
    private Job job;

    public ConfigurationProxyV2() throws IOException {
        JobConf jobConf = new JobConf(new org.apache.hadoop.conf.Configuration());
        this.job = new JobProxy(jobConf);
        this.job.getConfiguration().addResource("hdfs-site.xml");
    }

    public JobConf getJobConf() {
        return (JobConf)this.getJob().getConfiguration();
    }

    public Job getJob() {
        ((JobProxy)this.job).refreshUGI();
        return this.job;
    }

    public void setJobName(String jobName) {
        this.getJob().setJobName(jobName);
    }

    public void set(String name, String value) {
        this.getJobConf().set(name, value);
    }

    public String get(String name) {
        return this.getJobConf().get(name);
    }

    public String get(String name, String defaultValue) {
        return this.getJobConf().get(name, defaultValue);
    }

    public void setMapOutputKeyClass(Class<?> c) {
        this.getJob().setMapOutputKeyClass(c);
    }

    public void setMapOutputValueClass(Class<?> c) {
        this.getJob().setMapOutputValueClass(c);
    }

    public void setMapperClass(Class<?> c) {
        if (org.apache.hadoop.mapred.Mapper.class.isAssignableFrom(c)) {
            this.setUseOldMapApi();
            this.getJobConf().setMapperClass(c);
        } else if (Mapper.class.isAssignableFrom(c)) {
            this.getJob().setMapperClass(c);
        }
    }

    private void setUseOldMapApi() {
        this.set("mapred.mapper.new-api", "false");
    }

    public void setCombinerClass(Class<?> c) {
        if (org.apache.hadoop.mapred.Reducer.class.isAssignableFrom(c)) {
            this.setUseOldRedApi();
            this.getJobConf().setCombinerClass(c);
        } else if (Reducer.class.isAssignableFrom(c)) {
            this.getJob().setCombinerClass(c);
        }
    }

    private void setUseOldRedApi() {
        this.set("mapred.reducer.new-api", "false");
    }

    public void setReducerClass(Class<?> c) {
        if (org.apache.hadoop.mapred.Reducer.class.isAssignableFrom(c)) {
            this.setUseOldRedApi();
            this.getJobConf().setReducerClass(c);
        } else if (Reducer.class.isAssignableFrom(c)) {
            this.getJob().setReducerClass(c);
        }
    }

    public void setOutputKeyClass(Class<?> c) {
        this.getJob().setOutputKeyClass(c);
    }

    public void setOutputValueClass(Class<?> c) {
        this.getJob().setOutputValueClass(c);
    }

    public void setMapRunnerClass(Class<?> c) {
        if (MapRunnable.class.isAssignableFrom(c)) {
            this.getJobConf().setMapRunnerClass(c);
        }
    }

    public void setInputFormat(Class<?> inputFormat) {
        if (org.apache.hadoop.mapred.InputFormat.class.isAssignableFrom(inputFormat)) {
            this.setUseOldMapApi();
            this.getJobConf().setInputFormat(inputFormat);
        } else if (InputFormat.class.isAssignableFrom(inputFormat)) {
            this.getJob().setInputFormatClass(inputFormat);
        }
    }

    public void setOutputFormat(Class<?> outputFormat) {
        if (org.apache.hadoop.mapred.OutputFormat.class.isAssignableFrom(outputFormat)) {
            this.setUseOldRedApi();
            if (this.getJobConf().getNumReduceTasks() == 0 || this.get("mapred.partitioner.class") != null) {
                this.setUseOldMapApi();
            }
            this.getJobConf().setOutputFormat(outputFormat);
        } else if (OutputFormat.class.isAssignableFrom(outputFormat)) {
            this.getJob().setOutputFormatClass(outputFormat);
        }
    }

    public void setInputPaths(Path ... paths) {
        if (paths == null) {
            return;
        }
        org.apache.hadoop.fs.Path[] actualPaths = new org.apache.hadoop.fs.Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            actualPaths[i] = ShimUtils.asPath(paths[i]);
        }
        try {
            FileInputFormat.setInputPaths((Job)this.getJob(), (org.apache.hadoop.fs.Path[])actualPaths);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setOutputPath(Path path) {
        FileOutputFormat.setOutputPath((Job)this.getJob(), (org.apache.hadoop.fs.Path)ShimUtils.asPath(path));
    }

    public void setJarByClass(Class<?> c) {
        this.getJob().setJarByClass(c);
    }

    public void setJar(String url) {
        this.getJob().setJar(url);
    }

    public void setNumMapTasks(int n) {
        this.getJobConf().setNumMapTasks(n);
    }

    public void setNumReduceTasks(int n) {
        this.getJob().setNumReduceTasks(n);
    }

    public void setStrings(String name, String ... values) {
        this.getJobConf().setStrings(name, values);
    }

    public String getDefaultFileSystemURL() {
        return this.get("fs.default.name", "");
    }

    public <T> T getAsDelegateConf(Class<T> delegate) {
        if (delegate.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (delegate.isAssignableFrom(JobConf.class)) {
            return (T)this.getJobConf();
        }
        return null;
    }

    protected class JobProxy
    extends Job {
        private JobProxy(JobConf conf) throws IOException {
            super((org.apache.hadoop.conf.Configuration)conf);
        }

        void refreshUGI() {
            try {
                this.ugi = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

