/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.backlog.log4j;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggerFactory;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.backlog.AbstractSyslogBackLogHandler;

public class Log4jSyslogBackLogHandler
extends AbstractSyslogBackLogHandler {
    protected Logger logger = null;
    protected Level downLevel = Level.WARN;
    protected Level upLevel = Level.WARN;

    public Log4jSyslogBackLogHandler(Logger logger) throws SyslogRuntimeException {
        this.logger = logger;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Logger logger, boolean bl) {
        this.logger = logger;
        this.appendReason = bl;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Class clazz) {
        if (clazz == null) {
            throw new SyslogRuntimeException("loggerClass cannot be null");
        }
        this.logger = Logger.getLogger((Class)clazz);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(Class clazz, boolean bl) {
        if (clazz == null) {
            throw new SyslogRuntimeException("loggerClass cannot be null");
        }
        this.logger = Logger.getLogger((Class)clazz);
        this.appendReason = bl;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String string) {
        if (string == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        this.logger = Logger.getLogger((String)string);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String string, boolean bl) {
        if (string == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        this.logger = Logger.getLogger((String)string);
        this.appendReason = bl;
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String string, LoggerFactory loggerFactory) {
        if (string == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        if (loggerFactory == null) {
            throw new SyslogRuntimeException("loggerFactory cannot be null");
        }
        this.logger = Logger.getLogger((String)string, (LoggerFactory)loggerFactory);
        this.initialize();
    }

    public Log4jSyslogBackLogHandler(String string, LoggerFactory loggerFactory, boolean bl) {
        if (string == null) {
            throw new SyslogRuntimeException("loggerName cannot be null");
        }
        if (loggerFactory == null) {
            throw new SyslogRuntimeException("loggerFactory cannot be null");
        }
        this.logger = Logger.getLogger((String)string, (LoggerFactory)loggerFactory);
        this.appendReason = bl;
        this.initialize();
    }

    public void initialize() throws SyslogRuntimeException {
        if (this.logger == null) {
            throw new SyslogRuntimeException("logger cannot be null");
        }
    }

    protected static Level getLog4jLevel(int n) {
        switch (n) {
            case 7: {
                return Level.DEBUG;
            }
            case 6: {
                return Level.INFO;
            }
            case 5: {
                return Level.INFO;
            }
            case 4: {
                return Level.WARN;
            }
            case 3: {
                return Level.ERROR;
            }
            case 2: {
                return Level.ERROR;
            }
            case 1: {
                return Level.ERROR;
            }
            case 0: {
                return Level.FATAL;
            }
        }
        return Level.WARN;
    }

    public void down(SyslogIF syslogIF, String string) {
        this.logger.log((Priority)this.downLevel, (Object)("Syslog protocol \"" + syslogIF.getProtocol() + "\" is down: " + string));
    }

    public void up(SyslogIF syslogIF) {
        this.logger.log((Priority)this.upLevel, (Object)("Syslog protocol \"" + syslogIF.getProtocol() + "\" is up"));
    }

    public void log(SyslogIF syslogIF, int n, String string, String string2) throws SyslogRuntimeException {
        Level level = Log4jSyslogBackLogHandler.getLog4jLevel(n);
        String string3 = this.combine(syslogIF, n, string, string2);
        this.logger.log((Priority)level, (Object)string3);
    }
}

