/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message.modifier.sequential;

import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogMessageModifierIF;
import org.productivity.java.syslog4j.impl.message.modifier.sequential.SequentialSyslogMessageModifierConfig;

public class SequentialSyslogMessageModifier
implements SyslogMessageModifierIF {
    private static final long serialVersionUID = 6107735010240030785L;
    protected SequentialSyslogMessageModifierConfig config = null;
    protected long[] currentSequence = new long[8];

    public static final SequentialSyslogMessageModifier createDefault() {
        SequentialSyslogMessageModifier sequentialSyslogMessageModifier = new SequentialSyslogMessageModifier(SequentialSyslogMessageModifierConfig.createDefault());
        return sequentialSyslogMessageModifier;
    }

    public SequentialSyslogMessageModifier(SequentialSyslogMessageModifierConfig sequentialSyslogMessageModifierConfig) {
        this.config = sequentialSyslogMessageModifierConfig;
        for (int i = 0; i < 8; ++i) {
            this.currentSequence[i] = sequentialSyslogMessageModifierConfig.getFirstNumber();
        }
    }

    protected String pad(long l) {
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l));
        while ((long)stringBuffer.length() < this.config.getLastNumberDigits()) {
            stringBuffer.insert(0, this.config.getPadChar());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextSequence(int n, long l) {
        if (l >= this.config.getFirstNumber() && l < this.config.getLastNumber()) {
            SequentialSyslogMessageModifier sequentialSyslogMessageModifier = this;
            synchronized (sequentialSyslogMessageModifier) {
                this.currentSequence[n] = l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextSequence(int n) {
        long l = -1L;
        Object object = this;
        synchronized (object) {
            l = this.currentSequence[n];
            if (this.currentSequence[n] >= this.config.getLastNumber()) {
                this.currentSequence[n] = this.config.getFirstNumber();
            } else {
                int n2 = n;
                this.currentSequence[n2] = this.currentSequence[n2] + 1L;
            }
        }
        object = null;
        object = this.config.isUsePadding() ? this.pad(l) : Long.toString(l);
        return object;
    }

    public SequentialSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    public String modify(SyslogIF syslogIF, SyslogConfigIF syslogConfigIF, int n, int n2, String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(this.config.getPrefix());
        stringBuffer.append(this.nextSequence(n2));
        stringBuffer.append(this.config.getSuffix());
        return stringBuffer.toString();
    }
}

