/*
 * Decompiled with CFR 0.152.
 */
package org.drools.builder;

import java.util.Properties;
import org.drools.KnowledgeBase;
import org.drools.ProviderInitializationException;
import org.drools.builder.DecisionTableConfiguration;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderProvider;

public class KnowledgeBuilderFactory {
    private static volatile KnowledgeBuilderProvider provider;

    public static KnowledgeBuilder newKnowledgeBuilder() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderProvider().newKnowledgeBuilder();
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBuilderConfiguration conf) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderProvider().newKnowledgeBuilder(conf);
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderProvider().newKnowledgeBuilder(kbase);
    }

    public static KnowledgeBuilder newKnowledgeBuilder(KnowledgeBase kbase, KnowledgeBuilderConfiguration conf) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderProvider().newKnowledgeBuilder(kbase, conf);
    }

    public static KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderProvider().newKnowledgeBuilderConfiguration();
    }

    public static KnowledgeBuilderConfiguration newKnowledgeBuilderConfiguration(Properties properties, ClassLoader classLoader) {
        return KnowledgeBuilderFactory.getKnowledgeBuilderProvider().newKnowledgeBuilderConfiguration(properties, classLoader);
    }

    public static DecisionTableConfiguration newDecisionTableConfiguration() {
        return KnowledgeBuilderFactory.getKnowledgeBuilderProvider().newDecisionTableConfiguration();
    }

    private static synchronized void setKnowledgeBuilderProvider(KnowledgeBuilderProvider provider) {
        KnowledgeBuilderFactory.provider = provider;
    }

    private static synchronized KnowledgeBuilderProvider getKnowledgeBuilderProvider() {
        if (provider == null) {
            KnowledgeBuilderFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.builder.impl.KnowledgeBuilderProviderImpl");
            KnowledgeBuilderFactory.setKnowledgeBuilderProvider((KnowledgeBuilderProvider)cls.newInstance());
        }
        catch (Exception e2) {
            throw new ProviderInitializationException("Provider org.drools.builder.impl.KnowledgeBuilderProviderImpl could not be set.", e2);
        }
    }
}

