/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.FilterableTable;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.FunctionParameter;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.ScalarFunction;
import net.hydromatic.optiq.ScannableTable;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.config.OptiqConnectionConfigImpl;
import net.hydromatic.optiq.config.OptiqConnectionProperty;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import net.hydromatic.optiq.materialize.Lattice;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.type.SqlTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Schemas {
    private static final com.google.common.base.Function<OptiqSchema.LatticeEntry, OptiqSchema.TableEntry> TO_TABLE_ENTRY = new com.google.common.base.Function<OptiqSchema.LatticeEntry, OptiqSchema.TableEntry>(){

        public OptiqSchema.TableEntry apply(OptiqSchema.LatticeEntry entry) {
            OptiqSchema.TableEntry starTable = entry.getStarTable();
            assert (starTable.getTable().getJdbcTableType() == Schema.TableType.STAR);
            return entry.getStarTable();
        }
    };
    private static final com.google.common.base.Function<OptiqSchema.LatticeEntry, Lattice> TO_LATTICE = new com.google.common.base.Function<OptiqSchema.LatticeEntry, Lattice>(){

        public Lattice apply(OptiqSchema.LatticeEntry entry) {
            return entry.getLattice();
        }
    };

    private Schemas() {
        throw new AssertionError((Object)"no instances!");
    }

    public static OptiqSchema.FunctionEntry resolve(RelDataTypeFactory typeFactory, String name, Collection<OptiqSchema.FunctionEntry> functionEntries, List<RelDataType> argumentTypes) {
        ArrayList<OptiqSchema.FunctionEntry> matches = new ArrayList<OptiqSchema.FunctionEntry>();
        for (OptiqSchema.FunctionEntry entry : functionEntries) {
            if (!Schemas.matches(typeFactory, entry.getFunction(), argumentTypes)) continue;
            matches.add(entry);
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (OptiqSchema.FunctionEntry)matches.get(0);
            }
        }
        throw new RuntimeException("More than one match for " + name + " with arguments " + argumentTypes);
    }

    private static boolean matches(RelDataTypeFactory typeFactory, Function member, List<RelDataType> argumentTypes) {
        List<FunctionParameter> parameters = member.getParameters();
        if (parameters.size() != argumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            FunctionParameter parameter;
            RelDataType argumentType = argumentTypes.get(i);
            if (Schemas.canConvert(argumentType, (parameter = parameters.get(i)).getType(typeFactory))) continue;
            return false;
        }
        return true;
    }

    private static boolean canConvert(RelDataType fromType, RelDataType toType) {
        return SqlTypeUtil.canAssignFrom(toType, fromType);
    }

    public static Expression expression(SchemaPlus schema) {
        return schema.getExpression(schema.getParentSchema(), schema.getName());
    }

    public static Expression subSchemaExpression(SchemaPlus schema, String name, Class type) {
        Expression schemaExpression = Schemas.expression(schema);
        MethodCallExpression call = Expressions.call((Expression)schemaExpression, (Method)BuiltinMethod.SCHEMA_GET_SUB_SCHEMA.method, (Expression[])new Expression[]{Expressions.constant((Object)name)});
        return call;
    }

    public static Expression unwrap(Expression call, Class type) {
        return Expressions.convert_((Expression)Expressions.call((Expression)call, (Method)BuiltinMethod.SCHEMA_PLUS_UNWRAP.method, (Expression[])new Expression[]{Expressions.constant((Object)type)}), (Type)type);
    }

    public static Expression tableExpression(SchemaPlus schema, Type elementType, String tableName, Class clazz) {
        MethodCallExpression expression;
        if (Table.class.isAssignableFrom(clazz)) {
            expression = Expressions.call((Expression)Schemas.expression(schema), (Method)BuiltinMethod.SCHEMA_GET_TABLE.method, (Expression[])new Expression[]{Expressions.constant((Object)tableName)});
            if (ScannableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call((Method)BuiltinMethod.SCHEMAS_ENUMERABLE.method, (Expression[])new Expression[]{Expressions.convert_((Expression)expression, ScannableTable.class), DataContext.ROOT});
            }
            if (FilterableTable.class.isAssignableFrom(clazz)) {
                return Expressions.call((Method)BuiltinMethod.SCHEMAS_ENUMERABLE2.method, (Expression[])new Expression[]{Expressions.convert_((Expression)expression, FilterableTable.class), DataContext.ROOT});
            }
        } else {
            expression = Expressions.call((Method)BuiltinMethod.SCHEMAS_QUERYABLE.method, (Expression[])new Expression[]{DataContext.ROOT, Schemas.expression(schema), Expressions.constant((Object)elementType), Expressions.constant((Object)tableName)});
        }
        return Types.castIfNecessary((Type)clazz, (Expression)expression);
    }

    public static DataContext createDataContext(Connection connection) {
        return new DummyDataContext((OptiqConnection)connection);
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, String ... names) {
        return Schemas.queryable(root, clazz, Arrays.asList(names));
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, Iterable<? extends String> names) {
        String name;
        SchemaPlus schema = root.getRootSchema();
        Iterator<? extends String> iterator = names.iterator();
        while (true) {
            name = iterator.next();
            if (!iterator.hasNext()) break;
            schema = schema.getSubSchema(name);
        }
        return Schemas.queryable(root, schema, clazz, name);
    }

    public static <E> Queryable<E> queryable(DataContext root, SchemaPlus schema, Class<E> clazz, String tableName) {
        QueryableTable table = (QueryableTable)schema.getTable(tableName);
        return table.asQueryable(root.getQueryProvider(), schema, tableName);
    }

    public static Enumerable<Object[]> enumerable(ScannableTable table, DataContext root) {
        return table.scan(root);
    }

    public static Enumerable<Object[]> enumerable(FilterableTable table, DataContext root) {
        return table.scan(root, (List<RexNode>)ImmutableList.of());
    }

    public static Table table(DataContext root, String ... names) {
        String name;
        SchemaPlus schema = root.getRootSchema();
        List<String> nameList = Arrays.asList(names);
        Iterator<String> iterator = nameList.iterator();
        while (true) {
            name = iterator.next();
            if (!iterator.hasNext()) break;
            schema = schema.getSubSchema(name);
        }
        return schema.getTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptiqPrepare.ParseResult parse(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        OptiqPrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, (ImmutableMap<OptiqConnectionProperty, String>)ImmutableMap.of());
        OptiqPrepare.Dummy.push(context);
        try {
            OptiqPrepare.ParseResult parseResult = prepare.parse(context, sql);
            return parseResult;
        }
        finally {
            OptiqPrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptiqPrepare.ConvertResult convert(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        OptiqPrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, (ImmutableMap<OptiqConnectionProperty, String>)ImmutableMap.of());
        OptiqPrepare.Dummy.push(context);
        try {
            OptiqPrepare.ConvertResult convertResult = prepare.convert(context, sql);
            return convertResult;
        }
        finally {
            OptiqPrepare.Dummy.pop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptiqPrepare.PrepareResult<Object> prepare(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql, ImmutableMap<OptiqConnectionProperty, String> map) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        OptiqPrepare.Context context = Schemas.makeContext(connection, schema, schemaPath, map);
        OptiqPrepare.Dummy.push(context);
        try {
            OptiqPrepare.PrepareResult<Object> prepareResult = prepare.prepareSql(context, sql, null, (Type)((Object)Object[].class), -1);
            return prepareResult;
        }
        finally {
            OptiqPrepare.Dummy.pop(context);
        }
    }

    public static OptiqPrepare.Context makeContext(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, ImmutableMap<OptiqConnectionProperty, String> propValues) {
        if (connection == null) {
            OptiqPrepare.Context context0 = OptiqPrepare.Dummy.peek();
            OptiqConnectionConfig config = Schemas.mutate(context0.config(), propValues);
            return Schemas.makeContext(config, context0.getTypeFactory(), context0.getDataContext(), schema, schemaPath);
        }
        OptiqConnectionConfig config = Schemas.mutate(connection.config(), propValues);
        return Schemas.makeContext(config, connection.getTypeFactory(), Schemas.createDataContext(connection), schema, schemaPath);
    }

    private static OptiqConnectionConfig mutate(OptiqConnectionConfig config, ImmutableMap<OptiqConnectionProperty, String> propValues) {
        for (Map.Entry e : propValues.entrySet()) {
            config = ((OptiqConnectionConfigImpl)config).set((OptiqConnectionProperty)((Object)e.getKey()), (String)e.getValue());
        }
        return config;
    }

    private static OptiqPrepare.Context makeContext(final OptiqConnectionConfig connectionConfig, final JavaTypeFactory typeFactory, final DataContext dataContext, final OptiqSchema schema, final List<String> schemaPath) {
        return new OptiqPrepare.Context(){

            @Override
            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            @Override
            public OptiqRootSchema getRootSchema() {
                return schema.root();
            }

            @Override
            public List<String> getDefaultSchemaPath() {
                if (schemaPath == null) {
                    return schema.path(null);
                }
                return schemaPath;
            }

            @Override
            public OptiqConnectionConfig config() {
                return connectionConfig;
            }

            @Override
            public DataContext getDataContext() {
                return dataContext;
            }

            @Override
            public OptiqPrepare.SparkHandler spark() {
                boolean enable = this.config().spark();
                return OptiqPrepare.Dummy.getSparkHandler(enable);
            }
        };
    }

    public static RelProtoDataType proto(final Table table) {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return table.getRowType(typeFactory);
            }
        };
    }

    public static RelProtoDataType proto(final ScalarFunction function) {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return function.getReturnType(typeFactory);
            }
        };
    }

    public static List<OptiqSchema.TableEntry> getStarTables(OptiqSchema schema) {
        List<OptiqSchema.LatticeEntry> list = Schemas.getLatticeEntries(schema);
        return Lists.transform(list, TO_TABLE_ENTRY);
    }

    public static List<Lattice> getLattices(OptiqSchema schema) {
        List<OptiqSchema.LatticeEntry> list = Schemas.getLatticeEntries(schema);
        return Lists.transform(list, TO_LATTICE);
    }

    public static List<OptiqSchema.LatticeEntry> getLatticeEntries(OptiqSchema schema) {
        ArrayList list = Lists.newArrayList();
        Schemas.gatherLattices(schema, list);
        return list;
    }

    private static void gatherLattices(OptiqSchema schema, List<OptiqSchema.LatticeEntry> list) {
        list.addAll(schema.getLatticeMap().values());
        for (OptiqSchema subSchema : schema.getSubSchemaMap().values()) {
            Schemas.gatherLattices(subSchema, list);
        }
    }

    public static OptiqSchema subSchema(OptiqSchema schema, List<String> names) {
        for (String string : names) {
            schema = schema.getSubSchema(string, false);
        }
        return schema;
    }

    public static String uniqueTableName(OptiqSchema schema, String base) {
        String t = (String)Preconditions.checkNotNull((Object)base);
        int x = 0;
        while (schema.getTable(t, true) != null) {
            t = base + x;
            ++x;
        }
        return t;
    }

    private static class DummyDataContext
    implements DataContext {
        private final OptiqConnection connection;
        private final ImmutableMap<String, Object> map;

        public DummyDataContext(OptiqConnection connection) {
            this.connection = connection;
            this.map = ImmutableMap.of((Object)"timeZone", (Object)TimeZone.getDefault());
        }

        public SchemaPlus getRootSchema() {
            return this.connection.getRootSchema();
        }

        public JavaTypeFactory getTypeFactory() {
            return this.connection.getTypeFactory();
        }

        public QueryProvider getQueryProvider() {
            return this.connection;
        }

        public Object get(String name) {
            return this.map.get((Object)name);
        }
    }
}

