/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.config;

import java.util.Properties;
import net.hydromatic.avatica.Casing;
import net.hydromatic.avatica.ConnectionConfigImpl;
import net.hydromatic.avatica.Quoting;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.config.OptiqConnectionConfig;
import net.hydromatic.optiq.config.OptiqConnectionProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptiqConnectionConfigImpl
extends ConnectionConfigImpl
implements OptiqConnectionConfig {
    public OptiqConnectionConfigImpl(Properties properties) {
        super(properties);
    }

    public OptiqConnectionConfigImpl set(OptiqConnectionProperty property, String value) {
        Properties properties1 = new Properties(this.properties);
        properties1.setProperty(property.camelName(), value);
        return new OptiqConnectionConfigImpl(properties1);
    }

    @Override
    public boolean autoTemp() {
        return OptiqConnectionProperty.AUTO_TEMP.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean materializationsEnabled() {
        return OptiqConnectionProperty.MATERIALIZATIONS_ENABLED.wrap(this.properties).getBoolean();
    }

    @Override
    public boolean createMaterializations() {
        return OptiqConnectionProperty.CREATE_MATERIALIZATIONS.wrap(this.properties).getBoolean();
    }

    @Override
    public String model() {
        return OptiqConnectionProperty.MODEL.wrap(this.properties).getString();
    }

    @Override
    public Lex lex() {
        return (Lex)OptiqConnectionProperty.LEX.wrap(this.properties).getEnum(Lex.class);
    }

    @Override
    public Quoting quoting() {
        return (Quoting)OptiqConnectionProperty.QUOTING.wrap(this.properties).getEnum(Quoting.class, (Enum)this.lex().quoting);
    }

    @Override
    public Casing unquotedCasing() {
        return (Casing)OptiqConnectionProperty.UNQUOTED_CASING.wrap(this.properties).getEnum(Casing.class, (Enum)this.lex().unquotedCasing);
    }

    @Override
    public Casing quotedCasing() {
        return (Casing)OptiqConnectionProperty.QUOTED_CASING.wrap(this.properties).getEnum(Casing.class, (Enum)this.lex().quotedCasing);
    }

    @Override
    public boolean caseSensitive() {
        return OptiqConnectionProperty.CASE_SENSITIVE.wrap(this.properties).getBoolean(this.lex().caseSensitive);
    }

    @Override
    public boolean spark() {
        return OptiqConnectionProperty.SPARK.wrap(this.properties).getBoolean();
    }

    @Override
    public <T> T typeSystem(Class<T> typeSystemClass, T defaultTypeSystem) {
        return (T)OptiqConnectionProperty.TYPE_SYSTEM.wrap(this.properties).getPlugin(typeSystemClass, defaultTypeSystem);
    }
}

