/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.AbstractTable;
import net.hydromatic.optiq.materialize.Lattice;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarTable
extends AbstractTable
implements TranslatableTable {
    public final Lattice lattice;
    public final ImmutableList<Table> tables;
    public ImmutableIntList fieldCounts;

    private StarTable(Lattice lattice, ImmutableList<Table> tables) {
        this.lattice = (Lattice)Preconditions.checkNotNull((Object)lattice);
        this.tables = tables;
    }

    public static StarTable of(Lattice lattice, List<Table> tables) {
        return new StarTable(lattice, (ImmutableList<Table>)ImmutableList.copyOf(tables));
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.STAR;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataType> typeList = new ArrayList<RelDataType>();
        ArrayList<Integer> fieldCounts = new ArrayList<Integer>();
        for (Table table : this.tables) {
            RelDataType rowType = table.getRowType(typeFactory);
            typeList.addAll(RelOptUtil.getFieldTypeList(rowType));
            fieldCounts.add(rowType.getFieldCount());
        }
        if (this.fieldCounts == null) {
            this.fieldCounts = ImmutableIntList.copyOf(fieldCounts);
        }
        return typeFactory.createStructType((List<RelDataType>)typeList, (List<String>)this.lattice.uniqueColumnNames);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable table) {
        return new StarTableScan(context.getCluster(), table);
    }

    public StarTable add(Table table) {
        return StarTable.of(this.lattice, (List<Table>)ImmutableList.builder().addAll(this.tables).add((Object)table).build());
    }

    public int columnOffset(Table table) {
        int n = 0;
        for (Pair<Table, Integer> pair : Pair.zip(this.tables, this.fieldCounts)) {
            if (pair.left == table) {
                return n;
            }
            n += ((Integer)pair.right).intValue();
        }
        throw new IllegalArgumentException("star table " + this + " does not contain table " + table);
    }

    public static class StarTableScan
    extends TableAccessRelBase {
        public StarTableScan(RelOptCluster cluster, RelOptTable relOptTable) {
            super(cluster, cluster.traitSetOf(Convention.NONE), relOptTable);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return planner.getCostFactory().makeInfiniteCost();
        }
    }
}

