/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.interpreter;

import net.hydromatic.optiq.impl.interpreter.Context;
import net.hydromatic.optiq.impl.interpreter.Interpreter;
import net.hydromatic.optiq.impl.interpreter.Node;
import net.hydromatic.optiq.impl.interpreter.Row;
import net.hydromatic.optiq.impl.interpreter.Scalar;
import net.hydromatic.optiq.impl.interpreter.Sink;
import net.hydromatic.optiq.impl.interpreter.Source;
import org.eigenbase.rel.FilterRelBase;

public class FilterNode
implements Node {
    private final Scalar condition;
    private final Source source;
    private final Sink sink;
    private final Context context;

    public FilterNode(Interpreter interpreter, FilterRelBase rel) {
        this.condition = interpreter.compile(rel.getCondition());
        this.source = interpreter.source(rel, 0);
        this.sink = interpreter.sink(rel);
        this.context = interpreter.createContext();
    }

    public void run() throws InterruptedException {
        Row row;
        while ((row = this.source.receive()) != null) {
            this.context.values = row.getValues();
            Boolean b = (Boolean)this.condition.execute(this.context);
            if (b == null || !b.booleanValue()) continue;
            this.sink.send(row);
        }
    }
}

