/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.interpreter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.hydromatic.linq4j.AbstractEnumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.impl.interpreter.Context;
import net.hydromatic.optiq.impl.interpreter.Node;
import net.hydromatic.optiq.impl.interpreter.Nodes;
import net.hydromatic.optiq.impl.interpreter.Row;
import net.hydromatic.optiq.impl.interpreter.Scalar;
import net.hydromatic.optiq.impl.interpreter.Sink;
import net.hydromatic.optiq.impl.interpreter.Source;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelVisitor;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.ReflectUtil;
import org.eigenbase.util.ReflectiveVisitDispatcher;
import org.eigenbase.util.ReflectiveVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter
extends AbstractEnumerable<Object[]> {
    final Map<RelNode, NodeInfo> nodes = Maps.newLinkedHashMap();
    private final DataContext dataContext;
    private final RelNode rootRel;
    private final Map<RelNode, List<RelNode>> relInputs = Maps.newHashMap();

    public Interpreter(DataContext dataContext, RelNode rootRel) {
        this.dataContext = dataContext;
        Nodes.CoreCompiler compiler = new Nodes.CoreCompiler(this);
        this.rootRel = compiler.visitRoot(rootRel);
    }

    public Enumerator<Object[]> enumerator() {
        this.start();
        final ArrayDeque<Row> queue = this.nodes.get((Object)this.rootRel).sink.list;
        return new Enumerator<Object[]>(){
            Row row;

            public Object[] current() {
                return this.row.getValues();
            }

            public boolean moveNext() {
                try {
                    this.row = (Row)queue.removeFirst();
                }
                catch (NoSuchElementException e) {
                    return false;
                }
                return true;
            }

            public void reset() {
                this.row = null;
            }

            public void close() {
                Interpreter.this.close();
            }
        };
    }

    private void start() {
        for (Map.Entry<RelNode, NodeInfo> entry : this.nodes.entrySet()) {
            NodeInfo nodeInfo = entry.getValue();
            try {
                nodeInfo.node.run();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void close() {
    }

    public Scalar compile(final RexNode node) {
        if (node instanceof RexCall) {
            final RexCall call = (RexCall)node;
            ImmutableList.Builder list = ImmutableList.builder();
            for (RexNode operand : call.getOperands()) {
                list.add((Object)this.compile(operand));
            }
            final ImmutableList scalars = list.build();
            return new Scalar(){

                @Override
                public Object execute(Context context) {
                    switch (call.getKind()) {
                        case LESS_THAN: 
                        case LESS_THAN_OR_EQUAL: 
                        case GREATER_THAN: 
                        case GREATER_THAN_OR_EQUAL: 
                        case EQUALS: 
                        case NOT_EQUALS: {
                            List<Object> args = this.lazyArgs(context);
                            Comparable o0 = (Comparable)args.get(0);
                            if (o0 == null) {
                                return null;
                            }
                            Comparable o1 = (Comparable)args.get(1);
                            if (o1 == null) {
                                return null;
                            }
                            if (o0 instanceof BigDecimal) {
                                o1 = o1 instanceof Double || o1 instanceof Float ? new BigDecimal(((Number)((Object)o1)).doubleValue()) : new BigDecimal(((Number)((Object)o1)).longValue());
                            }
                            if (o1 instanceof BigDecimal) {
                                o0 = o0 instanceof Double || o0 instanceof Float ? new BigDecimal(((Number)((Object)o0)).doubleValue()) : new BigDecimal(((Number)((Object)o0)).longValue());
                            }
                            int c = o0.compareTo(o1);
                            switch (call.getKind()) {
                                case LESS_THAN: {
                                    return c < 0;
                                }
                                case LESS_THAN_OR_EQUAL: {
                                    return c <= 0;
                                }
                                case GREATER_THAN: {
                                    return c > 0;
                                }
                                case GREATER_THAN_OR_EQUAL: {
                                    return c >= 0;
                                }
                                case EQUALS: {
                                    return c == 0;
                                }
                                case NOT_EQUALS: {
                                    return c != 0;
                                }
                            }
                            throw new AssertionError((Object)("unknown expression " + call));
                        }
                    }
                    throw new AssertionError((Object)("unknown expression " + call));
                }

                private List<Object> lazyArgs(final Context context) {
                    return new AbstractList<Object>(){

                        @Override
                        public Object get(int index) {
                            return ((Scalar)scalars.get(index)).execute(context);
                        }

                        @Override
                        public int size() {
                            return scalars.size();
                        }
                    };
                }
            };
        }
        return new Scalar(){

            public Object execute(Context context) {
                switch (node.getKind()) {
                    case LITERAL: {
                        return ((RexLiteral)node).getValue();
                    }
                    case INPUT_REF: {
                        return context.values[((RexInputRef)node).getIndex()];
                    }
                }
                throw new RuntimeException("unknown expression type " + node);
            }
        };
    }

    public Source source(RelNode rel, int ordinal) {
        RelNode input = this.getInput(rel, ordinal);
        NodeInfo x = this.nodes.get(input);
        if (x == null) {
            throw new AssertionError((Object)("should be registered: " + rel));
        }
        return new ListSource(x.sink);
    }

    private RelNode getInput(RelNode rel, int ordinal) {
        List<RelNode> inputs = this.relInputs.get(rel);
        if (inputs != null) {
            return inputs.get(ordinal);
        }
        return rel.getInput(ordinal);
    }

    public Sink sink(RelNode rel) {
        ArrayDeque queue = new ArrayDeque(1);
        ListSink sink = new ListSink(queue);
        NodeInfo nodeInfo = new NodeInfo(rel, sink);
        this.nodes.put(rel, nodeInfo);
        return sink;
    }

    public Context createContext() {
        return new Context();
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public static class Compiler
    extends RelVisitor
    implements ReflectiveVisitor {
        private final ReflectiveVisitDispatcher<Compiler, RelNode> dispatcher = ReflectUtil.createDispatcher(Compiler.class, RelNode.class);
        protected final Interpreter interpreter;
        protected RelNode rootRel;
        protected RelNode rel;
        protected Node node;
        private static final String REWRITE_METHOD_NAME = "rewrite";
        private static final String VISIT_METHOD_NAME = "visit";

        Compiler(Interpreter interpreter) {
            this.interpreter = interpreter;
        }

        public RelNode visitRoot(RelNode p) {
            this.rootRel = p;
            this.visit(p, 0, null);
            return this.rootRel;
        }

        public void visit(RelNode p, int ordinal, RelNode parent) {
            while (true) {
                this.rel = null;
                boolean found = this.dispatcher.invokeVisitor(this, p, REWRITE_METHOD_NAME);
                if (!found) {
                    throw new AssertionError((Object)"interpreter: no implementation for rewrite");
                }
                if (this.rel == null) break;
                if (OptiqPrepareImpl.DEBUG) {
                    System.out.println("Interpreter: rewrite " + p + " to " + this.rel);
                }
                p = this.rel;
                if (parent != null) {
                    List inputs = (List)this.interpreter.relInputs.get(parent);
                    if (inputs == null) {
                        inputs = Lists.newArrayList(parent.getInputs());
                        this.interpreter.relInputs.put(parent, inputs);
                    }
                    inputs.set(ordinal, p);
                    continue;
                }
                this.rootRel = p;
            }
            List inputs = (List)this.interpreter.relInputs.get(p);
            if (inputs != null) {
                for (int i = 0; i < inputs.size(); ++i) {
                    RelNode input = (RelNode)inputs.get(i);
                    this.visit(input, i, p);
                }
            } else {
                p.childrenAccept(this);
            }
            this.node = null;
            boolean found = this.dispatcher.invokeVisitor(this, p, VISIT_METHOD_NAME);
            if (!found) {
                throw new AssertionError((Object)("interpreter: no implementation for " + p.getClass()));
            }
            NodeInfo nodeInfo = this.interpreter.nodes.get(p);
            assert (nodeInfo != null);
            nodeInfo.node = this.node;
        }

        public void rewrite(RelNode r) {
        }
    }

    private static class ListSource
    implements Source {
        private final ArrayDeque<Row> list;

        public ListSource(ListSink sink) {
            this.list = sink.list;
        }

        public Row receive() {
            try {
                return this.list.remove();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListSink
    implements Sink {
        final ArrayDeque<Row> list;

        private ListSink(ArrayDeque<Row> list) {
            this.list = list;
        }

        @Override
        public void send(Row row) throws InterruptedException {
            this.list.add(row);
        }

        @Override
        public void end() throws InterruptedException {
        }
    }

    private static class NodeInfo {
        final RelNode rel;
        final ListSink sink;
        Node node;

        public NodeInfo(RelNode rel, ListSink sink) {
            this.rel = rel;
            this.sink = sink;
        }
    }
}

