/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.interpreter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.hydromatic.optiq.FilterableTable;
import net.hydromatic.optiq.ProjectableFilterableTable;
import net.hydromatic.optiq.impl.interpreter.FilterNode;
import net.hydromatic.optiq.impl.interpreter.Interpreter;
import net.hydromatic.optiq.impl.interpreter.ProjectNode;
import net.hydromatic.optiq.impl.interpreter.ScanNode;
import net.hydromatic.optiq.impl.interpreter.SortNode;
import net.hydromatic.optiq.impl.interpreter.ValuesNode;
import org.eigenbase.rel.CalcRelBase;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.rel.ValuesRelBase;
import org.eigenbase.rel.rules.FilterTableRule;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Pair;
import org.eigenbase.util.mapping.Mappings;

public class Nodes {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterScanRel
    extends TableAccessRelBase {
        private final ImmutableList<RexNode> filters;
        private final ImmutableIntList projects;

        protected FilterScanRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, ImmutableList<RexNode> filters, ImmutableIntList projects) {
            super(cluster, traits, table);
            this.filters = filters;
            this.projects = projects;
        }
    }

    public static class CoreCompiler
    extends Interpreter.Compiler {
        CoreCompiler(Interpreter interpreter) {
            super(interpreter);
        }

        public void rewrite(ProjectRelBase project) {
            TableAccessRelBase scan;
            RelOptTable table;
            ProjectableFilterableTable projectableFilterableTable;
            RexNode condition;
            RelNode input = project.getChild();
            Mappings.TargetMapping mapping = project.getMapping();
            if (mapping == null) {
                return;
            }
            if (input instanceof FilterRelBase) {
                FilterRelBase filter = (FilterRelBase)input;
                condition = filter.getCondition();
                input = filter.getChild();
            } else {
                condition = project.getCluster().getRexBuilder().makeLiteral(true);
            }
            if (input instanceof TableAccessRelBase && (projectableFilterableTable = (table = (scan = (TableAccessRelBase)input).getTable()).unwrap(ProjectableFilterableTable.class)) != null) {
                FilterTableRule.FilterSplit filterSplit = FilterTableRule.FilterSplit.of(projectableFilterableTable, condition, this.interpreter.getDataContext());
                this.rel = new FilterScanRel(project.getCluster(), project.getTraitSet(), table, filterSplit.acceptedFilters, ImmutableIntList.copyOf(Mappings.asList(mapping.inverse())));
                this.rel = RelOptUtil.createFilter(this.rel, filterSplit.rejectedFilters);
            }
        }

        public void rewrite(FilterRelBase filter) {
            if (filter.getChild() instanceof TableAccessRelBase) {
                FilterableTable filterableTable;
                TableAccessRelBase scan = (TableAccessRelBase)filter.getChild();
                RelOptTable table = scan.getTable();
                ProjectableFilterableTable projectableFilterableTable = table.unwrap(ProjectableFilterableTable.class);
                if (projectableFilterableTable != null) {
                    FilterTableRule.FilterSplit filterSplit = FilterTableRule.FilterSplit.of(projectableFilterableTable, filter.getCondition(), this.interpreter.getDataContext());
                    if (!filterSplit.acceptedFilters.isEmpty()) {
                        this.rel = new FilterScanRel(scan.getCluster(), scan.getTraitSet(), table, filterSplit.acceptedFilters, null);
                        this.rel = RelOptUtil.createFilter(this.rel, filterSplit.rejectedFilters);
                        return;
                    }
                }
                if ((filterableTable = table.unwrap(FilterableTable.class)) != null) {
                    FilterTableRule.FilterSplit filterSplit = FilterTableRule.FilterSplit.of(filterableTable, filter.getCondition(), this.interpreter.getDataContext());
                    if (!filterSplit.acceptedFilters.isEmpty()) {
                        this.rel = new FilterScanRel(scan.getCluster(), scan.getTraitSet(), table, filterSplit.acceptedFilters, null);
                        this.rel = RelOptUtil.createFilter(this.rel, filterSplit.rejectedFilters);
                    }
                }
            }
        }

        public void visit(FilterRelBase filter) {
            this.node = new FilterNode(this.interpreter, filter);
        }

        public void visit(ProjectRelBase project) {
            this.node = new ProjectNode(this.interpreter, project);
        }

        public void rewrite(CalcRelBase calc) {
            Pair<ImmutableList<RexNode>, ImmutableList<RexNode>> projectFilter = calc.getProgram().split();
            this.rel = calc.getChild();
            this.rel = RelOptUtil.createFilter(this.rel, (Iterable)projectFilter.right);
            this.rel = RelOptUtil.createProject(this.rel, (List)projectFilter.left, calc.getRowType().getFieldNames());
        }

        public void visit(ValuesRelBase value) {
            this.node = new ValuesNode(this.interpreter, value);
        }

        public void visit(TableAccessRelBase scan) {
            this.node = new ScanNode(this.interpreter, scan, (ImmutableList<RexNode>)ImmutableList.of(), null);
        }

        public void visit(FilterScanRel scan) {
            this.node = new ScanNode(this.interpreter, scan, (ImmutableList<RexNode>)scan.filters, scan.projects);
        }

        public void visit(SortRel sort) {
            this.node = new SortNode(this.interpreter, sort);
        }
    }
}

