/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.interpreter;

import com.google.common.collect.ImmutableList;
import net.hydromatic.optiq.impl.interpreter.Context;
import net.hydromatic.optiq.impl.interpreter.Interpreter;
import net.hydromatic.optiq.impl.interpreter.Node;
import net.hydromatic.optiq.impl.interpreter.Row;
import net.hydromatic.optiq.impl.interpreter.Scalar;
import net.hydromatic.optiq.impl.interpreter.Sink;
import net.hydromatic.optiq.impl.interpreter.Source;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rex.RexNode;

public class ProjectNode
implements Node {
    private final ImmutableList<Scalar> projects;
    private final Source source;
    private final Sink sink;
    private final Context context;

    public ProjectNode(Interpreter interpreter, ProjectRelBase rel) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RexNode node : rel.getProjects()) {
            builder.add((Object)interpreter.compile(node));
        }
        this.projects = builder.build();
        this.source = interpreter.source(rel, 0);
        this.sink = interpreter.sink(rel);
        this.context = interpreter.createContext();
    }

    public void run() throws InterruptedException {
        Row row;
        while ((row = this.source.receive()) != null) {
            this.context.values = row.getValues();
            Object[] values = new Object[this.projects.size()];
            for (int i = 0; i < this.projects.size(); ++i) {
                Scalar scalar = (Scalar)this.projects.get(i);
                values[i] = scalar.execute(this.context);
            }
            this.sink.send(new Row(values));
        }
    }
}

