/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.interpreter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.FilterableTable;
import net.hydromatic.optiq.ProjectableFilterableTable;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.ScannableTable;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.impl.interpreter.Interpreter;
import net.hydromatic.optiq.impl.interpreter.Node;
import net.hydromatic.optiq.impl.interpreter.Row;
import net.hydromatic.optiq.impl.interpreter.Sink;
import net.hydromatic.optiq.runtime.Enumerables;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanNode
implements Node {
    private final Sink sink;
    private final TableAccessRelBase rel;
    private final ImmutableList<RexNode> filters;
    private final DataContext root;
    private final int[] projects;

    public ScanNode(Interpreter interpreter, TableAccessRelBase rel, ImmutableList<RexNode> filters, ImmutableIntList projects) {
        this.rel = rel;
        this.filters = (ImmutableList)Preconditions.checkNotNull(filters);
        this.projects = projects == null ? null : projects.toIntArray();
        this.sink = interpreter.sink(rel);
        this.root = interpreter.getDataContext();
    }

    @Override
    public void run() throws InterruptedException {
        Enumerable<Row> iterable = this.iterable();
        Enumerator enumerator = iterable.enumerator();
        while (enumerator.moveNext()) {
            this.sink.send((Row)enumerator.current());
        }
        enumerator.close();
        this.sink.end();
    }

    private Enumerable<Row> iterable() {
        RelOptTable table = this.rel.getTable();
        ProjectableFilterableTable pfTable = table.unwrap(ProjectableFilterableTable.class);
        if (pfTable != null) {
            ArrayList filters1 = Lists.newArrayList(this.filters);
            Enumerable<Object[]> enumerator = pfTable.scan(this.root, filters1, this.projects);
            assert (filters1.isEmpty()) : "table could not handle a filter it earlier said it could";
            return Enumerables.toRow(enumerator);
        }
        if (this.projects != null) {
            throw new AssertionError((Object)"have projects, but table cannot handle them");
        }
        FilterableTable filterableTable = table.unwrap(FilterableTable.class);
        if (filterableTable != null) {
            ArrayList filters1 = Lists.newArrayList(this.filters);
            Enumerable<Object[]> enumerator = filterableTable.scan(this.root, filters1);
            assert (filters1.isEmpty()) : "table could not handle a filter it earlier said it could";
            return Enumerables.toRow(enumerator);
        }
        if (!this.filters.isEmpty()) {
            throw new AssertionError((Object)"have filters, but table cannot handle them");
        }
        Enumerable iterable = table.unwrap(Enumerable.class);
        if (iterable != null) {
            return iterable;
        }
        QueryableTable queryableTable = table.unwrap(QueryableTable.class);
        if (queryableTable != null) {
            Type elementType = queryableTable.getElementType();
            SchemaPlus schema = this.root.getRootSchema();
            for (String name : Util.skipLast(table.getQualifiedName())) {
                schema = schema.getSubSchema(name);
            }
            if (elementType instanceof Class) {
                Queryable queryable = Schemas.queryable(this.root, (Class)elementType, table.getQualifiedName());
                ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                Class type = (Class)elementType;
                for (Field field : type.getFields()) {
                    if (!Modifier.isPublic(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                    fieldBuilder.add((Object)field);
                }
                ImmutableList fields = fieldBuilder.build();
                return queryable.select((Function1)new Function1<Object, Row>((List)fields){
                    final /* synthetic */ List val$fields;
                    {
                        this.val$fields = list;
                    }

                    public Row apply(Object o) {
                        Object[] values = new Object[this.val$fields.size()];
                        for (int i = 0; i < this.val$fields.size(); ++i) {
                            Field field = (Field)this.val$fields.get(i);
                            try {
                                values[i] = field.get(o);
                                continue;
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return new Row(values);
                    }
                });
            }
            return Schemas.queryable(this.root, Row.class, table.getQualifiedName());
        }
        ScannableTable scannableTable = table.unwrap(ScannableTable.class);
        if (scannableTable != null) {
            return Enumerables.toRow(scannableTable.scan(this.root));
        }
        throw new AssertionError((Object)("cannot convert table " + table + " to iterable"));
    }
}

