/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.interpreter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.hydromatic.optiq.impl.interpreter.Interpreter;
import net.hydromatic.optiq.impl.interpreter.Node;
import net.hydromatic.optiq.impl.interpreter.Row;
import net.hydromatic.optiq.impl.interpreter.Sink;
import net.hydromatic.optiq.impl.interpreter.Source;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rex.RexLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortNode
implements Node {
    private final Source source;
    private final Sink sink;
    private final SortRel rel;

    public SortNode(Interpreter interpreter, SortRel rel) {
        this.rel = rel;
        this.source = interpreter.source(rel, 0);
        this.sink = interpreter.sink(rel);
    }

    @Override
    public void run() throws InterruptedException {
        block10: {
            int fetch;
            int offset = this.rel.offset == null ? 0 : ((BigDecimal)((RexLiteral)this.rel.offset).getValue()).intValue();
            int n = fetch = this.rel.fetch == null ? -1 : ((BigDecimal)((RexLiteral)this.rel.fetch).getValue()).intValue();
            if (this.rel.getCollation().getFieldCollations().isEmpty()) {
                Row row;
                int i;
                for (i = 0; i < offset; ++i) {
                    row = this.source.receive();
                    if (row != null) {
                        continue;
                    }
                    break block10;
                }
                if (fetch >= 0) {
                    for (i = 0; i < fetch && (row = this.source.receive()) != null; ++i) {
                        this.sink.send(row);
                    }
                } else {
                    while ((row = this.source.receive()) != null) {
                        this.sink.send(row);
                    }
                }
            } else {
                Row row;
                ArrayList list = Lists.newArrayList();
                while ((row = this.source.receive()) != null) {
                    list.add(row);
                }
                Collections.sort(list, this.comparator());
                int end = fetch < 0 || offset + fetch > list.size() ? list.size() : offset + fetch;
                for (int i = offset; i < end; ++i) {
                    this.sink.send((Row)list.get(i));
                }
            }
        }
        this.sink.end();
    }

    private Comparator<Row> comparator() {
        if (this.rel.getCollation().getFieldCollations().size() == 1) {
            return this.comparator(this.rel.getCollation().getFieldCollations().get(0));
        }
        return Ordering.compound((Iterable)Iterables.transform(this.rel.getCollation().getFieldCollations(), (Function)new Function<RelFieldCollation, Comparator<? super Row>>(){

            public Comparator<? super Row> apply(RelFieldCollation input) {
                return SortNode.this.comparator(input);
            }
        }));
    }

    private Comparator<Row> comparator(final RelFieldCollation fieldCollation) {
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return new Comparator<Row>(){
                    final int x;
                    {
                        this.x = fieldCollation.getFieldIndex();
                    }

                    @Override
                    public int compare(Row o1, Row o2) {
                        Comparable c1 = (Comparable)o1.getValues()[this.x];
                        Comparable c2 = (Comparable)o2.getValues()[this.x];
                        return c1.compareTo(c2);
                    }
                };
            }
        }
        return new Comparator<Row>(){
            final int x;
            {
                this.x = fieldCollation.getFieldIndex();
            }

            @Override
            public int compare(Row o1, Row o2) {
                Comparable c1 = (Comparable)o1.getValues()[this.x];
                Comparable c2 = (Comparable)o2.getValues()[this.x];
                return c2.compareTo(c1);
            }
        };
    }
}

