/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.optiq.ModifiableTable;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcImplementor;
import net.hydromatic.optiq.impl.jdbc.JdbcRel;
import net.hydromatic.optiq.impl.jdbc.JdbcToEnumerableConverterRule;
import net.hydromatic.optiq.prepare.Prepare;
import net.hydromatic.optiq.util.BitSets;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRel;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.FilterRelBase;
import org.eigenbase.rel.IntersectRel;
import org.eigenbase.rel.IntersectRelBase;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinInfo;
import org.eigenbase.rel.JoinRel;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.MinusRel;
import org.eigenbase.rel.MinusRelBase;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.SortRel;
import org.eigenbase.rel.TableModificationRel;
import org.eigenbase.rel.TableModificationRelBase;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.rel.ValuesRelBase;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.EquiJoinRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexMultisetUtil;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.sql.JoinConditionType;
import org.eigenbase.sql.JoinType;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlDialect;
import org.eigenbase.sql.SqlFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlJoin;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.SqlSetOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.type.InferTypes;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;
import org.eigenbase.sql.validate.SqlValidatorUtil;
import org.eigenbase.trace.EigenbaseTrace;
import org.eigenbase.util.ImmutableIntList;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcRules {
    protected static final Logger LOGGER = EigenbaseTrace.getPlannerTracer();
    private static final SqlParserPos POS = SqlParserPos.ZERO;
    private static final SqlFunction ISNULL_FUNCTION = new SqlFunction("ISNULL", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, InferTypes.FIRST_KNOWN, OperandTypes.ANY, SqlFunctionCategory.SYSTEM);

    private JdbcRules() {
    }

    public static List<RelOptRule> rules(JdbcConvention out) {
        return ImmutableList.of((Object)new JdbcToEnumerableConverterRule(out), (Object)new JdbcJoinRule(out), (Object)new JdbcCalcRule(out), (Object)new JdbcProjectRule(out), (Object)new JdbcFilterRule(out), (Object)new JdbcAggregateRule(out), (Object)new JdbcSortRule(out), (Object)new JdbcUnionRule(out), (Object)new JdbcIntersectRule(out), (Object)new JdbcMinusRule(out), (Object)new JdbcTableModificationRule(out), (Object)new JdbcValuesRule(out), (Object[])new RelOptRule[0]);
    }

    private static void addSelect(List<SqlNode> selectList, SqlNode node, RelDataType rowType) {
        String name = rowType.getFieldNames().get(selectList.size());
        String alias = SqlValidatorUtil.getAlias(node, -1);
        if (alias == null || !alias.equals(name)) {
            node = SqlStdOperatorTable.AS.createCall(POS, node, new SqlIdentifier(name, POS));
        }
        selectList.add(node);
    }

    private static JdbcImplementor.Result setOpToSql(JdbcImplementor implementor, SqlSetOperator operator, JdbcRel rel) {
        Expressions.FluentList list = Expressions.list();
        for (Ord input : Ord.zip(rel.getInputs())) {
            JdbcImplementor.Result result = implementor.visitChild(input.i, (RelNode)input.e);
            list.add(result.asSelect());
        }
        SqlCall node = operator.createCall(new SqlNodeList((Collection<? extends SqlNode>)list, POS));
        Expressions.FluentList clauses = Expressions.list((Object[])new JdbcImplementor.Clause[]{JdbcImplementor.Clause.SET_OP});
        return implementor.result((SqlNode)node, (Collection<JdbcImplementor.Clause>)clauses, rel);
    }

    private static boolean isStar(List<RexNode> exps, RelDataType inputRowType) {
        int i = 0;
        for (RexNode ref : exps) {
            if (!(ref instanceof RexInputRef)) {
                return false;
            }
            if (((RexInputRef)ref).getIndex() == i++) continue;
            return false;
        }
        return i == inputRowType.getFieldCount();
    }

    private static boolean isStar(RexProgram program) {
        int i = 0;
        for (RexLocalRef ref : program.getProjectList()) {
            if (ref.getIndex() == i++) continue;
            return false;
        }
        return i == program.getInputRowType().getFieldCount();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcValuesRel
    extends ValuesRelBase
    implements JdbcRel {
        JdbcValuesRel(RelOptCluster cluster, RelDataType rowType, List<List<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new JdbcValuesRel(this.getCluster(), this.rowType, this.tuples, traitSet);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            List<String> fields = this.getRowType().getFieldNames();
            List<JdbcImplementor.Clause> clauses = Collections.singletonList(JdbcImplementor.Clause.SELECT);
            JdbcImplementor jdbcImplementor = implementor;
            jdbcImplementor.getClass();
            JdbcImplementor.AliasContext context = jdbcImplementor.new JdbcImplementor.AliasContext(Collections.<Pair<String, RelDataType>>emptyList(), false);
            ArrayList<SqlSelect> selects = new ArrayList<SqlSelect>();
            for (List tuple : this.tuples) {
                ArrayList<SqlCall> selectList = new ArrayList<SqlCall>();
                for (Pair literal : Pair.zip(tuple, fields)) {
                    selectList.add(SqlStdOperatorTable.AS.createCall(POS, context.toSql(null, (RexNode)literal.left), new SqlIdentifier((String)literal.right, POS)));
                }
                selects.add(new SqlSelect(POS, SqlNodeList.EMPTY, new SqlNodeList(selectList, POS), null, null, null, null, null, null, null, null));
            }
            SqlCall query = null;
            for (SqlSelect select : selects) {
                if (query == null) {
                    query = select;
                    continue;
                }
                query = SqlStdOperatorTable.UNION_ALL.createCall(POS, query, select);
            }
            return implementor.result(query, clauses, this);
        }
    }

    public static class JdbcValuesRule
    extends JdbcConverterRule {
        private JdbcValuesRule(JdbcConvention out) {
            super(ValuesRel.class, (RelTrait)Convention.NONE, out, "JdbcValuesRule");
        }

        public RelNode convert(RelNode rel) {
            ValuesRel valuesRel = (ValuesRel)rel;
            return new JdbcValuesRel(valuesRel.getCluster(), valuesRel.getRowType(), valuesRel.getTuples(), valuesRel.getTraitSet().replace(this.out));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcTableModificationRel
    extends TableModificationRelBase
    implements JdbcRel {
        private final Expression expression;

        public JdbcTableModificationRel(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModificationRelBase.Operation operation, List<String> updateColumnList, boolean flattened) {
            super(cluster, traits, table, catalogReader, child, operation, updateColumnList, flattened);
            assert (child.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() instanceof JdbcConvention);
            ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                throw new AssertionError();
            }
            this.expression = table.getExpression(Queryable.class);
            if (this.expression == null) {
                throw new AssertionError();
            }
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcTableModificationRel(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), JdbcTableModificationRel.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.isFlattened());
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            throw new AssertionError();
        }
    }

    public static class JdbcTableModificationRule
    extends JdbcConverterRule {
        private JdbcTableModificationRule(JdbcConvention out) {
            super(TableModificationRel.class, (RelTrait)Convention.NONE, out, "JdbcTableModificationRule");
        }

        public RelNode convert(RelNode rel) {
            TableModificationRel modify = (TableModificationRel)rel;
            ModifiableTable modifiableTable = modify.getTable().unwrap(ModifiableTable.class);
            if (modifiableTable == null) {
                return null;
            }
            RelTraitSet traitSet = modify.getTraitSet().replace(this.out);
            return new JdbcTableModificationRel(modify.getCluster(), traitSet, modify.getTable(), modify.getCatalogReader(), JdbcTableModificationRule.convert(modify.getChild(), traitSet), modify.getOperation(), modify.getUpdateColumnList(), modify.isFlattened());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcMinusRel
    extends MinusRelBase
    implements JdbcRel {
        public JdbcMinusRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcMinusRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcMinusRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            return JdbcRules.setOpToSql(implementor, this.all ? SqlStdOperatorTable.EXCEPT_ALL : SqlStdOperatorTable.EXCEPT, this);
        }
    }

    private static class JdbcMinusRule
    extends JdbcConverterRule {
        private JdbcMinusRule(JdbcConvention out) {
            super(MinusRel.class, (RelTrait)Convention.NONE, out, "JdbcMinusRule");
        }

        public RelNode convert(RelNode rel) {
            MinusRel minus = (MinusRel)rel;
            if (minus.all) {
                return null;
            }
            RelTraitSet traitSet = rel.getTraitSet().replace(this.out);
            return new JdbcMinusRel(rel.getCluster(), traitSet, JdbcMinusRule.convertList(minus.getInputs(), this.out), minus.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcIntersectRel
    extends IntersectRelBase
    implements JdbcRel {
        public JdbcIntersectRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
            assert (!all);
        }

        @Override
        public JdbcIntersectRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcIntersectRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            return JdbcRules.setOpToSql(implementor, this.all ? SqlStdOperatorTable.INTERSECT_ALL : SqlStdOperatorTable.INTERSECT, this);
        }
    }

    private static class JdbcIntersectRule
    extends JdbcConverterRule {
        private JdbcIntersectRule(JdbcConvention out) {
            super(IntersectRel.class, (RelTrait)Convention.NONE, out, "JdbcIntersectRule");
        }

        public RelNode convert(RelNode rel) {
            IntersectRel intersect = (IntersectRel)rel;
            if (intersect.all) {
                return null;
            }
            RelTraitSet traitSet = intersect.getTraitSet().replace(this.out);
            return new JdbcIntersectRel(rel.getCluster(), traitSet, JdbcIntersectRule.convertList(intersect.getInputs(), this.out), intersect.all);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcUnionRel
    extends UnionRelBase
    implements JdbcRel {
        public JdbcUnionRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            super(cluster, traitSet, inputs, all);
        }

        @Override
        public JdbcUnionRel copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
            return new JdbcUnionRel(this.getCluster(), traitSet, inputs, all);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            return super.computeSelfCost(planner).multiplyBy(0.1);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            SqlSetOperator operator = this.all ? SqlStdOperatorTable.UNION_ALL : SqlStdOperatorTable.UNION;
            return JdbcRules.setOpToSql(implementor, operator, this);
        }
    }

    private static class JdbcUnionRule
    extends JdbcConverterRule {
        private JdbcUnionRule(JdbcConvention out) {
            super(UnionRel.class, (RelTrait)Convention.NONE, out, "JdbcUnionRule");
        }

        public RelNode convert(RelNode rel) {
            UnionRel union = (UnionRel)rel;
            RelTraitSet traitSet = union.getTraitSet().replace(this.out);
            return new JdbcUnionRel(rel.getCluster(), traitSet, JdbcUnionRule.convertList(union.getInputs(), this.out), union.all);
        }
    }

    public static class JdbcSortRel
    extends SortRel
    implements JdbcRel {
        public JdbcSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation) {
            super(cluster, traitSet, child, collation);
            assert (this.getConvention() instanceof JdbcConvention);
            assert (this.getConvention() == child.getConvention());
        }

        public JdbcSortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation) {
            return new JdbcSortRel(this.getCluster(), traitSet, newInput, newCollation);
        }

        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getChild());
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.ORDER_BY);
            Expressions.FluentList orderByList = Expressions.list();
            for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                if (fieldCollation.nullDirection != RelFieldCollation.NullDirection.UNSPECIFIED && implementor.dialect.getDatabaseProduct() == SqlDialect.DatabaseProduct.MYSQL) {
                    orderByList.add(ISNULL_FUNCTION.createCall(POS, builder.context.field(fieldCollation.getFieldIndex())));
                    fieldCollation = new RelFieldCollation(fieldCollation.getFieldIndex(), fieldCollation.getDirection());
                }
                orderByList.add(builder.context.toSql(fieldCollation));
            }
            builder.setOrderBy(new SqlNodeList((Collection<? extends SqlNode>)orderByList, POS));
            return builder.result();
        }
    }

    private static class JdbcSortRule
    extends JdbcConverterRule {
        private JdbcSortRule(JdbcConvention out) {
            super(SortRel.class, (RelTrait)Convention.NONE, out, "JdbcSortRule");
        }

        public RelNode convert(RelNode rel) {
            SortRel sort = (SortRel)rel;
            if (sort.offset != null || sort.fetch != null) {
                return null;
            }
            RelTraitSet traitSet = sort.getTraitSet().replace(this.out);
            return new JdbcSortRel(rel.getCluster(), traitSet, JdbcSortRule.convert(sort.getChild(), traitSet), sort.getCollation());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcAggregateRel
    extends AggregateRelBase
    implements JdbcRel {
        public JdbcAggregateRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, BitSet groupSet, List<AggregateCall> aggCalls) throws InvalidRelException {
            super(cluster, traitSet, child, groupSet, aggCalls);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Override
        public JdbcAggregateRel copy(RelTraitSet traitSet, RelNode input, BitSet groupSet, List<AggregateCall> aggCalls) {
            try {
                return new JdbcAggregateRel(this.getCluster(), traitSet, input, groupSet, aggCalls);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getChild());
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.GROUP_BY);
            Expressions.FluentList groupByList = Expressions.list();
            ArrayList selectList = new ArrayList();
            for (int group : BitSets.toIter(this.groupSet)) {
                SqlNode field = builder.context.field(group);
                JdbcRules.addSelect(selectList, field, this.getRowType());
                groupByList.add(field);
            }
            for (AggregateCall aggCall : this.aggCalls) {
                JdbcRules.addSelect(selectList, builder.context.toSql(aggCall), this.rowType);
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
            if (!groupByList.isEmpty() || this.aggCalls.isEmpty()) {
                builder.setGroupBy(new SqlNodeList((Collection<? extends SqlNode>)groupByList, POS));
            }
            return builder.result();
        }
    }

    private static class JdbcAggregateRule
    extends JdbcConverterRule {
        private JdbcAggregateRule(JdbcConvention out) {
            super(AggregateRel.class, (RelTrait)Convention.NONE, out, "JdbcAggregateRule");
        }

        public RelNode convert(RelNode rel) {
            AggregateRel agg = (AggregateRel)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace(this.out);
            try {
                return new JdbcAggregateRel(rel.getCluster(), traitSet, JdbcAggregateRule.convert(agg.getChild(), traitSet), agg.getGroupSet(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    public static class JdbcFilterRel
    extends FilterRelBase
    implements JdbcRel {
        public JdbcFilterRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode condition) {
            super(cluster, traitSet, child, condition);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        public JdbcFilterRel copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
            return new JdbcFilterRel(this.getCluster(), traitSet, input, condition);
        }

        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getChild());
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.WHERE);
            builder.setWhere(builder.context.toSql(null, this.condition));
            return builder.result();
        }
    }

    private static class JdbcFilterRule
    extends ConverterRule {
        private JdbcFilterRule(JdbcConvention out) {
            super(FilterRel.class, Convention.NONE, out, "JdbcFilterRule");
        }

        public RelNode convert(RelNode rel) {
            FilterRel filter = (FilterRel)rel;
            return new JdbcFilterRel(rel.getCluster(), rel.getTraitSet().replace(this.getOutConvention()), JdbcFilterRule.convert(filter.getChild(), filter.getChild().getTraitSet().replace(this.getOutConvention())), filter.getCondition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcProjectRel
    extends ProjectRelBase
    implements JdbcRel {
        public JdbcProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType, int flags) {
            super(cluster, traitSet, child, exps, rowType, flags);
            assert (this.getConvention() instanceof JdbcConvention);
        }

        @Override
        public JdbcProjectRel copy(RelTraitSet traitSet, RelNode input, List<RexNode> exps, RelDataType rowType) {
            return new JdbcProjectRel(this.getCluster(), traitSet, input, exps, rowType, this.flags);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result x = implementor.visitChild(0, this.getChild());
            if (JdbcRules.isStar((List)this.exps, this.getChild().getRowType())) {
                return x;
            }
            JdbcImplementor.Builder builder = x.builder(this, JdbcImplementor.Clause.SELECT);
            ArrayList selectList = new ArrayList();
            for (RexNode ref : this.exps) {
                SqlNode sqlExpr = builder.context.toSql(null, ref);
                JdbcRules.addSelect(selectList, sqlExpr, this.getRowType());
            }
            builder.setSelect(new SqlNodeList(selectList, POS));
            return builder.result();
        }
    }

    private static class JdbcProjectRule
    extends ConverterRule {
        private JdbcProjectRule(JdbcConvention out) {
            super(ProjectRel.class, Convention.NONE, out, "JdbcProjectRule");
        }

        public RelNode convert(RelNode rel) {
            ProjectRel project = (ProjectRel)rel;
            return new JdbcProjectRel(rel.getCluster(), rel.getTraitSet().replace(this.getOutConvention()), JdbcProjectRule.convert(project.getChild(), project.getChild().getTraitSet().replace(this.getOutConvention())), project.getProjects(), project.getRowType(), 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcCalcRel
    extends SingleRel
    implements JdbcRel {
        private final RexProgram program;
        protected final int flags;

        public JdbcCalcRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexProgram program, int flags) {
            super(cluster, traitSet, child);
            assert (this.getConvention() instanceof JdbcConvention);
            this.flags = flags;
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Override
        public RelWriter explainTerms(RelWriter pw) {
            return this.program.explainCalc(super.explainTerms(pw));
        }

        @Override
        public double getRows() {
            return FilterRel.estimateFilteredRows(this.getChild(), this.program);
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double dRows = RelMetadataQuery.getRowCount(this);
            double dCpu = RelMetadataQuery.getRowCount(this.getChild()) * (double)this.program.getExprCount();
            double dIo = 0.0;
            return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
        }

        @Override
        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new JdbcCalcRel(this.getCluster(), traitSet, JdbcCalcRel.sole(inputs), this.program, this.flags);
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Builder builder;
            JdbcImplementor.Result x = implementor.visitChild(0, this.getChild());
            JdbcImplementor.Builder builder2 = builder = this.program.getCondition() != null ? x.builder(this, JdbcImplementor.Clause.FROM, JdbcImplementor.Clause.WHERE) : x.builder(this, JdbcImplementor.Clause.FROM);
            if (!JdbcRules.isStar(this.program)) {
                ArrayList selectList = new ArrayList();
                for (RexLocalRef ref : this.program.getProjectList()) {
                    SqlNode sqlExpr = builder.context.toSql(this.program, ref);
                    JdbcRules.addSelect(selectList, sqlExpr, this.getRowType());
                }
                builder.setSelect(new SqlNodeList(selectList, POS));
            }
            if (this.program.getCondition() != null) {
                builder.setWhere(builder.context.toSql(this.program, this.program.getCondition()));
            }
            return builder.result();
        }
    }

    private static class JdbcCalcRule
    extends JdbcConverterRule {
        private JdbcCalcRule(JdbcConvention out) {
            super(CalcRel.class, (RelTrait)Convention.NONE, out, "JdbcCalcRule");
        }

        public RelNode convert(RelNode rel) {
            CalcRel calc = (CalcRel)rel;
            if (RexMultisetUtil.containsMultiset(calc.getProgram())) {
                return null;
            }
            return new JdbcCalcRel(rel.getCluster(), rel.getTraitSet().replace(this.out), JdbcCalcRule.convert(calc.getChild(), calc.getTraitSet().replace(this.out)), calc.getProgram(), 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JdbcJoinRel
    extends EquiJoinRel
    implements JdbcRel {
        protected JdbcJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
            super(cluster, traits, left, right, condition, leftKeys, rightKeys, joinType, variablesStopped);
        }

        @Override
        public JdbcJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            assert (joinInfo.isEqui());
            try {
                return new JdbcJoinRel(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys, joinType, (Set<String>)this.variablesStopped);
            }
            catch (InvalidRelException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double rowCount = RelMetadataQuery.getRowCount(this);
            return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
        }

        @Override
        public double getRows() {
            boolean leftKey = this.left.isKey(BitSets.of(this.leftKeys));
            boolean rightKey = this.right.isKey(BitSets.of(this.rightKeys));
            double leftRowCount = this.left.getRows();
            double rightRowCount = this.right.getRows();
            if (leftKey && rightKey) {
                return Math.min(leftRowCount, rightRowCount);
            }
            if (leftKey) {
                return rightRowCount;
            }
            if (rightKey) {
                return leftRowCount;
            }
            return leftRowCount * rightRowCount;
        }

        @Override
        public JdbcImplementor.Result implement(JdbcImplementor implementor) {
            JdbcImplementor.Result leftResult = implementor.visitChild(0, this.left);
            JdbcImplementor.Result rightResult = implementor.visitChild(1, this.right);
            SqlCall sqlCondition = null;
            JdbcImplementor.Context leftContext = leftResult.qualifiedContext();
            JdbcImplementor.Context rightContext = rightResult.qualifiedContext();
            for (Pair<Integer, Integer> pair : Pair.zip(this.leftKeys, this.rightKeys)) {
                SqlCall x = SqlStdOperatorTable.EQUALS.createCall(POS, leftContext.field((Integer)pair.left), rightContext.field((Integer)pair.right));
                if (sqlCondition == null) {
                    sqlCondition = x;
                    continue;
                }
                sqlCondition = SqlStdOperatorTable.AND.createCall(POS, sqlCondition, x);
            }
            SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean(false, POS), JdbcJoinRel.joinType(this.joinType).symbol(POS), rightResult.asFrom(), JoinConditionType.ON.symbol(POS), sqlCondition);
            return implementor.result((SqlNode)join, leftResult, rightResult);
        }

        private static JoinType joinType(JoinRelType joinType) {
            switch (joinType) {
                case LEFT: {
                    return JoinType.LEFT;
                }
                case RIGHT: {
                    return JoinType.RIGHT;
                }
                case INNER: {
                    return JoinType.INNER;
                }
                case FULL: {
                    return JoinType.FULL;
                }
            }
            throw new AssertionError((Object)joinType);
        }
    }

    private static class JdbcJoinRule
    extends JdbcConverterRule {
        private JdbcJoinRule(JdbcConvention out) {
            super(JoinRel.class, (RelTrait)Convention.NONE, out, "JdbcJoinRule");
        }

        public RelNode convert(RelNode rel) {
            JoinRel join = (JoinRel)rel;
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : join.getInputs()) {
                if (input.getConvention() != this.getOutTrait()) {
                    input = JdbcJoinRule.convert(input, input.getTraitSet().replace(this.out));
                }
                newInputs.add(input);
            }
            JoinInfo joinInfo = JoinInfo.of((RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getCondition());
            if (!joinInfo.isEqui()) {
                return null;
            }
            try {
                return new JdbcJoinRel(join.getCluster(), join.getTraitSet().replace(this.out), (RelNode)newInputs.get(0), (RelNode)newInputs.get(1), join.getCondition(), joinInfo.leftKeys, joinInfo.rightKeys, join.getJoinType(), join.getVariablesStopped());
            }
            catch (InvalidRelException e) {
                LOGGER.fine(e.toString());
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class JdbcConverterRule
    extends ConverterRule {
        protected final JdbcConvention out;

        public JdbcConverterRule(Class<? extends RelNode> clazz, RelTrait in, JdbcConvention out, String description) {
            super(clazz, in, out, description);
            this.out = out;
        }
    }
}

