/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.hydromatic.linq4j.Linq4j;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.optiq.Function;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableMacro;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.MaterializedViewTable;
import net.hydromatic.optiq.impl.StarTable;
import net.hydromatic.optiq.jdbc.MetadataSchema;
import net.hydromatic.optiq.jdbc.OptiqConnectionImpl;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.materialize.Lattice;
import net.hydromatic.optiq.util.Compatible;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptiqSchema {
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int c = o1.compareToIgnoreCase(o2);
            if (c == 0) {
                c = o1.compareTo(o2);
            }
            return c;
        }
    };
    private final OptiqSchema parent;
    public final Schema schema;
    public final String name;
    public final NavigableMap<String, TableEntry> tableMap = new TreeMap<String, TableEntry>(COMPARATOR);
    private final Multimap<String, FunctionEntry> functionMap = LinkedListMultimap.create();
    private final NavigableMap<String, LatticeEntry> latticeMap = new TreeMap<String, LatticeEntry>(COMPARATOR);
    private final NavigableSet<String> functionNames = new TreeSet<String>(COMPARATOR);
    private final NavigableMap<String, FunctionEntry> nullaryFunctionMap = new TreeMap<String, FunctionEntry>(COMPARATOR);
    private final NavigableMap<String, OptiqSchema> subSchemaMap = new TreeMap<String, OptiqSchema>(COMPARATOR);
    private ImmutableList<ImmutableList<String>> path;
    private boolean cache = true;
    private final Cached<SubSchemaCache> implicitSubSchemaCache;
    private final Cached<NavigableSet<String>> implicitTableCache;
    private final Cached<NavigableSet<String>> implicitFunctionCache;

    public OptiqSchema(OptiqSchema parent, final Schema schema, String name) {
        this.parent = parent;
        this.schema = schema;
        this.name = name;
        assert (parent == null == this instanceof OptiqRootSchema);
        this.implicitSubSchemaCache = new AbstractCached<SubSchemaCache>(){

            @Override
            public SubSchemaCache build() {
                return new SubSchemaCache(OptiqSchema.this, Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getSubSchemaNames())));
            }
        };
        this.implicitTableCache = new AbstractCached<NavigableSet<String>>(){

            @Override
            public NavigableSet<String> build() {
                return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getTableNames()));
            }
        };
        this.implicitFunctionCache = new AbstractCached<NavigableSet<String>>(){

            @Override
            public NavigableSet<String> build() {
                return Compatible.INSTANCE.navigableSet(ImmutableSortedSet.copyOf((Comparator)COMPARATOR, schema.getFunctionNames()));
            }
        };
    }

    public static OptiqRootSchema createRootSchema(boolean addMetadataSchema) {
        OptiqRootSchema rootSchema = new OptiqRootSchema(new OptiqConnectionImpl.RootSchema());
        if (addMetadataSchema) {
            rootSchema.add("metadata", MetadataSchema.INSTANCE);
        }
        return rootSchema;
    }

    public TableEntry add(String tableName, Table table) {
        return this.add(tableName, table, (ImmutableList<String>)ImmutableList.of());
    }

    public TableEntry add(String tableName, Table table, ImmutableList<String> sqls) {
        TableEntryImpl entry = new TableEntryImpl(this, tableName, table, sqls);
        this.tableMap.put(tableName, entry);
        return entry;
    }

    private FunctionEntry add(String name, Function function) {
        FunctionEntryImpl entry = new FunctionEntryImpl(this, name, function);
        this.functionMap.put((Object)name, (Object)entry);
        this.functionNames.add(name);
        if (function.getParameters().isEmpty()) {
            this.nullaryFunctionMap.put(name, entry);
        }
        return entry;
    }

    private LatticeEntry add(String name, Lattice lattice) {
        if (this.latticeMap.containsKey(name)) {
            throw new RuntimeException("Duplicate lattice '" + name + "'");
        }
        LatticeEntryImpl entry = new LatticeEntryImpl(this, name, lattice);
        this.latticeMap.put(name, entry);
        return entry;
    }

    public OptiqRootSchema root() {
        OptiqSchema schema = this;
        while (schema.parent != null) {
            schema = schema.parent;
        }
        return (OptiqRootSchema)schema;
    }

    public List<String> path(String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name != null) {
            list.add(name);
        }
        OptiqSchema s = this;
        while (s != null) {
            if (s.parent != null || !s.name.equals("")) {
                list.add(s.name);
            }
            s = s.parent;
        }
        return ImmutableList.copyOf((Collection)Lists.reverse(list));
    }

    private void setCache(boolean cache) {
        if (cache == this.cache) {
            return;
        }
        long now = System.currentTimeMillis();
        this.implicitSubSchemaCache.enable(now, cache);
        this.implicitTableCache.enable(now, cache);
        this.implicitFunctionCache.enable(now, cache);
        this.cache = cache;
    }

    public final OptiqSchema getSubSchema(String schemaName, boolean caseSensitive) {
        if (caseSensitive) {
            OptiqSchema entry = (OptiqSchema)this.subSchemaMap.get(schemaName);
            if (entry != null) {
                return entry;
            }
            long now = System.currentTimeMillis();
            SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
            if (subSchemaCache.names.contains(schemaName)) {
                return (OptiqSchema)subSchemaCache.cache.getUnchecked((Object)schemaName);
            }
            return null;
        }
        Iterator i$ = OptiqSchema.find(this.subSchemaMap, schemaName).entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry entry = i$.next();
            return (OptiqSchema)entry.getValue();
        }
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        String schemaName2 = subSchemaCache.names.floor(schemaName);
        if (schemaName2 != null) {
            return (OptiqSchema)subSchemaCache.cache.getUnchecked((Object)schemaName2);
        }
        return null;
    }

    public OptiqSchema add(String name, Schema schema) {
        OptiqSchema optiqSchema = new OptiqSchema(this, schema, name);
        this.subSchemaMap.put(name, optiqSchema);
        return optiqSchema;
    }

    public final Pair<String, Table> getTableBySql(String sql) {
        for (TableEntry tableEntry : this.tableMap.values()) {
            if (!tableEntry.sqls.contains(sql)) continue;
            return Pair.of(tableEntry.name, tableEntry.getTable());
        }
        return null;
    }

    public final Pair<String, Table> getTable(String tableName, boolean caseSensitive) {
        Table table;
        if (caseSensitive) {
            Table table2;
            TableEntry entry = (TableEntry)this.tableMap.get(tableName);
            if (entry != null) {
                return Pair.of(tableName, entry.getTable());
            }
            long now = System.currentTimeMillis();
            if (this.implicitTableCache.get(now).contains(tableName) && (table2 = this.schema.getTable(tableName)) != null) {
                return Pair.of(tableName, table2);
            }
            return null;
        }
        Iterator i$ = OptiqSchema.find(this.tableMap, tableName).entrySet().iterator();
        if (i$.hasNext()) {
            Map.Entry entry = i$.next();
            return Pair.of(entry.getKey(), ((TableEntry)entry.getValue()).getTable());
        }
        long now = System.currentTimeMillis();
        NavigableSet<String> implicitTableNames = this.implicitTableCache.get(now);
        String tableName2 = implicitTableNames.floor(tableName);
        if (tableName2 != null && (table = this.schema.getTable(tableName2)) != null) {
            return Pair.of(tableName2, table);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public SchemaPlus plus() {
        return new SchemaPlusImpl();
    }

    public static OptiqSchema from(SchemaPlus plus) {
        return ((SchemaPlusImpl)plus).optiqSchema();
    }

    public List<? extends List<String>> getPath() {
        if (this.path != null) {
            return this.path;
        }
        return ImmutableList.of(this.path(null));
    }

    public NavigableMap<String, OptiqSchema> getSubSchemaMap() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(COMPARATOR);
        long now = System.currentTimeMillis();
        SubSchemaCache subSchemaCache = this.implicitSubSchemaCache.get(now);
        for (String name : subSchemaCache.names) {
            builder.put((Object)name, subSchemaCache.cache.getUnchecked((Object)name));
        }
        builder.putAll(this.subSchemaMap);
        return Compatible.INSTANCE.navigableMap(builder.build());
    }

    public NavigableMap<String, LatticeEntry> getLatticeMap() {
        return Compatible.INSTANCE.immutableNavigableMap(this.latticeMap);
    }

    public NavigableSet<String> getTableNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(COMPARATOR);
        builder.addAll(this.tableMap.keySet());
        builder.addAll((Iterable)this.implicitTableCache.get(System.currentTimeMillis()));
        return Compatible.INSTANCE.navigableSet(builder.build());
    }

    public Collection<Function> getFunctions(String name, boolean caseSensitive) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (caseSensitive) {
            Collection<Function> functions;
            Collection functionEntries = this.functionMap.get((Object)name);
            if (functionEntries != null) {
                for (FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            if ((functions = this.schema.getFunctions(name)) != null) {
                builder.addAll(functions);
            }
        } else {
            for (String name2 : OptiqSchema.find(this.functionNames, name)) {
                Collection functionEntries = this.functionMap.get((Object)name2);
                if (functionEntries == null) continue;
                for (FunctionEntry functionEntry : functionEntries) {
                    builder.add((Object)functionEntry.getFunction());
                }
            }
            for (String name2 : OptiqSchema.find(this.implicitFunctionCache.get(System.currentTimeMillis()), name)) {
                Collection<Function> functions = this.schema.getFunctions(name2);
                if (functions == null) continue;
                builder.addAll(functions);
            }
        }
        return builder.build();
    }

    public NavigableSet<String> getFunctionNames() {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(COMPARATOR);
        builder.addAll((Iterable)this.functionMap.keySet());
        builder.addAll((Iterable)this.implicitFunctionCache.get(System.currentTimeMillis()));
        return Compatible.INSTANCE.navigableSet(builder.build());
    }

    public NavigableMap<String, Table> getTablesBasedOnNullaryFunctions() {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder(COMPARATOR);
        for (Map.Entry entry : this.nullaryFunctionMap.entrySet()) {
            Function function = ((FunctionEntry)entry.getValue()).getFunction();
            if (!(function instanceof TableMacro)) continue;
            assert (function.getParameters().isEmpty());
            TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
            builder.put(entry.getKey(), (Object)table);
        }
        for (String string : this.implicitFunctionCache.get(System.currentTimeMillis())) {
            for (Function function : this.schema.getFunctions(string)) {
                if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                builder.put((Object)string, (Object)table);
            }
        }
        return Compatible.INSTANCE.navigableMap(builder.build());
    }

    public Pair<String, Table> getTableBasedOnNullaryFunction(String tableName, boolean caseSensitive) {
        if (caseSensitive) {
            Function function;
            FunctionEntry functionEntry = (FunctionEntry)this.nullaryFunctionMap.get(tableName);
            if (functionEntry != null && (function = functionEntry.getFunction()) instanceof TableMacro) {
                assert (function.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                return Pair.of(tableName, table);
            }
            for (Function function2 : this.schema.getFunctions(tableName)) {
                if (!(function2 instanceof TableMacro) || !function2.getParameters().isEmpty()) continue;
                TranslatableTable table = ((TableMacro)function2).apply((List<Object>)ImmutableList.of());
                return Pair.of(tableName, table);
            }
        } else {
            for (Map.Entry entry : OptiqSchema.find(this.nullaryFunctionMap, tableName).entrySet()) {
                Function function = ((FunctionEntry)entry.getValue()).getFunction();
                if (!(function instanceof TableMacro)) continue;
                assert (function.getParameters().isEmpty());
                TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                return Pair.of(entry.getKey(), table);
            }
            NavigableSet<String> set = this.implicitFunctionCache.get(System.currentTimeMillis());
            for (String s : OptiqSchema.find(set, tableName)) {
                for (Function function : this.schema.getFunctions(s)) {
                    if (!(function instanceof TableMacro) || !function.getParameters().isEmpty()) continue;
                    TranslatableTable table = ((TableMacro)function).apply((List<Object>)ImmutableList.of());
                    return Pair.of(s, table);
                }
            }
        }
        return null;
    }

    private static <V> NavigableMap<String, V> find(NavigableMap<String, V> map, String s) {
        assert (map.comparator() == COMPARATOR);
        return map.subMap(s.toUpperCase(), true, s.toLowerCase(), true);
    }

    private static Iterable<String> find(NavigableSet<String> set, String name) {
        assert (set.comparator() == COMPARATOR);
        return set.subSet(name.toUpperCase(), true, name.toLowerCase(), true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubSchemaCache {
        final NavigableSet<String> names;
        final LoadingCache<String, OptiqSchema> cache;

        private SubSchemaCache(final OptiqSchema optiqSchema, NavigableSet<String> names) {
            this.names = names;
            this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, OptiqSchema>(){

                public OptiqSchema load(String schemaName) {
                    Schema subSchema = optiqSchema.schema.getSubSchema(schemaName);
                    if (subSchema == null) {
                        throw new RuntimeException("sub-schema " + schemaName + " not found");
                    }
                    return new OptiqSchema(optiqSchema, subSchema, schemaName);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractCached<T>
    implements Cached<T> {
        T t;
        long checked = Long.MIN_VALUE;

        private AbstractCached() {
        }

        @Override
        public T get(long now) {
            if (!OptiqSchema.this.cache) {
                return this.build();
            }
            if (this.checked == Long.MIN_VALUE || OptiqSchema.this.schema.contentsHaveChangedSince(this.checked, now)) {
                this.t = this.build();
            }
            this.checked = now;
            return this.t;
        }

        @Override
        public void enable(long now, boolean enabled) {
            if (!enabled) {
                this.t = null;
            }
            this.checked = Long.MIN_VALUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Cached<T> {
        public T get(long var1);

        public T build();

        public void enable(long var1, boolean var3);
    }

    public static class LatticeEntryImpl
    extends LatticeEntry {
        private final Lattice lattice;
        private final TableEntry starTableEntry;

        public LatticeEntryImpl(OptiqSchema schema, String name, Lattice lattice) {
            super(schema, name);
            this.lattice = lattice;
            StarTable starTable = lattice.createStarTable();
            this.starTableEntry = schema.add(name, starTable);
        }

        public Lattice getLattice() {
            return this.lattice;
        }

        public TableEntry getStarTable() {
            return this.starTableEntry;
        }
    }

    public static class FunctionEntryImpl
    extends FunctionEntry {
        private final Function function;

        public FunctionEntryImpl(OptiqSchema schema, String name, Function function) {
            super(schema, name);
            this.function = function;
        }

        public Function getFunction() {
            return this.function;
        }

        public boolean isMaterialization() {
            return this.function instanceof MaterializedViewTable.MaterializedViewTableMacro;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TableEntryImpl
    extends TableEntry {
        private final Table table;

        public TableEntryImpl(OptiqSchema schema, String name, Table table, ImmutableList<String> sqls) {
            super(schema, name, sqls);
            assert (table != null);
            this.table = (Table)Preconditions.checkNotNull((Object)table);
        }

        @Override
        public Table getTable() {
            return this.table;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SchemaPlusImpl
    implements SchemaPlus {
        private SchemaPlusImpl() {
        }

        public OptiqSchema optiqSchema() {
            return OptiqSchema.this;
        }

        @Override
        public SchemaPlus getParentSchema() {
            return OptiqSchema.this.parent == null ? null : OptiqSchema.this.parent.plus();
        }

        @Override
        public String getName() {
            return OptiqSchema.this.getName();
        }

        @Override
        public boolean isMutable() {
            return OptiqSchema.this.schema.isMutable();
        }

        @Override
        public void setCacheEnabled(boolean cache) {
            OptiqSchema.this.setCache(cache);
        }

        @Override
        public boolean isCacheEnabled() {
            return OptiqSchema.this.cache;
        }

        @Override
        public boolean contentsHaveChangedSince(long lastCheck, long now) {
            return OptiqSchema.this.schema.contentsHaveChangedSince(lastCheck, now);
        }

        @Override
        public Expression getExpression(SchemaPlus parentSchema, String name) {
            return OptiqSchema.this.schema.getExpression(parentSchema, name);
        }

        @Override
        public Table getTable(String name) {
            Pair<String, Table> pair = OptiqSchema.this.getTable(name, true);
            return pair == null ? null : pair.getValue();
        }

        public NavigableSet<String> getTableNames() {
            return OptiqSchema.this.getTableNames();
        }

        @Override
        public Collection<Function> getFunctions(String name) {
            return OptiqSchema.this.getFunctions(name, true);
        }

        public NavigableSet<String> getFunctionNames() {
            return OptiqSchema.this.getFunctionNames();
        }

        @Override
        public SchemaPlus getSubSchema(String name) {
            OptiqSchema subSchema = OptiqSchema.this.getSubSchema(name, true);
            return subSchema == null ? null : subSchema.plus();
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return OptiqSchema.this.getSubSchemaMap().keySet();
        }

        @Override
        public SchemaPlus add(String name, Schema schema) {
            OptiqSchema optiqSchema = OptiqSchema.this.add(name, schema);
            return optiqSchema.plus();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            if (clazz.isInstance(this)) {
                return clazz.cast(this);
            }
            if (clazz.isInstance(OptiqSchema.this)) {
                return clazz.cast(OptiqSchema.this);
            }
            if (clazz.isInstance(OptiqSchema.this.schema)) {
                return clazz.cast(OptiqSchema.this.schema);
            }
            throw new ClassCastException("not a " + clazz);
        }

        @Override
        public void setPath(ImmutableList<ImmutableList<String>> path) {
            OptiqSchema.this.path = path;
        }

        @Override
        public void add(String name, Table table) {
            OptiqSchema.this.add(name, table);
        }

        @Override
        public void add(String name, Function function) {
            OptiqSchema.this.add(name, function);
        }

        @Override
        public void add(String name, Lattice lattice) {
            OptiqSchema.this.add(name, lattice);
        }
    }

    public static abstract class LatticeEntry
    extends Entry {
        public LatticeEntry(OptiqSchema schema, String name) {
            super(schema, name);
        }

        public abstract Lattice getLattice();

        public abstract TableEntry getStarTable();
    }

    public static abstract class FunctionEntry
    extends Entry {
        public FunctionEntry(OptiqSchema schema, String name) {
            super(schema, name);
        }

        public abstract Function getFunction();

        public abstract boolean isMaterialization();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TableEntry
    extends Entry {
        public final List<String> sqls;

        public TableEntry(OptiqSchema schema, String name, ImmutableList<String> sqls) {
            super(schema, name);
            this.sqls = (List)Preconditions.checkNotNull(sqls);
        }

        public abstract Table getTable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Entry {
        public final OptiqSchema schema;
        public final String name;

        public Entry(OptiqSchema schema, String name) {
            Linq4j.requireNonNull((Object)schema);
            Linq4j.requireNonNull((Object)name);
            this.schema = schema;
            this.name = name;
        }

        public final List<String> path() {
            return this.schema.path(this.name);
        }
    }
}

